/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.LoginRequest;
import org.apache.james.imap.processor.AbstractAuthProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;

public class LoginProcessor
extends AbstractAuthProcessor<LoginRequest>
implements CapabilityImplementingProcessor {
    private static final List<Capability> LOGINDISABLED_CAPS = ImmutableList.of((Object)Capability.of("LOGINDISABLED"));

    @Inject
    public LoginProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(LoginRequest.class, mailboxManager, factory, metricFactory);
    }

    @Override
    protected void processRequest(LoginRequest request, ImapSession session, ImapProcessor.Responder responder) {
        if (session.isPlainAuthDisallowed()) {
            this.no(request, responder, HumanReadableText.DISABLED_LOGIN);
        } else {
            this.doAuth(LoginProcessor.noDelegation(request.getUserid(), request.getPassword()), session, request, responder, HumanReadableText.INVALID_LOGIN);
        }
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        if (session.isPlainAuthDisallowed()) {
            return LOGINDISABLED_CAPS;
        }
        return Collections.emptyList();
    }

    @Override
    protected MDCBuilder mdc(LoginRequest request) {
        return MDCBuilder.create().addToContext("action", "LOGIN").addToContext("login-user", request.getUserid().asString());
    }
}

