/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseEncoder;
import org.apache.james.imap.message.response.ExistsResponse;

public class ExistsResponseEncoder
implements ImapResponseEncoder<ExistsResponse> {
    public static final byte[] EXISTS = "EXISTS".getBytes(StandardCharsets.US_ASCII);

    @Override
    public Class<ExistsResponse> acceptableMessages() {
        return ExistsResponse.class;
    }

    @Override
    public void encode(ExistsResponse existsResponse, ImapResponseComposer composer) throws IOException {
        long numberOfMessages = existsResponse.getNumberOfMessages();
        composer.untagged().message(numberOfMessages).message(EXISTS).end();
    }
}

