/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import com.google.common.base.Preconditions;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.RollbackException;
import javax.persistence.TypedQuery;
import org.apache.james.core.Username;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.jpa.JPAId;
import org.apache.james.mailbox.jpa.JPATransactionalMapper;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.store.MailboxExpressionBackwardCompatibility;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class JPAMailboxMapper
extends JPATransactionalMapper
implements MailboxMapper {
    private static final char SQL_WILDCARD_CHAR = '%';
    private String lastMailboxName;

    public JPAMailboxMapper(EntityManagerFactory entityManagerFactory) {
        super(entityManagerFactory);
    }

    @Override
    protected void commit() throws MailboxException {
        try {
            this.getEntityManager().getTransaction().commit();
        }
        catch (PersistenceException e) {
            Throwable t;
            if (e instanceof EntityExistsException) {
                throw new MailboxExistsException(this.lastMailboxName);
            }
            if (e instanceof RollbackException && (t = e.getCause()) instanceof EntityExistsException) {
                throw new MailboxExistsException(this.lastMailboxName);
            }
            throw new MailboxException("Commit of transaction failed", (Throwable)e);
        }
    }

    public Mono<Mailbox> create(MailboxPath mailboxPath, UidValidity uidValidity) {
        return this.assertPathIsNotAlreadyUsedByAnotherMailbox(mailboxPath).then(Mono.fromCallable(() -> {
            this.lastMailboxName = mailboxPath.getName();
            JPAMailbox persistedMailbox = new JPAMailbox(mailboxPath, uidValidity);
            this.getEntityManager().persist((Object)persistedMailbox);
            return new Mailbox(mailboxPath, uidValidity, (MailboxId)persistedMailbox.getMailboxId());
        })).onErrorMap(PersistenceException.class, e -> new MailboxException("Save of mailbox " + mailboxPath.getName() + " failed", (Throwable)e));
    }

    public Mono<MailboxId> rename(Mailbox mailbox) {
        Preconditions.checkNotNull((Object)mailbox.getMailboxId(), (Object)"A mailbox we want to rename should have a defined mailboxId");
        return this.assertPathIsNotAlreadyUsedByAnotherMailbox(mailbox.generateAssociatedPath()).then(Mono.fromCallable(() -> {
            this.lastMailboxName = mailbox.getName();
            JPAMailbox persistedMailbox = this.jpaMailbox(mailbox);
            this.getEntityManager().persist((Object)persistedMailbox);
            return persistedMailbox.getMailboxId();
        })).onErrorMap(PersistenceException.class, e -> new MailboxException("Save of mailbox " + mailbox.getName() + " failed", (Throwable)e));
    }

    private JPAMailbox jpaMailbox(Mailbox mailbox) throws MailboxException {
        JPAMailbox result = this.loadJpaMailbox(mailbox.getMailboxId());
        result.setNamespace(mailbox.getNamespace());
        result.setUser(mailbox.getUser().asString());
        result.setName(mailbox.getName());
        return result;
    }

    private Mono<Void> assertPathIsNotAlreadyUsedByAnotherMailbox(MailboxPath mailboxPath) {
        return this.findMailboxByPath(mailboxPath).flatMap(ignored -> Mono.error((Throwable)new MailboxExistsException(mailboxPath.getName())));
    }

    public Mono<Mailbox> findMailboxByPath(MailboxPath mailboxPath) {
        return Mono.fromCallable(() -> ((JPAMailbox)this.getEntityManager().createNamedQuery("findMailboxByNameWithUser", JPAMailbox.class).setParameter("nameParam", (Object)mailboxPath.getName()).setParameter("namespaceParam", (Object)mailboxPath.getNamespace()).setParameter("userParam", (Object)mailboxPath.getUser().asString()).getSingleResult()).toMailbox()).onErrorResume(NoResultException.class, e -> Mono.empty()).onErrorResume(PersistenceException.class, e -> Mono.error((Throwable)new MailboxException("Exception upon JPA execution", (Throwable)e)));
    }

    public Mono<Mailbox> findMailboxById(MailboxId id) {
        return Mono.fromCallable(() -> this.loadJpaMailbox(id).toMailbox()).onErrorMap(PersistenceException.class, e -> new MailboxException("Search of mailbox " + id.serialize() + " failed", (Throwable)e));
    }

    private JPAMailbox loadJpaMailbox(MailboxId id) throws MailboxNotFoundException {
        JPAId mailboxId = (JPAId)id;
        try {
            return (JPAMailbox)this.getEntityManager().createNamedQuery("findMailboxById", JPAMailbox.class).setParameter("idParam", (Object)mailboxId.getRawId()).getSingleResult();
        }
        catch (NoResultException e) {
            throw new MailboxNotFoundException((MailboxId)mailboxId);
        }
    }

    public Mono<Void> delete(Mailbox mailbox) {
        return Mono.fromRunnable(() -> {
            JPAId mailboxId = (JPAId)mailbox.getMailboxId();
            this.getEntityManager().createNamedQuery("deleteMessages").setParameter("idParam", (Object)mailboxId.getRawId()).executeUpdate();
            JPAMailbox jpaMailbox = (JPAMailbox)this.getEntityManager().find(JPAMailbox.class, (Object)mailboxId.getRawId());
            this.getEntityManager().remove((Object)jpaMailbox);
        }).onErrorMap(PersistenceException.class, e -> new MailboxException("Delete of mailbox " + mailbox + " failed", (Throwable)e)).then();
    }

    public Flux<Mailbox> findMailboxWithPathLike(MailboxQuery.UserBound query) {
        String pathLike = MailboxExpressionBackwardCompatibility.getPathLike((MailboxQuery)query);
        return Mono.fromCallable(() -> this.findMailboxWithPathLikeTypedQuery(query.getFixedNamespace(), query.getFixedUser(), pathLike)).flatMapIterable(TypedQuery::getResultList).map(JPAMailbox::toMailbox).filter(arg_0 -> ((MailboxQuery.UserBound)query).matches(arg_0)).onErrorMap(PersistenceException.class, e -> new MailboxException("Search of mailbox " + query + " failed", (Throwable)e));
    }

    private TypedQuery<JPAMailbox> findMailboxWithPathLikeTypedQuery(String namespace, Username username, String pathLike) {
        return this.getEntityManager().createNamedQuery("findMailboxWithNameLikeWithUser", JPAMailbox.class).setParameter("nameParam", (Object)pathLike).setParameter("namespaceParam", (Object)namespace).setParameter("userParam", (Object)username.asString());
    }

    public Mono<Boolean> hasChildren(Mailbox mailbox, char delimiter) {
        String name = mailbox.getName() + delimiter + "%";
        return Mono.defer(() -> Mono.justOrEmpty((Object)((Long)this.getEntityManager().createNamedQuery("countMailboxesWithNameLikeWithUser").setParameter("nameParam", (Object)name).setParameter("namespaceParam", (Object)mailbox.getNamespace()).setParameter("userParam", (Object)mailbox.getUser().asString()).getSingleResult()))).filter(numberOfChildMailboxes -> numberOfChildMailboxes > 0L).hasElement();
    }

    public Flux<Mailbox> list() {
        return Mono.fromCallable(() -> this.getEntityManager().createNamedQuery("listMailboxes", JPAMailbox.class)).flatMapIterable(TypedQuery::getResultList).onErrorMap(PersistenceException.class, e -> new MailboxException("Delete of mailboxes failed", (Throwable)e)).map(JPAMailbox::toMailbox);
    }

    public Mono<ACLDiff> updateACL(Mailbox mailbox, MailboxACL.ACLCommand mailboxACLCommand) {
        return Mono.fromCallable(() -> {
            MailboxACL oldACL = mailbox.getACL();
            MailboxACL newACL = mailbox.getACL().apply(mailboxACLCommand);
            mailbox.setACL(newACL);
            return ACLDiff.computeDiff((MailboxACL)oldACL, (MailboxACL)newACL);
        });
    }

    public Mono<ACLDiff> setACL(Mailbox mailbox, MailboxACL mailboxACL) {
        return Mono.fromCallable(() -> {
            MailboxACL oldMailboxAcl = mailbox.getACL();
            mailbox.setACL(mailboxACL);
            return ACLDiff.computeDiff((MailboxACL)oldMailboxAcl, (MailboxACL)mailboxACL);
        });
    }

    public Flux<Mailbox> findNonPersonalMailboxes(Username userName, MailboxACL.Right right) {
        return Flux.empty();
    }
}

