/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.jms;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.lambdas.Throwing;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.collections.iterators.EnumerationIterator;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.metrics.api.Gauge;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.queue.api.MailPrioritySupport;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.jms.JMSMailQueueItem;
import org.apache.james.queue.jms.JMSSupport;
import org.apache.james.queue.jms.MimeMessageObjectMessageSource;
import org.apache.james.server.core.MailImpl;
import org.apache.james.server.core.MimeMessageSource;
import org.apache.james.server.core.MimeMessageWrapper;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class JMSCacheableMailQueue
implements ManageableMailQueue,
JMSSupport,
MailPrioritySupport,
Disposable {
    private final Flux<MailQueue.MailQueueItem> flux;
    private static final Logger LOGGER = LoggerFactory.getLogger(JMSCacheableMailQueue.class);
    public static final String FORCE_DELIVERY = "FORCE_DELIVERY";
    protected final MailQueueName queueName;
    protected final Connection connection;
    protected final MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory;
    protected final Metric enqueuedMailsMetric;
    protected final Metric dequeuedMailsMetric;
    protected final MetricFactory metricFactory;
    protected final GaugeRegistry gaugeRegistry;
    protected final Session session;
    protected final Queue queue;
    protected final MessageProducer producer;
    private final Joiner joiner;
    private final Splitter splitter;

    protected static void closeSession(Session session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    protected static void closeProducer(MessageProducer producer) {
        if (producer != null) {
            try {
                producer.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    protected static void closeConsumer(MessageConsumer consumer) {
        if (consumer != null) {
            try {
                consumer.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    protected static void rollback(Session session) {
        if (session != null) {
            try {
                session.rollback();
            }
            catch (JMSException e) {
                LOGGER.error("Error while rolling session back", (Throwable)e);
            }
        }
    }

    private static void closeBrowser(QueueBrowser browser) {
        if (browser != null) {
            try {
                browser.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    public JMSCacheableMailQueue(ConnectionFactory connectionFactory, MailQueueItemDecoratorFactory mailQueueItemDecoratorFactory, MailQueueName queueName, MetricFactory metricFactory, GaugeRegistry gaugeRegistry) {
        try {
            this.connection = connectionFactory.createConnection();
            this.connection.start();
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        this.mailQueueItemDecoratorFactory = mailQueueItemDecoratorFactory;
        this.queueName = queueName;
        this.metricFactory = metricFactory;
        this.enqueuedMailsMetric = metricFactory.generate("enqueuedMail:" + queueName.asString());
        this.dequeuedMailsMetric = metricFactory.generate("dequeuedMail:" + queueName.asString());
        this.gaugeRegistry = gaugeRegistry;
        this.gaugeRegistry.register("mailQueueSize:" + queueName.asString(), this.queueSizeGauge());
        this.joiner = Joiner.on((String)";").skipNulls();
        this.splitter = Splitter.on((String)";").omitEmptyStrings().trimResults();
        try {
            this.session = this.connection.createSession(false, 1);
            this.queue = this.session.createQueue(queueName.asString());
            this.producer = this.session.createProducer((Destination)this.queue);
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        this.flux = Mono.defer(this::deQueueOneItem).repeat();
    }

    public void close() {
    }

    public MailQueueName getName() {
        return this.queueName;
    }

    public Flux<MailQueue.MailQueueItem> deQueue() {
        return this.flux;
    }

    private Mono<MailQueue.MailQueueItem> deQueueOneItem() {
        Session session = null;
        MessageConsumer consumer = null;
        try {
            session = this.connection.createSession(true, 0);
            Queue queue = session.createQueue(this.queueName.asString());
            consumer = session.createConsumer((Destination)queue, this.getMessageSelector());
            Message message = consumer.receive(10000L);
            if (message != null) {
                this.dequeuedMailsMetric.increment();
                return this.createMailQueueItem(session, consumer, message);
            }
            session.commit();
            JMSCacheableMailQueue.closeConsumer(consumer);
            JMSCacheableMailQueue.closeSession(session);
        }
        catch (Exception e) {
            JMSCacheableMailQueue.rollback(session);
            JMSCacheableMailQueue.closeConsumer(consumer);
            JMSCacheableMailQueue.closeSession(session);
            return Mono.error((Throwable)new MailQueue.MailQueueException("Unable to dequeue next message", e));
        }
        return Mono.empty();
    }

    public void enQueue(Mail mail, Duration delay) throws MailQueue.MailQueueException {
        TimeMetric timeMetric = this.metricFactory.timer("enqueueTime:" + this.queueName.asString());
        long nextDeliveryTimestamp = this.computeNextDeliveryTimestamp(delay);
        try {
            int msgPrio = AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)MAIL_PRIORITY, Integer.class).orElse(5);
            Map<String, Object> props = this.getJMSProperties(mail, nextDeliveryTimestamp);
            this.produceMail(props, msgPrio, mail);
            this.enqueuedMailsMetric.increment();
        }
        catch (Exception e) {
            throw new MailQueue.MailQueueException("Unable to enqueue mail " + mail, e);
        }
        finally {
            timeMetric.stopAndPublish();
        }
    }

    public long computeNextDeliveryTimestamp(Duration delay) {
        if (!delay.isNegative()) {
            try {
                return ZonedDateTime.now().plus(delay).toInstant().toEpochMilli();
            }
            catch (ArithmeticException | DateTimeException e) {
                LOGGER.warn("The {} was caused by conversation {} followed by addition to current timestamp. Falling back to Long.MAX_VALUE.", (Object)e.getMessage(), (Object)delay);
                return Long.MAX_VALUE;
            }
        }
        return -1L;
    }

    public void enQueue(Mail mail) throws MailQueue.MailQueueException {
        this.enQueue(mail, -1L, TimeUnit.MILLISECONDS);
    }

    public Publisher<Void> enqueueReactive(Mail mail) {
        return Mono.fromRunnable((Runnable)Throwing.runnable(() -> this.enQueue(mail)).sneakyThrow());
    }

    protected void produceMail(Map<String, Object> props, int msgPrio, Mail mail) throws JMSException, MessagingException, IOException {
        ObjectMessage message = this.session.createObjectMessage();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            message.setObjectProperty(entry.getKey(), entry.getValue());
        }
        long size = mail.getMessageSize();
        ByteArrayOutputStream out = size > -1L ? new ByteArrayOutputStream((int)size) : new ByteArrayOutputStream();
        mail.getMessage().writeTo((OutputStream)out);
        message.setObject((Serializable)out.toByteArray());
        this.producer.send((Message)message, 2, msgPrio, 0L);
    }

    protected Map<String, Object> getJMSProperties(Mail mail, long nextDelivery) throws MessagingException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("JAMES_NEXT_DELIVERY", nextDelivery);
        props.put("JAMES_MAIL_ERROR_MESSAGE", mail.getErrorMessage());
        props.put("JAMES_MAIL_LAST_UPDATED", mail.getLastUpdated().getTime());
        props.put("JAMES_MAIL_MESSAGE_SIZE", mail.getMessageSize());
        props.put("JAMES_MAIL_NAME", mail.getName());
        mail.getPerRecipientSpecificHeaders().getHeadersByRecipient().asMap().forEach((recipient, headers) -> props.put("JAMES_MAIL_PER_RECIPIENT_HEADERS-" + recipient.asString(), Joiner.on((char)'\n').join((Iterable)headers.stream().map(PerRecipientHeaders.Header::asString).collect(ImmutableList.toImmutableList()))));
        String recipientsAsString = this.joiner.join((Iterable)mail.getRecipients());
        props.put("JAMES_MAIL_RECIPIENTS", recipientsAsString);
        props.put("JAMES_MAIL_REMOTEADDR", mail.getRemoteAddr());
        props.put("JAMES_MAIL_REMOTEHOST", mail.getRemoteHost());
        String sender = mail.getMaybeSender().asString("");
        props.putAll((Map)mail.attributes().flatMap(attribute -> attribute.getValue().toJson().map(JsonNode::toString).map(s -> Pair.of((Object)attribute.getName().asString(), (Object)s)).stream()).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue)));
        ImmutableList attributeNames = (ImmutableList)mail.attributeNames().map(AttributeName::asString).collect(ImmutableList.toImmutableList());
        props.put("JAMES_MAIL_ATTRIBUTE_NAMES", this.joiner.join((Iterable)attributeNames));
        props.put("JAMES_MAIL_SENDER", sender);
        props.put("JAMES_MAIL_STATE", mail.getState());
        return props;
    }

    protected final Mail createMail(Message message) throws MessagingException, JMSException {
        return this.populateMail(message).mimeMessage(this.mimeMessage(message)).build();
    }

    protected MimeMessage mimeMessage(Message message) throws MessagingException, JMSException {
        if (message instanceof ObjectMessage) {
            return new MimeMessageWrapper((MimeMessageSource)new MimeMessageObjectMessageSource((ObjectMessage)message));
        }
        throw new MailQueue.MailQueueException("Not supported JMS Message received " + message);
    }

    protected MailImpl.Builder populateMail(Message message) throws JMSException {
        String name = message.getStringProperty("JAMES_MAIL_NAME");
        MailImpl.Builder builder = MailImpl.builder().name(name);
        builder.errorMessage(message.getStringProperty("JAMES_MAIL_ERROR_MESSAGE"));
        builder.lastUpdated(new Date(message.getLongProperty("JAMES_MAIL_LAST_UPDATED")));
        Enumeration properties = message.getPropertyNames();
        PerRecipientHeaders perRecipientHeaders = new PerRecipientHeaders();
        ImmutableList.copyOf(properties.asIterator()).stream().filter(property -> property.startsWith("JAMES_MAIL_PER_RECIPIENT_HEADERS-")).flatMap(property -> {
            try {
                MailAddress address = new MailAddress(property.substring("JAMES_MAIL_PER_RECIPIENT_HEADERS".length() + 1));
                String headers = message.getStringProperty(property);
                return Splitter.on((char)'\n').splitToStream((CharSequence)headers).map(PerRecipientHeaders.Header::fromString).map(header -> Pair.of((Object)address, (Object)header));
            }
            catch (JMSException | AddressException e) {
                LOGGER.error("Error deserializing per-recipient header", e);
                return Stream.empty();
            }
        }).forEach(pair -> perRecipientHeaders.addHeaderForRecipient((PerRecipientHeaders.Header)pair.getValue(), (MailAddress)pair.getKey()));
        if (!perRecipientHeaders.getHeadersByRecipient().isEmpty()) {
            builder.addAllHeadersForRecipients(perRecipientHeaders);
        }
        String recipients = message.getStringProperty("JAMES_MAIL_RECIPIENTS");
        StringTokenizer recipientTokenizer = new StringTokenizer(recipients, ";");
        while (recipientTokenizer.hasMoreTokens()) {
            String token = recipientTokenizer.nextToken();
            try {
                MailAddress rcpt = new MailAddress(token);
                builder.addRecipient(rcpt);
            }
            catch (AddressException e) {
                LOGGER.error("Unable to parse the recipient address {} for builder {}, so we ignore it", new Object[]{token, name, e});
            }
        }
        builder.remoteAddr(message.getStringProperty("JAMES_MAIL_REMOTEADDR"));
        builder.remoteHost(message.getStringProperty("JAMES_MAIL_REMOTEHOST"));
        String attributeNames = message.getStringProperty("JAMES_MAIL_ATTRIBUTE_NAMES");
        builder.addAttributes((Collection)this.splitter.splitToStream((CharSequence)attributeNames).flatMap(attributeName -> this.mailAttribute(message, (String)attributeName)).collect(ImmutableList.toImmutableList()));
        builder.sender(MaybeSender.getMailSender((String)message.getStringProperty("JAMES_MAIL_SENDER")).asOptional());
        builder.state(message.getStringProperty("JAMES_MAIL_STATE"));
        return builder;
    }

    private Stream<Attribute> mailAttribute(Message message, String name) {
        Object attrValue = Throwing.function(arg_0 -> ((Message)message).getObjectProperty(arg_0)).apply((Object)name);
        if (attrValue instanceof String) {
            try {
                return Stream.of(new Attribute(AttributeName.of((String)name), AttributeValue.fromJsonString((String)((String)attrValue))));
            }
            catch (IOException e) {
                LOGGER.error("Error deserializing mail attribute {} with value {}", new Object[]{name, attrValue, e});
            }
        } else {
            LOGGER.error("Not supported mail attribute {} of type {} for mail {}", new Object[]{name, attrValue, name});
        }
        return Stream.empty();
    }

    private Gauge<Long> queueSizeGauge() {
        return () -> (Long)Throwing.supplier(this::getSize).get();
    }

    public String toString() {
        return "MailQueue:" + this.queueName.asString();
    }

    protected Mono<MailQueue.MailQueueItem> createMailQueueItem(Session session, MessageConsumer consumer, Message message) throws JMSException, MessagingException {
        Mail mail = this.createMail(message);
        JMSMailQueueItem jmsMailQueueItem = new JMSMailQueueItem(mail, session, consumer);
        return Mono.just((Object)this.mailQueueItemDecoratorFactory.decorate((MailQueue.MailQueueItem)jmsMailQueueItem, this.queueName));
    }

    protected String getMessageSelector() {
        return "JAMES_NEXT_DELIVERY <= " + System.currentTimeMillis() + " OR FORCE_DELIVERY = true";
    }

    public long getSize() throws MailQueue.MailQueueException {
        long l;
        block8: {
            QueueBrowser browser = this.session.createBrowser(this.queue);
            try {
                Enumeration enumeration = browser.getEnumeration();
                l = Iterators.size((Iterator)new EnumerationIterator(enumeration));
                if (browser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (browser != null) {
                        try {
                            browser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("Unable to get size of queue {}", (Object)this.queueName, (Object)e);
                    throw new MailQueue.MailQueueException("Unable to get size of queue " + this.queueName.asString(), e);
                }
            }
            browser.close();
        }
        return l;
    }

    /*
     * Exception decompiling
     */
    public long flush() throws MailQueue.MailQueueException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long clear() throws MailQueue.MailQueueException {
        return this.count(this.removeWithSelector(null));
    }

    protected long count(List<Message> msgs) {
        if (msgs == null) {
            return -1L;
        }
        return msgs.size();
    }

    public List<Message> removeWithSelector(String selector) throws MailQueue.MailQueueException {
        boolean first = true;
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            try (Session session = this.connection.createSession(true, 0);){
                Queue queue = session.createQueue(this.queueName.asString());
                try (MessageConsumer consumer = session.createConsumer((Destination)queue, selector);){
                    Message message = null;
                    while (first || message != null) {
                        message = first ? consumer.receive(2000L) : consumer.receiveNoWait();
                        first = false;
                        if (message == null) continue;
                        messages.add(message);
                    }
                }
                session.commit();
            }
            return messages;
        }
        catch (Exception e) {
            throw new MailQueue.MailQueueException("Unable to remove mails", e);
        }
    }

    protected Message copy(Session session, Message m) throws JMSException {
        ObjectMessage message = (ObjectMessage)m;
        ObjectMessage copy = session.createObjectMessage(message.getObject());
        Enumeration properties = message.getPropertyNames();
        while (properties.hasMoreElements()) {
            String name = (String)properties.nextElement();
            copy.setObjectProperty(name, message.getObjectProperty(name));
        }
        return copy;
    }

    public long remove(ManageableMailQueue.Type type, String value) throws MailQueue.MailQueueException {
        switch (type) {
            case Name: {
                return this.count(this.removeWithSelector("JAMES_MAIL_NAME = '" + value + "'"));
            }
            case Sender: {
                return this.count(this.removeWithSelector("JAMES_MAIL_SENDER = '" + value + "'"));
            }
            case Recipient: {
                return this.count(this.removeWithSelector(String.join((CharSequence)" or ", "JAMES_MAIL_RECIPIENTS = '" + value + "'", "JAMES_MAIL_RECIPIENTS LIKE '" + value + ";%'", "JAMES_MAIL_RECIPIENTS LIKE '%;" + value + ";%'", "JAMES_MAIL_RECIPIENTS LIKE '%;" + value + "'")));
            }
        }
        return -1L;
    }

    public ManageableMailQueue.MailQueueIterator browse() throws MailQueue.MailQueueException {
        QueueBrowser browser = null;
        try {
            browser = this.session.createBrowser(this.queue);
            final Enumeration messages = browser.getEnumeration();
            final QueueBrowser myBrowser = browser;
            return new ManageableMailQueue.MailQueueIterator(){

                public void remove() {
                    throw new UnsupportedOperationException("Read-only");
                }

                public ManageableMailQueue.MailQueueItemView next() {
                    while (this.hasNext()) {
                        try {
                            Message m = (Message)messages.nextElement();
                            return new ManageableMailQueue.DefaultMailQueueItemView(JMSCacheableMailQueue.this.createMail(m), this.nextDeliveryDate(m));
                        }
                        catch (JMSException | MessagingException e) {
                            LOGGER.error("Unable to browse queue", e);
                        }
                    }
                    throw new NoSuchElementException();
                }

                private ZonedDateTime nextDeliveryDate(Message m) throws JMSException {
                    long nextDeliveryTimestamp = m.getLongProperty("JAMES_NEXT_DELIVERY");
                    return Instant.ofEpochMilli(nextDeliveryTimestamp).atZone(ZoneId.systemDefault());
                }

                public boolean hasNext() {
                    return messages.hasMoreElements();
                }

                public void close() {
                    JMSCacheableMailQueue.closeBrowser(myBrowser);
                }
            };
        }
        catch (Exception e) {
            JMSCacheableMailQueue.closeBrowser(browser);
            LOGGER.error("Unable to browse queue {}", (Object)this.queueName, (Object)e);
            throw new MailQueue.MailQueueException("Unable to browse queue " + this.queueName.asString(), e);
        }
    }

    public void dispose() {
        try {
            JMSCacheableMailQueue.closeProducer(this.producer);
            JMSCacheableMailQueue.closeSession(this.session);
            this.connection.close();
        }
        catch (JMSException e) {
            LOGGER.error("Error while closing session", (Throwable)e);
        }
    }
}

