/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vacation.cassandra;

import com.google.common.primitives.Ints;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.util.date.ZonedDateTimeProvider;
import org.apache.james.vacation.api.AccountId;
import org.apache.james.vacation.api.NotificationRegistry;
import org.apache.james.vacation.api.RecipientId;
import org.apache.james.vacation.cassandra.CassandraNotificationRegistryDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class CassandraNotificationRegistry
implements NotificationRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraNotificationRegistry.class);
    private final ZonedDateTimeProvider zonedDateTimeProvider;
    private final CassandraNotificationRegistryDAO cassandraNotificationRegistryDAO;

    @Inject
    public CassandraNotificationRegistry(ZonedDateTimeProvider zonedDateTimeProvider, CassandraNotificationRegistryDAO cassandraNotificationRegistryDAO) {
        this.zonedDateTimeProvider = zonedDateTimeProvider;
        this.cassandraNotificationRegistryDAO = cassandraNotificationRegistryDAO;
    }

    public Mono<Void> register(AccountId accountId, RecipientId recipientId, Optional<ZonedDateTime> expiryDate) {
        Optional<Integer> waitDelay = expiryDate.map(expiry -> Ints.checkedCast((long)((ZonedDateTime)this.zonedDateTimeProvider.get()).until((Temporal)expiry, ChronoUnit.SECONDS)));
        if (this.isValid(waitDelay)) {
            return this.cassandraNotificationRegistryDAO.register(accountId, recipientId, waitDelay);
        }
        LOGGER.warn("Invalid wait delay for {} {} : {}", new Object[]{accountId, recipientId, waitDelay});
        return Mono.empty();
    }

    public Mono<Boolean> isRegistered(AccountId accountId, RecipientId recipientId) {
        return this.cassandraNotificationRegistryDAO.isRegistered(accountId, recipientId);
    }

    public Mono<Void> flush(AccountId accountId) {
        return this.cassandraNotificationRegistryDAO.flush(accountId);
    }

    private boolean isValid(Optional<Integer> waitDelay) {
        return !waitDelay.isPresent() || waitDelay.get() >= 0;
    }
}

