/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft;

import javax.inject.Inject;
import org.apache.james.jmap.draft.JMAPDraftConfiguration;
import org.apache.james.jmap.draft.crypto.SecurityKeyLoader;
import org.apache.james.lifecycle.api.StartUpCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMAPConfigurationStartUpCheck
implements StartUpCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(JMAPConfigurationStartUpCheck.class);
    public static final String CHECK_NAME = "JMAPConfigurationStartUpCheck";
    private final SecurityKeyLoader securityKeyLoader;
    private final JMAPDraftConfiguration jmapConfiguration;

    @Inject
    JMAPConfigurationStartUpCheck(SecurityKeyLoader securityKeyLoader, JMAPDraftConfiguration jmapConfiguration) {
        this.securityKeyLoader = securityKeyLoader;
        this.jmapConfiguration = jmapConfiguration;
    }

    public StartUpCheck.CheckResult check() {
        if (this.jmapConfiguration.isEnabled()) {
            return this.checkSecurityKey();
        }
        return StartUpCheck.CheckResult.builder().checkName(this.checkName()).resultType(StartUpCheck.ResultType.GOOD).build();
    }

    private StartUpCheck.CheckResult checkSecurityKey() {
        try {
            this.securityKeyLoader.load();
            return StartUpCheck.CheckResult.builder().checkName(this.checkName()).resultType(StartUpCheck.ResultType.GOOD).build();
        }
        catch (Exception e) {
            LOGGER.error("Cannot load security key from jmap configuration", (Throwable)e);
            return StartUpCheck.CheckResult.builder().checkName(this.checkName()).resultType(StartUpCheck.ResultType.BAD).description(e.getMessage()).build();
        }
    }

    public String checkName() {
        return CHECK_NAME;
    }
}

