/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.policies.local;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.james.jspf.core.Logger;
import org.apache.james.jspf.core.SPF1Record;
import org.apache.james.jspf.core.SPFRecordParser;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.SPFResultException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.apache.james.jspf.policies.PolicyPostFilter;

public class FallbackPolicy
implements PolicyPostFilter {
    private Map<String, SPF1Record> entryMap;
    private SPFRecordParser parser;
    private Logger log;

    public FallbackPolicy(Logger log, SPFRecordParser parser) {
        this.log = log;
        this.entryMap = Collections.synchronizedMap(new HashMap());
        this.parser = parser;
    }

    public void addEntry(String rawHost, String rawSpfRecord) throws IllegalArgumentException {
        try {
            String host;
            this.log.debug("Start parsing SPF-Record: " + rawSpfRecord);
            SPF1Record spfRecord = this.parser.parse(rawSpfRecord);
            if (rawHost.startsWith("*")) {
                host = rawHost.substring(1);
                this.log.debug("Convert host " + rawHost + " to " + host);
            } else if (rawHost.endsWith("*")) {
                int length = rawHost.length();
                host = rawHost.substring(length - 1, length);
                this.log.debug("Convert host " + rawHost + " to " + host);
            } else {
                host = rawHost;
            }
            this.entryMap.put(host, spfRecord);
        }
        catch (SPFResultException e) {
            throw new IllegalArgumentException("Invalid SPF-Record: " + rawSpfRecord);
        }
    }

    public void clearEntrys() {
        this.log.debug("Clear all entries");
        this.entryMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(String host) {
        this.log.debug("Remove fallback entry for host: " + host);
        Map<String, SPF1Record> map = this.entryMap;
        synchronized (map) {
            this.entryMap.remove(this.getRawEntry(host));
        }
    }

    public SPF1Record getSPFRecord(String currentDomain, SPF1Record res) throws PermErrorException, TempErrorException, NoneException, NeutralException {
        if (res == null) {
            return this.getMySPFRecord(currentDomain);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SPF1Record getMySPFRecord(String host) {
        SPF1Record entry = null;
        Map<String, SPF1Record> map = this.entryMap;
        synchronized (map) {
            entry = this.getRawEntry(host);
        }
        if (entry != null) {
            return entry;
        }
        return null;
    }

    private SPF1Record getRawEntry(String host) {
        for (String rawHost : this.entryMap.keySet()) {
            if ((!rawHost.startsWith(".") || !host.startsWith(rawHost)) && (!rawHost.endsWith(".") || !host.endsWith(rawHost))) continue;
            return this.entryMap.get(rawHost);
        }
        return null;
    }
}

