/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.request;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.message.request.AbstractImapRequest;
import org.apache.james.mailbox.model.MailboxAnnotationKey;

public class GetAnnotationRequest
extends AbstractImapRequest {
    private final String mailboxName;
    private final Set<MailboxAnnotationKey> keys;
    private final Optional<Integer> maxsize;
    private final Depth depth;

    public static Builder builder() {
        return new Builder();
    }

    private GetAnnotationRequest(Builder builder) {
        super(builder.tag, ImapConstants.GETANNOTATION_COMMAND);
        this.mailboxName = builder.mailboxName;
        this.depth = builder.depth;
        this.maxsize = builder.maxsize;
        this.keys = builder.keys;
    }

    public String getMailboxName() {
        return this.mailboxName;
    }

    public Set<MailboxAnnotationKey> getKeys() {
        return this.keys;
    }

    public Optional<Integer> getMaxsize() {
        return this.maxsize;
    }

    public Depth getDepth() {
        return this.depth;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mailboxName", (Object)this.mailboxName).add("keys", this.keys).add("maxsize", this.maxsize).add("depth", (Object)this.depth).toString();
    }

    public static enum Depth {
        ZERO("0"),
        ONE("1"),
        INFINITY("infinity");

        private final String code;

        private Depth(String code) {
            this.code = code;
        }

        public final String getCode() {
            return this.code;
        }

        public String toString() {
            return this.code;
        }

        public static Depth fromString(String code) {
            Preconditions.checkNotNull((Object)code);
            for (Depth depth : Depth.values()) {
                if (!code.equalsIgnoreCase(depth.code)) continue;
                return depth;
            }
            throw new IllegalArgumentException("Cannot lookup Depth data for: " + code);
        }
    }

    public static class Builder {
        private Tag tag;
        private String mailboxName;
        private Set<MailboxAnnotationKey> keys;
        private Optional<Integer> maxsize;
        private Depth depth = Depth.ZERO;

        private Builder() {
            this.maxsize = Optional.empty();
            this.keys = ImmutableSet.of();
        }

        public Builder tag(Tag tag) {
            this.tag = tag;
            return this;
        }

        public Builder mailboxName(String mailboxName) {
            Preconditions.checkNotNull((Object)mailboxName);
            this.mailboxName = mailboxName;
            return this;
        }

        public Builder keys(Set<MailboxAnnotationKey> keys) {
            this.keys = ImmutableSet.copyOf(keys);
            return this;
        }

        public Builder maxsize(Optional<Integer> maxsize) {
            this.maxsize = maxsize;
            return this;
        }

        public Builder depth(Depth depth) {
            this.depth = depth;
            return this;
        }

        public GetAnnotationRequest build() {
            Preconditions.checkState((this.isNoDepth() || this.isDepthAndKeysNotEmpty() ? 1 : 0) != 0);
            Preconditions.checkArgument((this.isNoMaxsize() || this.maxsize.get() > 0 ? 1 : 0) != 0);
            return new GetAnnotationRequest(this);
        }

        private boolean isDepthAndKeysNotEmpty() {
            return !Depth.ZERO.equals((Object)this.depth) && !this.keys.isEmpty();
        }

        private boolean isNoDepth() {
            return Depth.ZERO.equals((Object)this.depth);
        }

        private boolean isNoMaxsize() {
            return !this.maxsize.isPresent();
        }
    }
}

