/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class OIDCSASLParser {
    public static final char SASL_SEPARATOR = '\u0001';
    public static final String PREFIX_TOKEN = "Bearer ";

    public static Optional<OIDCInitialResponse> parse(String initialResponse) {
        Optional<String> decodeResult = OIDCSASLParser.decodeBase64(initialResponse);
        if (decodeResult.isPresent()) {
            String decodeValueWithoutDanglingPart = decodeResult.filter(value -> value.startsWith("n,")).map(value -> value.substring(2)).orElse(decodeResult.get());
            List parts = Splitter.on((char)'\u0001').splitToList((CharSequence)decodeValueWithoutDanglingPart);
            ImmutableList tokenPart = (ImmutableList)parts.stream().filter(part -> part.startsWith("auth=")).collect(ImmutableList.toImmutableList());
            ImmutableList userPart = (ImmutableList)parts.stream().filter(part -> part.startsWith("user=")).collect(ImmutableList.toImmutableList());
            if (tokenPart.size() == 1 && userPart.size() == 1) {
                return Optional.of(new OIDCInitialResponse(((String)userPart.get(0)).substring(5), ((String)tokenPart.get(0)).substring(5).replace(PREFIX_TOKEN, "")));
            }
        }
        return Optional.empty();
    }

    private static Optional<String> decodeBase64(String line) {
        try {
            String lineWithoutTrailingCrLf = StringUtils.replace((String)line, (String)"\r\n", (String)"");
            return Optional.of(new String(Base64.getDecoder().decode(lineWithoutTrailingCrLf), StandardCharsets.US_ASCII));
        }
        catch (IllegalArgumentException exception) {
            return Optional.empty();
        }
    }

    public static class OIDCInitialResponse {
        private final String user;
        private final String token;

        public OIDCInitialResponse(String user, String token) {
            this.user = user;
            this.token = token;
        }

        public String getUser() {
            return this.user;
        }

        public String getToken() {
            return this.token;
        }
    }
}

