/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.store.mail.MessageMapper;

public class FetchGroupConverter {
    public static MessageMapper.FetchType getFetchType(FetchGroup group) {
        if (!group.getPartContentDescriptors().isEmpty()) {
            return MessageMapper.FetchType.FULL;
        }
        Collection fetchTypes = (Collection)group.profiles().stream().map(FetchGroupConverter::toFetchType).collect(ImmutableList.toImmutableList());
        return FetchGroupConverter.reduce(fetchTypes);
    }

    public static MessageMapper.FetchType reduce(Collection<MessageMapper.FetchType> fetchTypes) {
        boolean full = fetchTypes.contains((Object)MessageMapper.FetchType.FULL);
        boolean headers = fetchTypes.contains((Object)MessageMapper.FetchType.HEADERS);
        boolean body = fetchTypes.contains((Object)MessageMapper.FetchType.BODY);
        if (full) {
            return MessageMapper.FetchType.FULL;
        }
        if (headers && body) {
            return MessageMapper.FetchType.FULL;
        }
        if (headers) {
            return MessageMapper.FetchType.HEADERS;
        }
        if (body) {
            return MessageMapper.FetchType.BODY;
        }
        return MessageMapper.FetchType.METADATA;
    }

    private static MessageMapper.FetchType toFetchType(FetchGroup.Profile profile) {
        switch (profile) {
            case HEADERS: {
                return MessageMapper.FetchType.HEADERS;
            }
            case BODY_CONTENT: {
                return MessageMapper.FetchType.BODY;
            }
            case FULL_CONTENT: 
            case MIME_CONTENT: 
            case MIME_HEADERS: 
            case MIME_DESCRIPTOR: {
                return MessageMapper.FetchType.FULL;
            }
        }
        throw new NotImplementedException("Unsupported FetchGroup Profile" + profile);
    }
}

