/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.fasterxml.jackson.databind.Module;
import javax.inject.Inject;
import org.apache.james.core.Domain;
import org.apache.james.dlp.api.DLPConfigurationItem;
import org.apache.james.dlp.api.DLPConfigurationStore;
import org.apache.james.dlp.api.DLPRules;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.DLPConfigurationDTO;
import org.apache.james.webadmin.dto.DLPConfigurationItemDTO;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonExtractor;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.Responses;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;

public class DLPConfigurationRoutes
implements Routes {
    public static final String BASE_PATH = "/dlp/rules";
    private static final String DOMAIN_NAME = ":senderDomain";
    private static final String SPECIFIC_DLP_RULE_DOMAIN = "/dlp/rules/:senderDomain";
    private static final String RULE_ID_NAME = ":ruleId";
    private static final String RULE_SPECIFIC_PATH = "/dlp/rules/:senderDomain/rules/:ruleId";
    private final JsonTransformer jsonTransformer;
    private final DLPConfigurationStore dlpConfigurationStore;
    private final JsonExtractor<DLPConfigurationDTO> jsonExtractor;
    private final DomainList domainList;

    @Inject
    public DLPConfigurationRoutes(DLPConfigurationStore dlpConfigurationStore, DomainList domainList, JsonTransformer jsonTransformer) {
        this.dlpConfigurationStore = dlpConfigurationStore;
        this.domainList = domainList;
        this.jsonTransformer = jsonTransformer;
        this.jsonExtractor = new JsonExtractor(DLPConfigurationDTO.class, new Module[0]);
    }

    public String getBasePath() {
        return BASE_PATH;
    }

    public void define(Service service) {
        this.defineStore(service);
        this.defineList(service);
        this.defineClear(service);
        this.defineFetch(service);
    }

    public void defineStore(Service service) {
        service.put(SPECIFIC_DLP_RULE_DOMAIN, (request, response) -> {
            Domain senderDomain = this.parseDomain(request);
            DLPConfigurationDTO dto = (DLPConfigurationDTO)this.jsonExtractor.parse(request.body());
            DLPRules rules = this.constructRules(dto);
            this.dlpConfigurationStore.store(senderDomain, rules);
            return Responses.returnNoContent((Response)response);
        });
    }

    private DLPRules constructRules(DLPConfigurationDTO dto) {
        try {
            return dto.toDLPConfiguration();
        }
        catch (DLPRules.DuplicateRulesIdsException e) {
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("'id' duplicates are not allowed in DLP rules").haltError();
        }
    }

    public void defineList(Service service) {
        service.get(SPECIFIC_DLP_RULE_DOMAIN, (request, response) -> {
            Domain senderDomain = this.parseDomain(request);
            DLPRules dlpConfigurations = (DLPRules)Mono.from((Publisher)this.dlpConfigurationStore.list(senderDomain)).block();
            DLPConfigurationDTO dto = DLPConfigurationDTO.toDTO(dlpConfigurations);
            response.status(200);
            response.header("Content-Type", "application/json");
            return dto;
        }, (ResponseTransformer)this.jsonTransformer);
    }

    public void defineClear(Service service) {
        service.delete(SPECIFIC_DLP_RULE_DOMAIN, (request, response) -> {
            Domain senderDomain = this.parseDomain(request);
            this.dlpConfigurationStore.clear(senderDomain);
            return Responses.returnNoContent((Response)response);
        }, (ResponseTransformer)this.jsonTransformer);
    }

    public void defineFetch(Service service) {
        service.get(RULE_SPECIFIC_PATH, (request, response) -> {
            Domain senderDomain = this.parseDomain(request);
            DLPConfigurationItem.Id ruleId = DLPConfigurationItem.Id.of((String)request.params(RULE_ID_NAME));
            DLPConfigurationItem dlpConfigurationItem = (DLPConfigurationItem)this.dlpConfigurationStore.fetch(senderDomain, ruleId).orElseThrow(() -> this.notFound("There is no rule '" + ruleId.asString() + "' for '" + senderDomain.asString() + "' managed by this James server"));
            DLPConfigurationItemDTO dto = DLPConfigurationItemDTO.toDTO(dlpConfigurationItem);
            response.status(200);
            response.header("Content-Type", "application/json");
            return dto;
        }, (ResponseTransformer)this.jsonTransformer);
    }

    private Domain parseDomain(Request request) {
        String domainName = request.params(DOMAIN_NAME);
        try {
            Domain domain = Domain.of((String)domainName);
            this.validateDomainInList(domain);
            return domain;
        }
        catch (DomainListException e) {
            throw this.serverError(String.format("Cannot recognize domain: %s in domain list", domainName), (Exception)((Object)e));
        }
    }

    private void validateDomainInList(Domain domain) throws DomainListException {
        if (!this.domainList.containsDomain(domain)) {
            throw this.notFound(String.format("'%s' is not managed by this James server", domain.name()));
        }
    }

    private HaltException serverError(String message, Exception e) {
        return ErrorResponder.builder().statusCode(500).type(ErrorResponder.ErrorType.SERVER_ERROR).message(message).cause(e).haltError();
    }

    private HaltException notFound(String message) {
        return ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message(message).haltError();
    }
}

