/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.dlp.api.DLPConfigurationItem;

public class DLPConfigurationItemDTO {
    private final String id;
    private final String expression;
    private final Optional<String> explanation;
    private final boolean targetsSender;
    private final boolean targetsRecipients;
    private final boolean targetsContent;

    public static DLPConfigurationItemDTO toDTO(DLPConfigurationItem dlpConfiguration) {
        DLPConfigurationItem.Targets targets = dlpConfiguration.getTargets();
        return new DLPConfigurationItemDTO(dlpConfiguration.getId().asString(), dlpConfiguration.getRegexp().pattern(), dlpConfiguration.getExplanation(), targets.isSenderTargeted(), targets.isRecipientTargeted(), targets.isContentTargeted());
    }

    @JsonCreator
    public DLPConfigurationItemDTO(@JsonProperty(value="id") String id, @JsonProperty(value="expression") String expression, @JsonProperty(value="explanation") Optional<String> explanation, @JsonProperty(value="targetsSender") boolean targetsSender, @JsonProperty(value="targetsRecipients") boolean targetsRecipients, @JsonProperty(value="targetsContent") boolean targetsContent) {
        Preconditions.checkNotNull((Object)id, (Object)"'id' is mandatory");
        Preconditions.checkNotNull((Object)expression, (Object)"'expression' is mandatory");
        this.id = id;
        this.expression = expression;
        this.explanation = explanation;
        this.targetsSender = targetsSender;
        this.targetsRecipients = targetsRecipients;
        this.targetsContent = targetsContent;
    }

    public String getId() {
        return this.id;
    }

    public String getExpression() {
        return this.expression;
    }

    public Optional<String> getExplanation() {
        return this.explanation;
    }

    public boolean getTargetsSender() {
        return this.targetsSender;
    }

    public boolean getTargetsRecipients() {
        return this.targetsRecipients;
    }

    public boolean getTargetsContent() {
        return this.targetsContent;
    }

    @JsonIgnore
    public DLPConfigurationItem toDLPConfiguration() {
        return DLPConfigurationItem.builder().id(DLPConfigurationItem.Id.of((String)this.id)).expression(this.expression).explanation(this.explanation).targetsSender(this.targetsSender).targetsRecipients(this.targetsRecipients).targetsContent(this.targetsContent).build();
    }

    public final boolean equals(Object o) {
        if (o instanceof DLPConfigurationItemDTO) {
            DLPConfigurationItemDTO that = (DLPConfigurationItemDTO)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.expression, that.expression) && Objects.equals(this.explanation, that.explanation) && Objects.equals(this.targetsSender, that.targetsSender) && Objects.equals(this.targetsRecipients, that.targetsRecipients) && Objects.equals(this.targetsContent, that.targetsContent);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.id, this.expression, this.explanation, this.targetsSender, this.targetsRecipients, this.targetsContent);
    }
}

