/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.projections;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.jmap.api.model.Preview;
import org.apache.james.jmap.api.projections.MessageFastViewPrecomputedProperties;
import org.apache.james.jmap.api.projections.MessageFastViewProjection;
import org.apache.james.jmap.cassandra.projections.table.CassandraMessageFastViewProjectionTable;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class CassandraMessageFastViewProjection
implements MessageFastViewProjection {
    public static final Logger LOGGER = LoggerFactory.getLogger(CassandraMessageFastViewProjection.class);
    private final Metric metricRetrieveHitCount;
    private final Metric metricRetrieveMissCount;
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement storeStatement;
    private final PreparedStatement retrieveStatement;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement truncateStatement;

    @Inject
    CassandraMessageFastViewProjection(MetricFactory metricFactory, Session session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.deleteStatement = session.prepare((RegularStatement)QueryBuilder.delete().from("message_fast_view_projection").where(QueryBuilder.eq((String)"messageId", (Object)QueryBuilder.bindMarker((String)"messageId"))));
        this.storeStatement = session.prepare((RegularStatement)QueryBuilder.insertInto((String)"message_fast_view_projection").value("messageId", (Object)QueryBuilder.bindMarker((String)"messageId")).value("preview", (Object)QueryBuilder.bindMarker((String)"preview")).value("hasAttachment", (Object)QueryBuilder.bindMarker((String)"hasAttachment")));
        this.retrieveStatement = session.prepare((RegularStatement)QueryBuilder.select().from("message_fast_view_projection").where(QueryBuilder.eq((String)CassandraMessageFastViewProjectionTable.MESSAGE_ID_LOWERCASE, (Object)QueryBuilder.bindMarker((String)CassandraMessageFastViewProjectionTable.MESSAGE_ID_LOWERCASE))));
        this.truncateStatement = session.prepare((RegularStatement)QueryBuilder.truncate((String)"message_fast_view_projection"));
        this.metricRetrieveHitCount = metricFactory.generate("MessageFastViewProjection:retrieveHitCount");
        this.metricRetrieveMissCount = metricFactory.generate("MessageFastViewProjection:retrieveMissCount");
    }

    public Mono<Void> store(MessageId messageId, MessageFastViewPrecomputedProperties precomputedProperties) {
        this.checkMessage(messageId);
        return this.cassandraAsyncExecutor.executeVoid(this.storeStatement.bind().setUUID("messageId", ((CassandraMessageId)messageId).get()).setString("preview", precomputedProperties.getPreview().getValue()).setBool("hasAttachment", precomputedProperties.hasAttachment()).setConsistencyLevel(ConsistencyLevel.ONE));
    }

    public Mono<MessageFastViewPrecomputedProperties> retrieve(MessageId messageId) {
        this.checkMessage(messageId);
        return this.cassandraAsyncExecutor.executeSingleRow(this.retrieveStatement.bind().setUUID(CassandraMessageFastViewProjectionTable.MESSAGE_ID_LOWERCASE, ((CassandraMessageId)messageId).get()).setConsistencyLevel(ConsistencyLevel.ONE)).map(this::fromRow).doOnNext(preview -> this.metricRetrieveHitCount.increment()).switchIfEmpty(Mono.fromRunnable(() -> ((Metric)this.metricRetrieveMissCount).increment())).onErrorResume(e -> {
            LOGGER.error("Error while retrieving MessageFastView projection item for {}", (Object)messageId, e);
            return Mono.empty();
        });
    }

    public Mono<Void> delete(MessageId messageId) {
        this.checkMessage(messageId);
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteStatement.bind().setUUID("messageId", ((CassandraMessageId)messageId).get()));
    }

    public Mono<Void> clear() {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.truncateStatement.bind());
    }

    private void checkMessage(MessageId messageId) {
        Preconditions.checkNotNull((Object)messageId);
        Preconditions.checkArgument((boolean)(messageId instanceof CassandraMessageId), (Object)"MessageId type is required to be CassandraMessageId");
    }

    private MessageFastViewPrecomputedProperties fromRow(Row row) {
        return MessageFastViewPrecomputedProperties.builder().preview(Preview.from((String)row.getString("preview"))).hasAttachment(row.getBool(CassandraMessageFastViewProjectionTable.HAS_ATTACHMENT_LOWERCASE)).build();
    }
}

