/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.cassandra.mail.task.RunningOptionsDTO;
import org.apache.james.mailbox.cassandra.mail.task.SolveMessageInconsistenciesService;
import org.apache.james.mailbox.cassandra.mail.task.SolveMessageInconsistenciesTask;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;

public class SolveMessageInconsistenciesTaskDTO
implements TaskDTO {
    private final String type;
    private final Optional<RunningOptionsDTO> runningOptions;

    private static SolveMessageInconsistenciesTaskDTO toDTO(SolveMessageInconsistenciesTask domainObject, String typeName) {
        return new SolveMessageInconsistenciesTaskDTO(typeName, Optional.of(RunningOptionsDTO.asDTO(domainObject.getRunningOptions())));
    }

    public static TaskDTOModule<SolveMessageInconsistenciesTask, SolveMessageInconsistenciesTaskDTO> module(SolveMessageInconsistenciesService service) {
        return (TaskDTOModule)DTOModule.forDomainObject(SolveMessageInconsistenciesTask.class).convertToDTO(SolveMessageInconsistenciesTaskDTO.class).toDomainObjectConverter(dto -> dto.toDomainObject(service)).toDTOConverter(SolveMessageInconsistenciesTaskDTO::toDTO).typeName(SolveMessageInconsistenciesTask.SOLVE_MESSAGE_INCONSISTENCIES.asString()).withFactory(TaskDTOModule::new);
    }

    public SolveMessageInconsistenciesTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="runningOptions") Optional<RunningOptionsDTO> runningOptions) {
        this.type = type;
        this.runningOptions = runningOptions;
    }

    private SolveMessageInconsistenciesTask toDomainObject(SolveMessageInconsistenciesService service) {
        return new SolveMessageInconsistenciesTask(service, this.runningOptions.map(RunningOptionsDTO::asDomainObject).orElse(SolveMessageInconsistenciesService.RunningOptions.DEFAULT));
    }

    public String getType() {
        return this.type;
    }

    public Optional<RunningOptionsDTO> getRunningOptions() {
        return this.runningOptions;
    }
}

