/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.brave;

import brave.Span;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.brave.ReactorNettyHttpTracing;
import reactor.netty.http.client.HttpClientResponse;

final class TracingChannelInboundHandler
extends ChannelInboundHandlerAdapter {
    static final String NAME = "reactor.left.tracingChannelInboundHandler";
    final CurrentTraceContext currentTraceContext;

    TracingChannelInboundHandler(CurrentTraceContext currentTraceContext) {
        this.currentTraceContext = currentTraceContext;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        TraceContext parent;
        Connection conn = Connection.from((Channel)ctx.channel());
        if (conn instanceof ConnectionObserver && (parent = (TraceContext)((ConnectionObserver)conn).currentContext().getOrDefault(TraceContext.class, null)) != null) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(parent);){
                ctx.fireChannelActive();
            }
            return;
        }
        ctx.fireChannelActive();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        TraceContext parent;
        Span span = (Span)ctx.channel().attr(ReactorNettyHttpTracing.SPAN_ATTR_KEY).get();
        if (span != null) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(span.context());){
                ctx.fireChannelRead(msg);
            }
            return;
        }
        ChannelOperations ops = ChannelOperations.get((Channel)ctx.channel());
        if (ops instanceof HttpClientResponse && (parent = (TraceContext)((HttpClientResponse)ops).currentContextView().getOrDefault(TraceContext.class, null)) != null) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(parent);){
                ctx.fireChannelRead(msg);
            }
            return;
        }
        ctx.fireChannelRead(msg);
    }

    public boolean isSharable() {
        return true;
    }
}

