/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import com.google.common.io.ByteStreams;
import com.google.common.io.CountingInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.message.Literal;
import org.apache.james.imap.utils.EolInputStream;
import org.apache.james.imapserver.netty.AbstractNettyImapRequestLineReader;
import org.jboss.netty.channel.Channel;

public class NettyStreamImapRequestLineReader
extends AbstractNettyImapRequestLineReader
implements Closeable {
    private final File backingFile;
    private final CountingInputStream in;

    public NettyStreamImapRequestLineReader(Channel channel, File file, boolean retry) {
        super(channel, retry);
        this.backingFile = file;
        try {
            this.in = new CountingInputStream((InputStream)new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public char nextChar() throws DecodingException {
        if (!this.nextSeen) {
            int next;
            try {
                next = this.in.read();
            }
            catch (IOException e) {
                throw new DecodingException(HumanReadableText.SOCKET_IO_FAILURE, "Error reading from stream.", (Throwable)e);
            }
            if (next == -1) {
                throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unexpected end of stream.");
            }
            this.nextSeen = true;
            this.nextChar = (char)next;
        }
        return this.nextChar;
    }

    public Literal read(int size, boolean extraCRLF) throws DecodingException {
        this.nextSeen = false;
        this.nextChar = '\u0000';
        try {
            long offset = this.in.getCount();
            this.in.skip((long)size);
            return new FileLiteral(offset, size, extraCRLF, this.backingFile, this);
        }
        catch (IOException e) {
            throw new DecodingException(HumanReadableText.SOCKET_IO_FAILURE, "Could not copy litteral", (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private class FileLiteral
    implements Literal,
    Closeable {
        private final long offset;
        private final int size;
        private final boolean extraCRLF;
        private final File file;
        private final AbstractNettyImapRequestLineReader reader;

        private FileLiteral(long offset, int size, boolean extraCRLF, File file, AbstractNettyImapRequestLineReader reader) {
            this.offset = offset;
            this.size = size;
            this.extraCRLF = extraCRLF;
            this.file = file;
            this.reader = reader;
        }

        @Override
        public void close() {
            this.file.delete();
        }

        public long size() {
            return Math.min(this.file.length() - this.offset, (long)this.size);
        }

        public InputStream getInputStream() throws IOException {
            FileInputStream fileInputStream = new FileInputStream(this.file);
            fileInputStream.skip(this.offset);
            InputStream limitedStream = ByteStreams.limit((InputStream)fileInputStream, (long)this.size);
            if (this.extraCRLF) {
                return new EolInputStream((ImapRequestLineReader)this.reader, limitedStream);
            }
            return limitedStream;
        }
    }
}

