/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.UUID;

public class EnqueueId {
    private final UUID id;

    public static EnqueueId generate() {
        return EnqueueId.of(UUID.randomUUID());
    }

    public static EnqueueId of(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid);
        return new EnqueueId(uuid);
    }

    public static EnqueueId ofSerialized(String serialized) {
        Preconditions.checkNotNull((Object)serialized);
        return EnqueueId.of(UUID.fromString(serialized));
    }

    private EnqueueId(UUID id) {
        this.id = id;
    }

    public UUID asUUID() {
        return this.id;
    }

    public String serialize() {
        return this.id.toString();
    }

    public final boolean equals(Object o) {
        if (o instanceof EnqueueId) {
            EnqueueId enqueueId = (EnqueueId)o;
            return Objects.equals(this.id, enqueueId.id);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.id);
    }
}

