/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.utils.quotas;

import java.util.Optional;
import org.apache.james.jmap.draft.model.mailbox.Quotas;
import org.apache.james.jmap.draft.utils.quotas.DefaultQuotaLoader;
import org.apache.james.jmap.draft.utils.quotas.QuotaLoader;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class QuotaLoaderWithDefaultPreloaded
extends QuotaLoader {
    private final QuotaRootResolver quotaRootResolver;
    private final DefaultQuotaLoader defaultQuotaLoader;
    private final Optional<Quotas> preloadedUserDefaultQuotas;

    public static Mono<QuotaLoaderWithDefaultPreloaded> preLoad(QuotaRootResolver quotaRootResolver, QuotaManager quotaManager, MailboxSession session) {
        DefaultQuotaLoader defaultQuotaLoader = new DefaultQuotaLoader(quotaRootResolver, quotaManager);
        return defaultQuotaLoader.getQuotas(MailboxPath.inbox((MailboxSession)session)).map(Optional::of).switchIfEmpty(Mono.just(Optional.empty())).map(quotas -> new QuotaLoaderWithDefaultPreloaded(quotaRootResolver, defaultQuotaLoader, (Optional<Quotas>)quotas));
    }

    private QuotaLoaderWithDefaultPreloaded(QuotaRootResolver quotaRootResolver, DefaultQuotaLoader defaultQuotaLoader, Optional<Quotas> preloadedUserDefaultQuotas) {
        this.quotaRootResolver = quotaRootResolver;
        this.defaultQuotaLoader = defaultQuotaLoader;
        this.preloadedUserDefaultQuotas = preloadedUserDefaultQuotas;
    }

    @Override
    public Mono<Quotas> getQuotas(MailboxPath mailboxPath) {
        return Mono.from((Publisher)this.quotaRootResolver.getQuotaRootReactive(mailboxPath)).flatMap(quotaRoot -> {
            Quotas.QuotaId quotaId = Quotas.QuotaId.fromQuotaRoot(quotaRoot);
            if (this.containsQuotaId(this.preloadedUserDefaultQuotas, quotaId)) {
                return Mono.just((Object)this.preloadedUserDefaultQuotas.get());
            }
            return this.defaultQuotaLoader.getQuotas(mailboxPath);
        });
    }

    private boolean containsQuotaId(Optional<Quotas> preloadedUserDefaultQuotas, Quotas.QuotaId quotaId) {
        return preloadedUserDefaultQuotas.map(Quotas::getQuotas).map(quotaIdQuotaMap -> quotaIdQuotaMap.containsKey(quotaId)).orElse(false);
    }
}

