/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.rabbitmq;

import com.google.common.collect.ImmutableMap;

public class QueueArguments {
    private static final String SINGLE_ACTIVE_CONSUMER_ARGUMENT = "x-single-active-consumer";
    public static final ImmutableMap<String, Object> NO_ARGUMENTS = ImmutableMap.of();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableMap.Builder<String, Object> arguments = ImmutableMap.builder();

        public RequiresReplicationFactor quorumQueue() {
            this.arguments.put((Object)"x-queue-type", (Object)"quorum");
            return this::replicationFactor;
        }

        private Builder replicationFactor(int replicationFactor) {
            this.arguments.put((Object)"x-quorum-initial-group-size", (Object)replicationFactor);
            return this;
        }

        public Builder deadLetter(String deadLetterQueueName) {
            this.arguments.put((Object)"x-dead-letter-exchange", (Object)deadLetterQueueName);
            return this;
        }

        public Builder singleActiveConsumer() {
            this.arguments.put((Object)QueueArguments.SINGLE_ACTIVE_CONSUMER_ARGUMENT, (Object)true);
            return this;
        }

        public Builder queueTTL(long queueTTL) {
            this.arguments.put((Object)"x-expires", (Object)queueTTL);
            return this;
        }

        public ImmutableMap<String, Object> build() {
            return this.arguments.build();
        }

        @FunctionalInterface
        public static interface RequiresReplicationFactor {
            public Builder replicationFactor(int var1);
        }
    }
}

