/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.parboiled.common.Preconditions;
import org.parboiled.transform.GroupClassGenerator;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.InstructionGroup;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.Types;

class VarInitClassGenerator
extends GroupClassGenerator {
    public VarInitClassGenerator(boolean bl) {
        super(bl);
    }

    @Override
    public boolean appliesTo(ParserClassNode parserClassNode, RuleMethod ruleMethod) {
        Preconditions.checkArgNotNull(ruleMethod, "method");
        return ruleMethod.containsVars();
    }

    @Override
    protected boolean appliesTo(InstructionGraphNode instructionGraphNode) {
        return instructionGraphNode.isVarInitRoot();
    }

    @Override
    protected Type getBaseType() {
        return Types.BASE_VAR_INIT;
    }

    @Override
    protected void generateMethod(InstructionGroup instructionGroup, ClassWriter classWriter) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "create", "()Ljava/lang/Object;", null, null);
        this.convertXLoads(instructionGroup);
        instructionGroup.getInstructions().accept(methodVisitor);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }
}

