/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import org.apache.james.mime4j.util.MimeUtil;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;
import org.apache.mailet.base.GenericMatcher;

public class HasHeader
extends GenericMatcher {
    private static final String CONDITION_SEPARATOR = "+";
    private static final String HEADER_VALUE_SEPARATOR = "=";
    private List<HeaderCondition> headerConditions;

    private static String sanitizeHeaderField(String headerName) {
        return DecoderUtil.decodeEncodedWords((String)MimeUtil.unfold((String)headerName), (DecodeMonitor)DecodeMonitor.SILENT);
    }

    public void init() throws MessagingException {
        this.headerConditions = new ArrayList<HeaderCondition>();
        StringTokenizer conditionTokenizer = new StringTokenizer(this.getCondition(), CONDITION_SEPARATOR);
        while (conditionTokenizer.hasMoreTokens()) {
            this.headerConditions.add(this.parseHeaderCondition(conditionTokenizer.nextToken().trim()));
        }
    }

    private HeaderCondition parseHeaderCondition(String element) throws MessagingException {
        StringTokenizer valueSeparatorTokenizer = new StringTokenizer(element, HEADER_VALUE_SEPARATOR, false);
        if (!valueSeparatorTokenizer.hasMoreElements()) {
            throw new MessagingException("Missing headerName");
        }
        String headerName = valueSeparatorTokenizer.nextToken().trim();
        if (valueSeparatorTokenizer.hasMoreTokens()) {
            return new HeaderValueCondition(headerName, valueSeparatorTokenizer.nextToken().trim());
        }
        return new HeaderNameCondition(headerName);
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        HashSet<MailAddress> matchingRecipients = new HashSet<MailAddress>();
        boolean first = true;
        for (HeaderCondition headerCondition : this.headerConditions) {
            if (first) {
                first = false;
                matchingRecipients.addAll(headerCondition.isMatching(mail));
                continue;
            }
            Collection<MailAddress> currentMatching = headerCondition.isMatching(mail);
            matchingRecipients.removeIf(it -> !currentMatching.contains(it));
        }
        return matchingRecipients.isEmpty() ? null : matchingRecipients;
    }

    private static interface HeaderCondition {
        public Collection<MailAddress> isMatching(Mail var1) throws MessagingException;
    }

    private static class HeaderValueCondition
    implements HeaderCondition {
        private final String headerName;
        private final String headerValue;

        public HeaderValueCondition(String headerName, String headerValue) {
            this.headerName = headerName;
            this.headerValue = headerValue;
        }

        @Override
        public Collection<MailAddress> isMatching(Mail mail) throws MessagingException {
            String[] headerArray = mail.getMessage().getHeader(this.headerName);
            if (headerArray != null && headerArray.length > 0 && Arrays.stream(headerArray).anyMatch(value -> this.headerValue.equals(HasHeader.sanitizeHeaderField(value)))) {
                return mail.getRecipients();
            }
            return this.matchSpecific(mail);
        }

        protected Collection<MailAddress> matchSpecific(Mail mail) {
            return (Collection)mail.getPerRecipientSpecificHeaders().getHeadersByRecipient().entries().stream().filter(entry -> ((PerRecipientHeaders.Header)entry.getValue()).getName().equals(this.headerName) && ((PerRecipientHeaders.Header)entry.getValue()).getValue().equals(this.headerValue)).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
        }
    }

    private static class HeaderNameCondition
    implements HeaderCondition {
        private final String headerName;

        public HeaderNameCondition(String headerName) {
            this.headerName = headerName;
        }

        @Override
        public Collection<MailAddress> isMatching(Mail mail) throws MessagingException {
            String[] headerArray = mail.getMessage().getHeader(this.headerName);
            if (headerArray != null && headerArray.length > 0) {
                return mail.getRecipients();
            }
            return this.matchSpecific(mail);
        }

        protected Collection<MailAddress> matchSpecific(Mail mail) {
            return (Collection)mail.getPerRecipientSpecificHeaders().getHeadersByRecipient().entries().stream().filter(entry -> ((PerRecipientHeaders.Header)entry.getValue()).getName().equals(this.headerName)).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
        }
    }
}

