/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.unboundidds.ModifiablePasswordPolicyStateJSONField;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONNull;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.io.Serializable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ModifiablePasswordPolicyStateJSON
implements Serializable {
    @NotNull
    public static final String MODIFIABLE_PASSWORD_POLICY_STATE_JSON_ATTRIBUTE = "ds-pwp-modifiable-state-json";
    private static final long serialVersionUID = -5181314292507625116L;
    @NotNull
    private final JSONObject modifiablePasswordPolicyStateObject;

    public ModifiablePasswordPolicyStateJSON(@NotNull JSONObject modifiablePasswordPolicyStateObject) {
        this.modifiablePasswordPolicyStateObject = modifiablePasswordPolicyStateObject;
    }

    @Nullable
    public static ModifiablePasswordPolicyStateJSON get(@NotNull LDAPInterface connection, @NotNull String userDN) throws LDAPException {
        SearchResultEntry userEntry = connection.getEntry(userDN, MODIFIABLE_PASSWORD_POLICY_STATE_JSON_ATTRIBUTE);
        if (userEntry == null) {
            throw new LDAPException(ResultCode.NO_SUCH_OBJECT, UnboundIDDSMessages.ERR_MODIFIABLE_PW_POLICY_STATE_JSON_GET_NO_SUCH_USER.get(userDN));
        }
        return ModifiablePasswordPolicyStateJSON.get(userEntry);
    }

    @Nullable
    public static ModifiablePasswordPolicyStateJSON get(@NotNull Entry userEntry) throws LDAPException {
        JSONObject jsonObject;
        String valueString = userEntry.getAttributeValue(MODIFIABLE_PASSWORD_POLICY_STATE_JSON_ATTRIBUTE);
        if (valueString == null) {
            return null;
        }
        try {
            jsonObject = new JSONObject(valueString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, UnboundIDDSMessages.ERR_MODIFIABLE_PW_POLICY_STATE_JSON_GET_CANNOT_DECODE.get(MODIFIABLE_PASSWORD_POLICY_STATE_JSON_ATTRIBUTE, userEntry.getDN()), e);
        }
        return new ModifiablePasswordPolicyStateJSON(jsonObject);
    }

    @NotNull
    public JSONObject getModifiablePasswordPolicyStateJSONObject() {
        return this.modifiablePasswordPolicyStateObject;
    }

    @Nullable
    public Long getPasswordChangedTime() {
        return this.getTimestamp(ModifiablePasswordPolicyStateJSONField.PASSWORD_CHANGED_TIME);
    }

    @Nullable
    public Boolean getAccountIsDisabled() {
        return this.modifiablePasswordPolicyStateObject.getFieldAsBoolean(ModifiablePasswordPolicyStateJSONField.ACCOUNT_IS_DISABLED.getFieldName());
    }

    @Nullable
    public Long getAccountActivationTime() {
        return this.getTimestamp(ModifiablePasswordPolicyStateJSONField.ACCOUNT_ACTIVATION_TIME);
    }

    @Nullable
    public Long getAccountExpirationTime() {
        return this.getTimestamp(ModifiablePasswordPolicyStateJSONField.ACCOUNT_EXPIRATION_TIME);
    }

    @Nullable
    public Boolean getAccountIsFailureLocked() {
        return this.modifiablePasswordPolicyStateObject.getFieldAsBoolean(ModifiablePasswordPolicyStateJSONField.ACCOUNT_IS_FAILURE_LOCKED.getFieldName());
    }

    @Nullable
    public Long getPasswordExpirationWarnedTime() {
        return this.getTimestamp(ModifiablePasswordPolicyStateJSONField.PASSWORD_EXPIRATION_WARNED_TIME);
    }

    @Nullable
    public Boolean getMustChangePassword() {
        return this.modifiablePasswordPolicyStateObject.getFieldAsBoolean(ModifiablePasswordPolicyStateJSONField.MUST_CHANGE_PASSWORD.getFieldName());
    }

    @Nullable
    private Long getTimestamp(@NotNull ModifiablePasswordPolicyStateJSONField field) {
        JSONValue fieldValue = this.modifiablePasswordPolicyStateObject.getField(field.getFieldName());
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof JSONNull) {
            return -1L;
        }
        if (fieldValue instanceof JSONString) {
            try {
                return StaticUtils.decodeRFC3339Time(((JSONString)fieldValue).stringValue()).getTime();
            }
            catch (Exception e) {
                Debug.debugException(e);
                return null;
            }
        }
        return null;
    }

    @NotNull
    public String toString() {
        return this.modifiablePasswordPolicyStateObject.toSingleLineString();
    }
}

