/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.experimental;

import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.experimental.DraftChuLDAPLogSchema00AbandonEntry;
import com.unboundid.ldap.sdk.experimental.DraftChuLDAPLogSchema00AddEntry;
import com.unboundid.ldap.sdk.experimental.DraftChuLDAPLogSchema00BindEntry;
import com.unboundid.ldap.sdk.experimental.DraftChuLDAPLogSchema00CompareEntry;
import com.unboundid.ldap.sdk.experimental.DraftChuLDAPLogSchema00DeleteEntry;
import com.unboundid.ldap.sdk.experimental.DraftChuLDAPLogSchema00ExtendedEntry;
import com.unboundid.ldap.sdk.experimental.DraftChuLDAPLogSchema00ModifyDNEntry;
import com.unboundid.ldap.sdk.experimental.DraftChuLDAPLogSchema00ModifyEntry;
import com.unboundid.ldap.sdk.experimental.DraftChuLDAPLogSchema00SearchEntry;
import com.unboundid.ldap.sdk.experimental.DraftChuLDAPLogSchema00UnbindEntry;
import com.unboundid.ldap.sdk.experimental.ExperimentalMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public abstract class DraftChuLDAPLogSchema00Entry
extends ReadOnlyEntry {
    @NotNull
    public static final String ATTR_AUTHORIZATION_IDENTITY_DN = "reqAuthzID";
    @NotNull
    public static final String ATTR_DIAGNOSTIC_MESSAGE = "reqMessage";
    @NotNull
    public static final String ATTR_OPERATION_TYPE = "reqType";
    @NotNull
    public static final String ATTR_PROCESSING_END_TIME = "reqEnd";
    @NotNull
    public static final String ATTR_PROCESSING_START_TIME = "reqStart";
    @NotNull
    public static final String ATTR_REFERRAL_URL = "reqReferral";
    @NotNull
    public static final String ATTR_REQUEST_CONTROL = "reqControls";
    @NotNull
    public static final String ATTR_RESPONSE_CONTROL = "reqRespControls";
    @NotNull
    public static final String ATTR_RESULT_CODE = "reqResult";
    @NotNull
    public static final String ATTR_SESSION_ID = "reqSession";
    @NotNull
    public static final String ATTR_TARGET_ENTRY_DN = "reqDN";
    private static final long serialVersionUID = -7279669732772403236L;
    @Nullable
    private final Date processingEndTimeDate;
    @NotNull
    private final Date processingStartTimeDate;
    @NotNull
    private final List<Control> requestControls;
    @NotNull
    private final List<Control> responseControls;
    @NotNull
    private final List<String> referralURLs;
    @NotNull
    private final OperationType operationType;
    @Nullable
    private final ResultCode resultCode;
    @Nullable
    private final String authorizationIdentityDN;
    @Nullable
    private final String diagnosticMessage;
    @Nullable
    private final String processingEndTimeString;
    @NotNull
    private final String processingStartTimeString;
    @NotNull
    private final String sessionID;
    @Nullable
    private final String targetEntryDN;

    DraftChuLDAPLogSchema00Entry(@NotNull Entry entry, @NotNull OperationType operationType) throws LDAPException {
        super(entry);
        this.operationType = operationType;
        this.processingStartTimeString = entry.getAttributeValue(ATTR_PROCESSING_START_TIME);
        if (this.processingStartTimeString == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_MISSING_REQUIRED_ATTR.get(entry.getDN(), ATTR_PROCESSING_START_TIME));
        }
        try {
            this.processingStartTimeDate = StaticUtils.decodeGeneralizedTime(this.processingStartTimeString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_CANNOT_DECODE_TIME.get(entry.getDN(), ATTR_PROCESSING_START_TIME, this.processingStartTimeString), e);
        }
        this.processingEndTimeString = entry.getAttributeValue(ATTR_PROCESSING_END_TIME);
        if (this.processingEndTimeString == null) {
            this.processingEndTimeDate = null;
        } else {
            try {
                this.processingEndTimeDate = StaticUtils.decodeGeneralizedTime(this.processingEndTimeString);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_CANNOT_DECODE_TIME.get(entry.getDN(), ATTR_PROCESSING_END_TIME, this.processingEndTimeString), e);
            }
        }
        this.sessionID = entry.getAttributeValue(ATTR_SESSION_ID);
        if (this.sessionID == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_MISSING_REQUIRED_ATTR.get(entry.getDN(), ATTR_SESSION_ID));
        }
        this.targetEntryDN = entry.getAttributeValue(ATTR_TARGET_ENTRY_DN);
        if (this.targetEntryDN == null && operationType != OperationType.ABANDON && operationType != OperationType.EXTENDED && operationType != OperationType.UNBIND) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_MISSING_REQUIRED_ATTR.get(entry.getDN(), ATTR_TARGET_ENTRY_DN));
        }
        this.authorizationIdentityDN = entry.getAttributeValue(ATTR_AUTHORIZATION_IDENTITY_DN);
        this.requestControls = DraftChuLDAPLogSchema00Entry.decodeControls(entry, ATTR_REQUEST_CONTROL);
        this.responseControls = DraftChuLDAPLogSchema00Entry.decodeControls(entry, ATTR_RESPONSE_CONTROL);
        String resultCodeString = entry.getAttributeValue(ATTR_RESULT_CODE);
        if (resultCodeString == null) {
            this.resultCode = null;
        } else {
            try {
                this.resultCode = ResultCode.valueOf(Integer.parseInt(resultCodeString));
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_RESULT_CODE_ERROR.get(entry.getDN(), resultCodeString, ATTR_RESULT_CODE), e);
            }
        }
        this.diagnosticMessage = entry.getAttributeValue(ATTR_DIAGNOSTIC_MESSAGE);
        String[] referralArray = entry.getAttributeValues(ATTR_REFERRAL_URL);
        this.referralURLs = referralArray == null ? Collections.emptyList() : Collections.unmodifiableList(StaticUtils.toList(referralArray));
    }

    @NotNull
    private static List<Control> decodeControls(@NotNull Entry entry, @NotNull String attributeName) throws LDAPException {
        byte[][] values = entry.getAttributeValueByteArrays(attributeName);
        if (values == null || values.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Control> controls = new ArrayList<Control>(values.length);
        for (byte[] controlBytes : values) {
            try {
                controls.add(Control.decode(ASN1Sequence.decodeAsSequence(controlBytes)));
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_CONTROL_ERROR.get(entry.getDN(), attributeName, StaticUtils.getExceptionMessage(e)), e);
            }
        }
        return Collections.unmodifiableList(controls);
    }

    @NotNull
    public final OperationType getOperationType() {
        return this.operationType;
    }

    @Nullable
    public final String getTargetEntryDN() {
        return this.targetEntryDN;
    }

    @NotNull
    public final String getProcessingStartTimeString() {
        return this.processingStartTimeString;
    }

    @NotNull
    public final Date getProcessingStartTimeDate() {
        return this.processingStartTimeDate;
    }

    @Nullable
    public final String getProcessingEndTimeString() {
        return this.processingEndTimeString;
    }

    @Nullable
    public final Date getProcessingEndTimeDate() {
        return this.processingEndTimeDate;
    }

    @NotNull
    public final String getSessionID() {
        return this.sessionID;
    }

    @NotNull
    public final List<Control> getRequestControls() {
        return this.requestControls;
    }

    @NotNull
    final Control[] getRequestControlArray() {
        return this.requestControls.toArray(StaticUtils.NO_CONTROLS);
    }

    @Nullable
    public final ResultCode getResultCode() {
        return this.resultCode;
    }

    @Nullable
    public final String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    @NotNull
    public final List<String> getReferralURLs() {
        return this.referralURLs;
    }

    @NotNull
    public final List<Control> getResponseControls() {
        return this.responseControls;
    }

    @Nullable
    public final String getAuthorizationIdentityDN() {
        return this.authorizationIdentityDN;
    }

    @Nullable
    public final LDAPResult toLDAPResult() {
        if (this.resultCode == null) {
            return null;
        }
        return new LDAPResult(-1, this.resultCode, this.diagnosticMessage, null, this.referralURLs, this.responseControls);
    }

    @NotNull
    public static DraftChuLDAPLogSchema00Entry decode(@NotNull Entry entry) throws LDAPException {
        String opType = entry.getAttributeValue(ATTR_OPERATION_TYPE);
        if (opType == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_NO_OP_TYPE.get(entry.getDN(), ATTR_OPERATION_TYPE));
        }
        String lowerOpType = StaticUtils.toLowerCase(opType);
        if (lowerOpType.equals("abandon")) {
            return new DraftChuLDAPLogSchema00AbandonEntry(entry);
        }
        if (lowerOpType.equals("add")) {
            return new DraftChuLDAPLogSchema00AddEntry(entry);
        }
        if (lowerOpType.equals("bind")) {
            return new DraftChuLDAPLogSchema00BindEntry(entry);
        }
        if (lowerOpType.equals("compare")) {
            return new DraftChuLDAPLogSchema00CompareEntry(entry);
        }
        if (lowerOpType.equals("delete")) {
            return new DraftChuLDAPLogSchema00DeleteEntry(entry);
        }
        if (lowerOpType.startsWith("extended")) {
            return new DraftChuLDAPLogSchema00ExtendedEntry(entry);
        }
        if (lowerOpType.equals("modify")) {
            return new DraftChuLDAPLogSchema00ModifyEntry(entry);
        }
        if (lowerOpType.equals("modrdn")) {
            return new DraftChuLDAPLogSchema00ModifyDNEntry(entry);
        }
        if (lowerOpType.equals("search")) {
            return new DraftChuLDAPLogSchema00SearchEntry(entry);
        }
        if (lowerOpType.equals("unbind")) {
            return new DraftChuLDAPLogSchema00UnbindEntry(entry);
        }
        throw new LDAPException(ResultCode.DECODING_ERROR, ExperimentalMessages.ERR_LOGSCHEMA_DECODE_UNRECOGNIZED_OP_TYPE.get(entry.getDN(), ATTR_OPERATION_TYPE, opType));
    }
}

