/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.change;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.jmap.api.change.JmapChange;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;

public class MailboxChange
implements JmapChange {
    private final AccountId accountId;
    private final State state;
    private final ZonedDateTime date;
    private final boolean delegated;
    private final boolean isCountChange;
    private final List<MailboxId> created;
    private final List<MailboxId> updated;
    private final List<MailboxId> destroyed;

    public static Builder.RequiredAccountId builder() {
        return accountId -> state -> date -> isCountChange -> new Builder(accountId, state, date, isCountChange);
    }

    private MailboxChange(AccountId accountId, State state, ZonedDateTime date, boolean delegated, boolean isCountChange, List<MailboxId> created, List<MailboxId> updated, List<MailboxId> destroyed) {
        this.accountId = accountId;
        this.state = state;
        this.date = date;
        this.delegated = delegated;
        this.isCountChange = isCountChange;
        this.created = created;
        this.updated = updated;
        this.destroyed = destroyed;
    }

    @Override
    public AccountId getAccountId() {
        return this.accountId;
    }

    public State getState() {
        return this.state;
    }

    public ZonedDateTime getDate() {
        return this.date;
    }

    public boolean isDelegated() {
        return this.delegated;
    }

    public boolean isCountChange() {
        return this.isCountChange;
    }

    public List<MailboxId> getCreated() {
        return this.created;
    }

    public List<MailboxId> getUpdated() {
        return this.updated;
    }

    public List<MailboxId> getDestroyed() {
        return this.destroyed;
    }

    public final boolean equals(Object o) {
        if (o instanceof MailboxChange) {
            MailboxChange that = (MailboxChange)o;
            return Objects.equals(this.accountId, that.accountId) && Objects.equals(this.state, that.state) && Objects.equals(this.date, that.date) && Objects.equals(this.isCountChange, that.isCountChange) && Objects.equals(this.delegated, that.delegated) && Objects.equals(this.created, that.created) && Objects.equals(this.updated, that.updated) && Objects.equals(this.destroyed, that.destroyed);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.accountId, this.state, this.date, this.isCountChange, this.delegated, this.created, this.updated, this.destroyed);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountId", (Object)this.accountId).add("state", (Object)this.state).add("date", (Object)this.date).add("isCountChange", this.isCountChange).add("isDelegated", this.delegated).add("created", this.created).add("updated", this.updated).add("destroyed", this.destroyed).toString();
    }

    public static class Builder {
        private final AccountId accountId;
        private final State state;
        private final ZonedDateTime date;
        private boolean delegated;
        private final boolean isCountChange;
        private Optional<List<MailboxId>> created;
        private Optional<List<MailboxId>> updated;
        private Optional<List<MailboxId>> destroyed;

        private Builder(AccountId accountId, State state, ZonedDateTime date, boolean isCountChange) {
            Preconditions.checkNotNull((Object)accountId, (Object)"'accountId' cannot be null");
            Preconditions.checkNotNull((Object)state, (Object)"'state' cannot be null");
            Preconditions.checkNotNull((Object)date, (Object)"'date' cannot be null");
            this.accountId = accountId;
            this.state = state;
            this.date = date;
            this.isCountChange = isCountChange;
            this.created = Optional.empty();
            this.updated = Optional.empty();
            this.destroyed = Optional.empty();
        }

        public Builder delegated() {
            return this.delegated(true);
        }

        public Builder delegated(boolean delegated) {
            this.delegated = delegated;
            return this;
        }

        public Builder created(List<MailboxId> created) {
            this.created = Optional.of(created);
            return this;
        }

        public Builder updated(List<MailboxId> updated) {
            this.updated = Optional.of(updated);
            return this;
        }

        public Builder destroyed(List<MailboxId> destroyed) {
            this.destroyed = Optional.of(destroyed);
            return this;
        }

        public MailboxChange build() {
            return new MailboxChange(this.accountId, this.state, this.date, this.delegated, this.isCountChange, this.created.orElse((List<MailboxId>)ImmutableList.of()), this.updated.orElse((List<MailboxId>)ImmutableList.of()), this.destroyed.orElse((List<MailboxId>)ImmutableList.of()));
        }

        @FunctionalInterface
        public static interface RequiredIsCountChange {
            public Builder isCountChange(boolean var1);
        }

        @FunctionalInterface
        public static interface RequiredDate {
            public RequiredIsCountChange date(ZonedDateTime var1);
        }

        @FunctionalInterface
        public static interface RequiredState {
            public RequiredDate state(State var1);
        }

        @FunctionalInterface
        public static interface RequiredAccountId {
            public RequiredState accountId(AccountId var1);
        }
    }

    public static class Factory {
        private final State.Factory stateFactory;

        @Inject
        public Factory(State.Factory stateFactory) {
            this.stateFactory = stateFactory;
        }

        public JmapChange fromMailboxAdded(MailboxEvents.MailboxAdded mailboxAdded, ZonedDateTime now) {
            return MailboxChange.builder().accountId(AccountId.fromUsername(mailboxAdded.getUsername())).state(this.stateFactory.generate()).date(now).isCountChange(false).created((List<MailboxId>)ImmutableList.of((Object)mailboxAdded.getMailboxId())).build();
        }

        public List<JmapChange> fromMailboxRenamed(MailboxEvents.MailboxRenamed mailboxRenamed, ZonedDateTime now, List<AccountId> sharees) {
            MailboxChange ownerChange = MailboxChange.builder().accountId(AccountId.fromUsername(mailboxRenamed.getUsername())).state(this.stateFactory.generate()).date(now).isCountChange(false).updated((List<MailboxId>)ImmutableList.of((Object)mailboxRenamed.getMailboxId())).build();
            Stream<MailboxChange> shareeChanges = sharees.stream().map(shareeId -> MailboxChange.builder().accountId((AccountId)shareeId).state(this.stateFactory.generate()).date(now).isCountChange(false).updated((List<MailboxId>)ImmutableList.of((Object)mailboxRenamed.getMailboxId())).delegated().build());
            return (List)Stream.concat(Stream.of(ownerChange), shareeChanges).collect(ImmutableList.toImmutableList());
        }

        public List<JmapChange> fromMailboxACLUpdated(MailboxEvents.MailboxACLUpdated mailboxACLUpdated, ZonedDateTime now, List<AccountId> sharees) {
            MailboxChange ownerChange = MailboxChange.builder().accountId(AccountId.fromUsername(mailboxACLUpdated.getUsername())).state(this.stateFactory.generate()).date(now).isCountChange(false).updated((List<MailboxId>)ImmutableList.of((Object)mailboxACLUpdated.getMailboxId())).build();
            Stream<MailboxChange> shareeChanges = sharees.stream().map(shareeId -> MailboxChange.builder().accountId((AccountId)shareeId).state(this.stateFactory.generate()).date(now).isCountChange(false).updated((List<MailboxId>)ImmutableList.of((Object)mailboxACLUpdated.getMailboxId())).delegated().build());
            return (List)Stream.concat(Stream.of(ownerChange), shareeChanges).collect(ImmutableList.toImmutableList());
        }

        public List<JmapChange> fromMailboxDeletion(MailboxEvents.MailboxDeletion mailboxDeletion, ZonedDateTime now) {
            MailboxChange ownerChange = MailboxChange.builder().accountId(AccountId.fromUsername(mailboxDeletion.getUsername())).state(this.stateFactory.generate()).date(now).isCountChange(false).destroyed((List<MailboxId>)ImmutableList.of((Object)mailboxDeletion.getMailboxId())).build();
            Stream<MailboxChange> shareeChanges = mailboxDeletion.getMailboxACL().getEntries().keySet().stream().filter(rfc4314Rights -> !rfc4314Rights.isNegative()).filter(rfc4314Rights -> rfc4314Rights.getNameType().equals((Object)MailboxACL.NameType.user)).map(MailboxACL.EntryKey::getName).map(name -> MailboxChange.builder().accountId(AccountId.fromString(name)).state(this.stateFactory.generate()).date(now).isCountChange(false).destroyed((List<MailboxId>)ImmutableList.of((Object)mailboxDeletion.getMailboxId())).delegated().build());
            return (List)Stream.concat(Stream.of(ownerChange), shareeChanges).collect(ImmutableList.toImmutableList());
        }
    }
}

