/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum HorizontalAlignment {
    LEFT,
    CENTER,
    RIGHT;


    public void format(@NotNull StringBuilder buffer, @NotNull String text, int width) {
        int i;
        int spacesAfter;
        int spacesBefore;
        int length = text.length();
        if (length >= width) {
            buffer.append(text.substring(0, width));
            return;
        }
        switch (this) {
            case LEFT: {
                spacesBefore = 0;
                spacesAfter = width - length;
                break;
            }
            case CENTER: {
                int totalSpaces = width - length;
                spacesBefore = totalSpaces / 2;
                spacesAfter = totalSpaces - spacesBefore;
                break;
            }
            default: {
                spacesBefore = width - length;
                spacesAfter = 0;
            }
        }
        for (i = 0; i < spacesBefore; ++i) {
            buffer.append(' ');
        }
        buffer.append(text);
        for (i = 0; i < spacesAfter; ++i) {
            buffer.append(' ');
        }
    }

    @Nullable
    public static HorizontalAlignment forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "left": {
                return LEFT;
            }
            case "center": {
                return CENTER;
            }
            case "right": {
                return RIGHT;
            }
        }
        return null;
    }
}

