/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.mailbox.MailboxAnnotationManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.RequestAware;
import org.apache.james.mailbox.RightManager;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MultimailboxesSearchQuery;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public interface MailboxManager
extends RequestAware,
RightManager,
MailboxAnnotationManager,
SessionProvider {
    public static final int MAX_MAILBOX_NAME_LENGTH = 200;

    public EnumSet<MailboxCapabilities> getSupportedMailboxCapabilities();

    public boolean hasCapability(MailboxCapabilities var1);

    public EnumSet<MessageCapabilities> getSupportedMessageCapabilities();

    public EnumSet<SearchCapabilities> getSupportedSearchCapabilities();

    public MessageManager getMailbox(MailboxPath var1, MailboxSession var2) throws MailboxException;

    public MessageManager getMailbox(MailboxId var1, MailboxSession var2) throws MailboxException;

    public Publisher<MessageManager> getMailboxReactive(MailboxId var1, MailboxSession var2);

    public Publisher<MessageManager> getMailboxReactive(MailboxPath var1, MailboxSession var2);

    public Optional<MailboxId> createMailbox(MailboxPath var1, MailboxSession var2) throws MailboxException;

    public void deleteMailbox(MailboxPath var1, MailboxSession var2) throws MailboxException;

    public Mailbox deleteMailbox(MailboxId var1, MailboxSession var2) throws MailboxException;

    public List<MailboxRenamedResult> renameMailbox(MailboxPath var1, MailboxPath var2, RenameOption var3, MailboxSession var4) throws MailboxException;

    default public List<MailboxRenamedResult> renameMailbox(MailboxPath from, MailboxPath to, MailboxSession session) throws MailboxException {
        return this.renameMailbox(from, to, RenameOption.NONE, session);
    }

    public List<MailboxRenamedResult> renameMailbox(MailboxId var1, MailboxPath var2, RenameOption var3, MailboxSession var4) throws MailboxException;

    default public List<MailboxRenamedResult> renameMailbox(MailboxId mailboxId, MailboxPath newMailboxPath, MailboxSession session) throws MailboxException {
        return this.renameMailbox(mailboxId, newMailboxPath, RenameOption.NONE, session);
    }

    public List<MessageRange> copyMessages(MessageRange var1, MailboxPath var2, MailboxPath var3, MailboxSession var4) throws MailboxException;

    public List<MessageRange> copyMessages(MessageRange var1, MailboxId var2, MailboxId var3, MailboxSession var4) throws MailboxException;

    public List<MessageRange> moveMessages(MessageRange var1, MailboxPath var2, MailboxPath var3, MailboxSession var4) throws MailboxException;

    public List<MessageRange> moveMessages(MessageRange var1, MailboxId var2, MailboxId var3, MailboxSession var4) throws MailboxException;

    default public Flux<MailboxMetaData> search(MailboxQuery expression, MailboxSession session) {
        return this.search(expression, MailboxSearchFetchType.Counters, session);
    }

    public Flux<MailboxMetaData> search(MailboxQuery var1, MailboxSearchFetchType var2, MailboxSession var3);

    public Publisher<MessageId> search(MultimailboxesSearchQuery var1, MailboxSession var2, long var3);

    public Publisher<MessageId> getThread(ThreadId var1, MailboxSession var2);

    public Publisher<Boolean> mailboxExists(MailboxPath var1, MailboxSession var2);

    default public Publisher<Boolean> hasInbox(MailboxSession session) {
        return this.mailboxExists(MailboxPath.inbox(session), session);
    }

    public List<MailboxPath> list(MailboxSession var1) throws MailboxException;

    public boolean hasChildren(MailboxPath var1, MailboxSession var2) throws MailboxException;

    public static enum RenameOption {
        NONE,
        RENAME_SUBSCRIPTIONS;

    }

    public static enum MailboxSearchFetchType {
        Minimal,
        Counters;

    }

    public static class MailboxRenamedResult {
        private final MailboxId mailboxId;
        private final MailboxPath originPath;
        private final MailboxPath destinationPath;

        public MailboxRenamedResult(MailboxId mailboxId, MailboxPath originPath, MailboxPath destinationPath) {
            this.mailboxId = mailboxId;
            this.originPath = originPath;
            this.destinationPath = destinationPath;
        }

        public MailboxId getMailboxId() {
            return this.mailboxId;
        }

        public MailboxPath getOriginPath() {
            return this.originPath;
        }

        public MailboxPath getDestinationPath() {
            return this.destinationPath;
        }

        public final boolean equals(Object o) {
            if (o instanceof MailboxRenamedResult) {
                MailboxRenamedResult that = (MailboxRenamedResult)o;
                return Objects.equals(this.mailboxId, that.mailboxId) && Objects.equals(this.originPath, that.originPath) && Objects.equals(this.destinationPath, that.destinationPath);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.mailboxId, this.originPath, this.destinationPath);
        }
    }

    public static enum SearchCapabilities {
        MultimailboxSearch,
        PartialEmailMatch,
        Text,
        FullText,
        Attachment,
        AttachmentFileName;

    }

    public static enum MessageCapabilities {
        UniqueID;

    }

    public static enum MailboxCapabilities {
        Annotation,
        Move,
        Namespace,
        UserFlag,
        ACL,
        Quota;

    }
}

