/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.task.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.json.JsonGenericSerializer;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.james.task.TaskExecutionDetails;

public class JsonTaskAdditionalInformationSerializer {
    private JsonGenericSerializer<TaskExecutionDetails.AdditionalInformation, AdditionalInformationDTO> jsonGenericSerializer;

    public static JsonTaskAdditionalInformationSerializer of(AdditionalInformationDTOModule<? extends TaskExecutionDetails.AdditionalInformation, ? extends AdditionalInformationDTO> ... modules) {
        return new JsonTaskAdditionalInformationSerializer((Set<AdditionalInformationDTOModule<? extends TaskExecutionDetails.AdditionalInformation, ? extends AdditionalInformationDTO>>)ImmutableSet.copyOf(modules));
    }

    @Inject
    private JsonTaskAdditionalInformationSerializer(Set<AdditionalInformationDTOModule<? extends TaskExecutionDetails.AdditionalInformation, ? extends AdditionalInformationDTO>> modules) {
        this.jsonGenericSerializer = JsonGenericSerializer.forModules(modules).withoutNestedType();
    }

    public String serialize(TaskExecutionDetails.AdditionalInformation additionalInformation) throws JsonProcessingException {
        try {
            return this.jsonGenericSerializer.serialize((Object)additionalInformation);
        }
        catch (JsonGenericSerializer.UnknownTypeException e) {
            throw new UnknownAdditionalInformationException(e);
        }
    }

    public TaskExecutionDetails.AdditionalInformation deserialize(String value) throws IOException {
        try {
            return (TaskExecutionDetails.AdditionalInformation)this.jsonGenericSerializer.deserialize(value);
        }
        catch (JsonGenericSerializer.UnknownTypeException e) {
            throw new UnknownAdditionalInformationException(e);
        }
        catch (JsonGenericSerializer.InvalidTypeException e) {
            throw new InvalidAdditionalInformationException(e);
        }
    }

    public static class UnknownAdditionalInformationException
    extends RuntimeException {
        public UnknownAdditionalInformationException(JsonGenericSerializer.UnknownTypeException original) {
            super((Throwable)original);
        }
    }

    public static class InvalidAdditionalInformationException
    extends RuntimeException {
        public InvalidAdditionalInformationException(JsonGenericSerializer.InvalidTypeException original) {
            super((Throwable)original);
        }
    }
}

