/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.response;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.mail.Flags;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.message.Literal;
import org.apache.james.mailbox.MessageSequenceNumber;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;

public final class FetchResponse
implements ImapResponseMessage {
    private final MessageSequenceNumber messageNumber;
    private final Flags flags;
    private final MessageUid uid;
    private final Date internalDate;
    private final Long size;
    private final List<BodyElement> elements;
    private final Envelope envelope;
    private final Structure body;
    private final Structure bodystructure;
    private final ModSeq modSeq;

    public FetchResponse(MessageSequenceNumber messageNumber, Flags flags, MessageUid uid, ModSeq modSeq, Date internalDate, Long size, Envelope envelope, Structure body, Structure bodystructure, List<BodyElement> elements) {
        this.messageNumber = messageNumber;
        this.flags = flags;
        this.uid = uid;
        this.internalDate = internalDate;
        this.size = size;
        this.envelope = envelope;
        this.elements = elements;
        this.body = body;
        this.bodystructure = bodystructure;
        this.modSeq = modSeq;
    }

    public Structure getBody() {
        return this.body;
    }

    public Structure getBodyStructure() {
        return this.bodystructure;
    }

    public MessageSequenceNumber getMessageNumber() {
        return this.messageNumber;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public MessageUid getUid() {
        return this.uid;
    }

    public Date getInternalDate() {
        return this.internalDate;
    }

    public Long getSize() {
        return this.size;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public List<BodyElement> getElements() {
        return this.elements;
    }

    public ModSeq getModSeq() {
        return this.modSeq;
    }

    public static interface Envelope {
        public String getDate();

        public String getSubject();

        public Address[] getFrom();

        public Address[] getSender();

        public Address[] getReplyTo();

        public Address[] getTo();

        public Address[] getCc();

        public Address[] getBcc();

        public String getInReplyTo();

        public String getMessageId();

        public static interface Address {
            public String getPersonalName();

            public String getAtDomainList();

            public String getMailboxName();

            public String getHostName();
        }
    }

    public static interface Structure {
        public String getMediaType();

        public String getSubType();

        public List<String> getParameters();

        public String getId();

        public String getDescription();

        public String getEncoding();

        public long getOctets();

        public long getLines();

        public String getMD5();

        public Map<String, String> getDispositionParams();

        public String getDisposition();

        public List<String> getLanguages();

        public String getLocation();

        public Iterator<Structure> parts();

        public Envelope getEnvelope();

        public Structure getBody();
    }

    public static interface BodyElement
    extends Literal {
        public String getName();
    }
}

