/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.date;

import com.google.common.collect.ImmutableMap;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;

public class ImapDateTimeFormatter {
    private static final int INITIAL_YEAR = 1970;

    public static DateTimeFormatter rfc5322() {
        return new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().optionalStart().appendText((TemporalField)ChronoField.DAY_OF_WEEK, ImapDateTimeFormatter.dayOfWeek()).appendLiteral(", ").optionalEnd().appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(' ').appendText((TemporalField)ChronoField.MONTH_OF_YEAR, ImapDateTimeFormatter.monthOfYear()).appendLiteral(' ').appendValueReduced((TemporalField)ChronoField.YEAR, 2, 4, 1970).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().appendLiteral(' ').appendOffset("+HHMM", "GMT").toFormatter();
    }

    private static ImmutableMap<Long, String> monthOfYear() {
        return ImmutableMap.builder().put(1L, "Jan").put(2L, "Feb").put(3L, "Mar").put(4L, "Apr").put(5L, "May").put(6L, "Jun").put(7L, "Jul").put(8L, "Aug").put(9L, "Sep").put(10L, "Oct").put(11L, "Nov").put(12L, "Dec").build();
    }

    private static ImmutableMap<Long, String> dayOfWeek() {
        return ImmutableMap.builder().put(1L, "Mon").put(2L, "Tue").put(3L, "Wed").put(4L, "Thu").put(5L, "Fri").put(6L, "Sat").put(7L, "Sun").build();
    }
}

