/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.time.Clock;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.mail.internet.MimeMessage;
import org.apache.james.backends.rabbitmq.QueueArguments;
import org.apache.james.backends.rabbitmq.RabbitMQConfiguration;
import org.apache.james.backends.rabbitmq.ReceiverProvider;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.Store;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.blob.mail.MimeMessageStore;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.rabbitmq.Dequeuer;
import org.apache.james.queue.rabbitmq.Enqueuer;
import org.apache.james.queue.rabbitmq.MailLoader;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.MailReferenceSerializer;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueue;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueueManagement;
import org.apache.james.queue.rabbitmq.view.RabbitMQMailQueueConfiguration;
import org.apache.james.queue.rabbitmq.view.api.MailQueueView;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.rabbitmq.BindingSpecification;
import reactor.rabbitmq.ExchangeSpecification;
import reactor.rabbitmq.QueueSpecification;
import reactor.rabbitmq.Sender;

public class RabbitMQMailQueueFactory
implements MailQueueFactory<RabbitMQMailQueue> {
    private final RabbitMQMailQueueManagement mqManagementApi;
    private final PrivateFactory privateFactory;
    private final RabbitMQConfiguration configuration;
    private final Sender sender;

    @Inject
    @VisibleForTesting
    RabbitMQMailQueueFactory(Sender sender, RabbitMQMailQueueManagement mqManagementApi, PrivateFactory privateFactory, RabbitMQConfiguration configuration) {
        this.sender = sender;
        this.mqManagementApi = mqManagementApi;
        this.privateFactory = privateFactory;
        this.configuration = configuration;
    }

    public Optional<RabbitMQMailQueue> getQueue(org.apache.james.queue.api.MailQueueName name, MailQueueFactory.PrefetchCount count) {
        return this.getQueueFromRabbitServer(MailQueueName.fromString(name.asString()), count);
    }

    public RabbitMQMailQueue createQueue(org.apache.james.queue.api.MailQueueName name, MailQueueFactory.PrefetchCount count) {
        MailQueueName mailQueueName = MailQueueName.fromString(name.asString());
        return this.getQueueFromRabbitServer(mailQueueName, count).orElseGet(() -> this.createQueueIntoRabbitServer(mailQueueName, count));
    }

    public Set<org.apache.james.queue.api.MailQueueName> listCreatedMailQueues() {
        return (Set)this.mqManagementApi.listCreatedMailQueueNames().map(MailQueueName::asString).map(org.apache.james.queue.api.MailQueueName::of).collect(ImmutableSet.toImmutableSet());
    }

    private RabbitMQMailQueue createQueueIntoRabbitServer(MailQueueName mailQueueName, MailQueueFactory.PrefetchCount prefetchCount) {
        String exchangeName = mailQueueName.toRabbitExchangeName().asString();
        Flux.concat((Publisher[])new Publisher[]{this.sender.declareExchange(ExchangeSpecification.exchange((String)exchangeName).durable(true).type("direct")), this.sender.declareExchange(ExchangeSpecification.exchange((String)mailQueueName.toDeadLetterExchangeName()).durable(true).type("direct")), this.sender.declareQueue(QueueSpecification.queue((String)mailQueueName.toWorkQueueName().asString()).durable(true).exclusive(false).autoDelete(false).arguments((Map)this.configuration.workQueueArgumentsBuilder().deadLetter(mailQueueName.toDeadLetterExchangeName()).build())), this.sender.declareQueue(QueueSpecification.queue((String)mailQueueName.toDeadLetterQueueName()).durable(true).exclusive(false).autoDelete(false).arguments((Map)QueueArguments.NO_ARGUMENTS)), this.sender.bind(BindingSpecification.binding().exchange(mailQueueName.toRabbitExchangeName().asString()).queue(mailQueueName.toWorkQueueName().asString()).routingKey("")), this.sender.bind(BindingSpecification.binding().exchange(mailQueueName.toDeadLetterExchangeName()).queue(mailQueueName.toDeadLetterQueueName()).routingKey(""))}).then().block();
        return this.privateFactory.create(mailQueueName, prefetchCount);
    }

    private Optional<RabbitMQMailQueue> getQueueFromRabbitServer(MailQueueName name, MailQueueFactory.PrefetchCount prefetchCount) {
        return this.mqManagementApi.listCreatedMailQueueNames().filter(name::equals).map(queueName -> this.privateFactory.create((MailQueueName)queueName, prefetchCount)).findFirst();
    }

    @VisibleForTesting
    static class PrivateFactory {
        private final MetricFactory metricFactory;
        private final GaugeRegistry gaugeRegistry;
        private final ReceiverProvider receiverProvider;
        private final Sender sender;
        private final Store<MimeMessage, MimeMessagePartsId> mimeMessageStore;
        private final MailReferenceSerializer mailReferenceSerializer;
        private final MailLoader mailLoader;
        private final MailQueueView.Factory mailQueueViewFactory;
        private final Clock clock;
        private final MailQueueItemDecoratorFactory decoratorFactory;
        private final RabbitMQMailQueueConfiguration configuration;

        @Inject
        @VisibleForTesting
        PrivateFactory(MetricFactory metricFactory, GaugeRegistry gaugeRegistry, Sender sender, ReceiverProvider receiverProvider, MimeMessageStore.Factory mimeMessageStoreFactory, BlobId.Factory blobIdFactory, MailQueueView.Factory mailQueueViewFactory, Clock clock, MailQueueItemDecoratorFactory decoratorFactory, RabbitMQMailQueueConfiguration configuration) {
            this.metricFactory = metricFactory;
            this.gaugeRegistry = gaugeRegistry;
            this.sender = sender;
            this.receiverProvider = receiverProvider;
            this.mimeMessageStore = mimeMessageStoreFactory.mimeMessageStore();
            this.mailQueueViewFactory = mailQueueViewFactory;
            this.clock = clock;
            this.decoratorFactory = decoratorFactory;
            this.mailReferenceSerializer = new MailReferenceSerializer();
            this.mailLoader = new MailLoader(this.mimeMessageStore, blobIdFactory);
            this.configuration = configuration;
        }

        RabbitMQMailQueue create(MailQueueName mailQueueName, MailQueueFactory.PrefetchCount prefetchCount) {
            MailQueueView mailQueueView = this.mailQueueViewFactory.create(mailQueueName);
            mailQueueView.initialize(mailQueueName);
            RabbitMQMailQueue rabbitMQMailQueue = new RabbitMQMailQueue(this.metricFactory, mailQueueName, new Enqueuer(mailQueueName, this.sender, this.mimeMessageStore, this.mailReferenceSerializer, this.metricFactory, mailQueueView, this.clock), new Dequeuer(mailQueueName, this.receiverProvider, this.mailLoader, this.mailReferenceSerializer, this.metricFactory, mailQueueView, prefetchCount), mailQueueView, this.decoratorFactory);
            this.registerGaugeFor(rabbitMQMailQueue);
            return rabbitMQMailQueue;
        }

        private void registerGaugeFor(RabbitMQMailQueue rabbitMQMailQueue) {
            if (this.configuration.isSizeMetricsEnabled()) {
                this.gaugeRegistry.register("mailQueueSize:" + rabbitMQMailQueue.getName().asString(), rabbitMQMailQueue::getSize);
            }
        }
    }
}

