/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra;

import java.util.Optional;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.backends.cassandra.init.configuration.CassandraConsistenciesConfiguration;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.ACLMapper;
import org.apache.james.mailbox.cassandra.mail.CassandraApplicableFlagDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraAttachmentDAOV2;
import org.apache.james.mailbox.cassandra.mail.CassandraAttachmentMessageIdDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraDeletedMessageDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraFirstUnseenDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxCounterDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMailboxRecentsDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageDAOV3;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageIdToImapUidDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageMetadata;
import org.apache.james.mailbox.cassandra.mail.CassandraThreadDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraThreadLookupDAO;
import org.apache.james.mailbox.cassandra.mail.CassandraUserMailboxRightsDAO;
import org.apache.james.mailbox.cassandra.mail.MessageAttachmentRepresentation;
import org.apache.james.mailbox.cassandra.mail.MessageRepresentation;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.util.FunctionalUtils;
import org.apache.james.util.streams.Limit;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DeleteMessageListener
implements EventListener.ReactiveGroupEventListener {
    private static final Optional<CassandraId> ALL_MAILBOXES = Optional.empty();
    private final CassandraThreadDAO threadDAO;
    private final CassandraThreadLookupDAO threadLookupDAO;
    private final CassandraMessageIdToImapUidDAO imapUidDAO;
    private final CassandraMessageIdDAO messageIdDAO;
    private final CassandraMessageDAO messageDAO;
    private final CassandraMessageDAOV3 messageDAOV3;
    private final CassandraAttachmentDAOV2 attachmentDAO;
    private final CassandraAttachmentMessageIdDAO attachmentMessageIdDAO;
    private final ACLMapper aclMapper;
    private final CassandraUserMailboxRightsDAO rightsDAO;
    private final CassandraApplicableFlagDAO applicableFlagDAO;
    private final CassandraFirstUnseenDAO firstUnseenDAO;
    private final CassandraDeletedMessageDAO deletedMessageDAO;
    private final CassandraMailboxCounterDAO counterDAO;
    private final CassandraMailboxRecentsDAO recentsDAO;
    private final BlobStore blobStore;
    private final CassandraConfiguration cassandraConfiguration;

    @Inject
    public DeleteMessageListener(CassandraThreadDAO threadDAO, CassandraThreadLookupDAO threadLookupDAO, CassandraMessageIdToImapUidDAO imapUidDAO, CassandraMessageIdDAO messageIdDAO, CassandraMessageDAO messageDAO, CassandraMessageDAOV3 messageDAOV3, CassandraAttachmentDAOV2 attachmentDAO, CassandraAttachmentMessageIdDAO attachmentMessageIdDAO, ACLMapper aclMapper, CassandraUserMailboxRightsDAO rightsDAO, CassandraApplicableFlagDAO applicableFlagDAO, CassandraFirstUnseenDAO firstUnseenDAO, CassandraDeletedMessageDAO deletedMessageDAO, CassandraMailboxCounterDAO counterDAO, CassandraMailboxRecentsDAO recentsDAO, BlobStore blobStore, CassandraConfiguration cassandraConfiguration) {
        this.threadDAO = threadDAO;
        this.threadLookupDAO = threadLookupDAO;
        this.imapUidDAO = imapUidDAO;
        this.messageIdDAO = messageIdDAO;
        this.messageDAO = messageDAO;
        this.messageDAOV3 = messageDAOV3;
        this.attachmentDAO = attachmentDAO;
        this.attachmentMessageIdDAO = attachmentMessageIdDAO;
        this.aclMapper = aclMapper;
        this.rightsDAO = rightsDAO;
        this.applicableFlagDAO = applicableFlagDAO;
        this.firstUnseenDAO = firstUnseenDAO;
        this.deletedMessageDAO = deletedMessageDAO;
        this.counterDAO = counterDAO;
        this.recentsDAO = recentsDAO;
        this.blobStore = blobStore;
        this.cassandraConfiguration = cassandraConfiguration;
    }

    public Group getDefaultGroup() {
        return new DeleteMessageListenerGroup();
    }

    public boolean isHandling(Event event) {
        return event instanceof MailboxEvents.Expunged || event instanceof MailboxEvents.MailboxDeletion;
    }

    public Publisher<Void> reactiveEvent(Event event) {
        if (event instanceof MailboxEvents.Expunged) {
            MailboxEvents.Expunged expunged = (MailboxEvents.Expunged)event;
            return this.handleMessageDeletion(expunged);
        }
        if (event instanceof MailboxEvents.MailboxDeletion) {
            MailboxEvents.MailboxDeletion mailboxDeletion = (MailboxEvents.MailboxDeletion)event;
            CassandraId mailboxId = (CassandraId)mailboxDeletion.getMailboxId();
            return this.handleMailboxDeletion(mailboxId);
        }
        return Mono.empty();
    }

    private Mono<Void> handleMailboxDeletion(CassandraId mailboxId) {
        int prefetch = 1;
        return Flux.mergeDelayError((int)prefetch, (Publisher[])new Publisher[]{this.messageIdDAO.retrieveMessages(mailboxId, MessageRange.all(), Limit.unlimited()).map(CassandraMessageMetadata::getComposedMessageId).map(ComposedMessageIdWithMetaData::getComposedMessageId).concatMap(metadata -> this.handleMessageDeletionAsPartOfMailboxDeletion((CassandraMessageId)metadata.getMessageId(), mailboxId).then(this.imapUidDAO.delete((CassandraMessageId)metadata.getMessageId(), mailboxId)).then(this.messageIdDAO.delete(mailboxId, metadata.getUid()))), this.deleteAcl(mailboxId), this.applicableFlagDAO.delete(mailboxId), this.firstUnseenDAO.removeAll(mailboxId), this.deletedMessageDAO.removeAll(mailboxId), this.counterDAO.delete(mailboxId), this.recentsDAO.delete(mailboxId)}).then();
    }

    private Mono<Void> handleMessageDeletion(MailboxEvents.Expunged expunged) {
        return Flux.fromIterable(expunged.getExpunged().values()).map(MessageMetaData::getMessageId).map(CassandraMessageId.class::cast).concatMap(this::handleMessageDeletion).then();
    }

    private Mono<Void> deleteAcl(CassandraId mailboxId) {
        return this.aclMapper.getACL(mailboxId).flatMap(acl -> this.rightsDAO.update(mailboxId, ACLDiff.computeDiff((MailboxACL)acl, (MailboxACL)MailboxACL.EMPTY)).then(this.aclMapper.delete(mailboxId)));
    }

    private Mono<Void> handleMessageDeletion(CassandraMessageId messageId) {
        return Mono.just((Object)messageId).filterWhen(this::isReferenced).flatMap(id -> this.readMessage((CassandraMessageId)id).flatMap(message -> this.deleteUnreferencedAttachments((MessageRepresentation)message).thenReturn(message)).flatMap(this::deleteMessageBlobs).flatMap(this::deleteAttachmentMessageIds).then(this.messageDAO.delete(messageId)).then(this.messageDAOV3.delete(messageId)).then(this.threadLookupDAO.selectOneRow(messageId).flatMap(key -> this.threadDAO.deleteSome(key.getUsername(), key.getMimeMessageIds()).collectList())).then(this.threadLookupDAO.deleteOneRow(messageId)));
    }

    private Mono<Void> handleMessageDeletionAsPartOfMailboxDeletion(CassandraMessageId messageId, CassandraId excludedId) {
        return Mono.just((Object)messageId).filterWhen(id -> this.isReferenced((CassandraMessageId)id, excludedId)).flatMap(id -> this.readMessage((CassandraMessageId)id).flatMap(message -> this.deleteUnreferencedAttachments((MessageRepresentation)message).thenReturn(message)).flatMap(this::deleteMessageBlobs).flatMap(this::deleteAttachmentMessageIds).then(this.messageDAO.delete(messageId)).then(this.messageDAOV3.delete(messageId)).then(this.threadLookupDAO.selectOneRow(messageId).flatMap(key -> this.threadDAO.deleteSome(key.getUsername(), key.getMimeMessageIds()).collectList())).then(this.threadLookupDAO.deleteOneRow(messageId)));
    }

    private Mono<MessageRepresentation> deleteMessageBlobs(MessageRepresentation message) {
        return Flux.merge((Publisher[])new Publisher[]{this.blobStore.delete(this.blobStore.getDefaultBucketName(), message.getHeaderId()), this.blobStore.delete(this.blobStore.getDefaultBucketName(), message.getBodyId())}).then().thenReturn((Object)message);
    }

    private Mono<MessageRepresentation> readMessage(CassandraMessageId id) {
        return this.messageDAOV3.retrieveMessage(id, MessageMapper.FetchType.METADATA).switchIfEmpty(this.messageDAO.retrieveMessage(id, MessageMapper.FetchType.METADATA));
    }

    private Mono<Void> deleteUnreferencedAttachments(MessageRepresentation message) {
        return Flux.fromIterable(message.getAttachments()).filterWhen(attachment -> this.hasOtherMessagesReferences(message, (MessageAttachmentRepresentation)attachment), 16).concatMap(attachment -> this.attachmentDAO.getAttachment(attachment.getAttachmentId(), (Mono<CassandraMessageId>)Mono.just((Object)((CassandraMessageId)message.getMessageId()))).map(CassandraAttachmentDAOV2.DAOAttachment::getBlobId).flatMap(blobId -> Mono.from((Publisher)this.blobStore.delete(this.blobStore.getDefaultBucketName(), blobId))).then(this.attachmentDAO.delete(attachment.getAttachmentId()))).then();
    }

    private Mono<Void> deleteAttachmentMessageIds(MessageRepresentation message) {
        return Flux.fromIterable(message.getAttachments()).concatMap(attachment -> this.attachmentMessageIdDAO.delete(attachment.getAttachmentId(), message.getMessageId())).then();
    }

    private Mono<Boolean> hasOtherMessagesReferences(MessageRepresentation message, MessageAttachmentRepresentation attachment) {
        return this.attachmentMessageIdDAO.getOwnerMessageIds(attachment.getAttachmentId()).filter(Predicate.not(Predicate.isEqual(message.getMessageId()))).hasElements().map(FunctionalUtils.negate());
    }

    private Mono<Boolean> isReferenced(CassandraMessageId id) {
        return this.imapUidDAO.retrieve(id, ALL_MAILBOXES, this.chooseReadConsistencyUponWrites()).hasElements().map(FunctionalUtils.negate());
    }

    private Mono<Boolean> isReferenced(CassandraMessageId id, CassandraId excludedId) {
        return this.imapUidDAO.retrieve(id, ALL_MAILBOXES, this.chooseReadConsistencyUponWrites()).filter(metadata -> !metadata.getComposedMessageId().getComposedMessageId().getMailboxId().equals(excludedId)).hasElements().map(FunctionalUtils.negate());
    }

    private CassandraConsistenciesConfiguration.ConsistencyChoice chooseReadConsistencyUponWrites() {
        if (this.cassandraConfiguration.isMessageWriteStrongConsistency()) {
            return CassandraConsistenciesConfiguration.ConsistencyChoice.STRONG;
        }
        return CassandraConsistenciesConfiguration.ConsistencyChoice.WEAK;
    }

    public static class DeleteMessageListenerGroup
    extends Group {
    }
}

