/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.util.Host;

public class JmxConfiguration {
    public static final String LOCALHOST = "localhost";
    public static final int DEFAULT_PORT = 9999;
    public static final boolean ENABLED = true;
    public static final JmxConfiguration DEFAULT_CONFIGURATION = new JmxConfiguration(true, Optional.of(Host.from((String)"localhost", (int)9999)));
    public static final JmxConfiguration DISABLED = new JmxConfiguration(false, Optional.empty());
    private final boolean enabled;
    private final Optional<Host> host;

    public static JmxConfiguration fromProperties(Configuration configuration) {
        boolean jmxEnabled = configuration.getBoolean("jmx.enabled", true);
        if (!jmxEnabled) {
            return DISABLED;
        }
        String address = configuration.getString("jmx.address", LOCALHOST);
        int port = configuration.getInt("jmx.port", 9999);
        return new JmxConfiguration(true, Optional.of(Host.from((String)address, (int)port)));
    }

    @VisibleForTesting
    JmxConfiguration(boolean enabled, Optional<Host> host) {
        Preconditions.checkArgument((boolean)this.disabledOrHasHost(enabled, host), (Object)"Specifying a host is compulsory when JMX is enabled");
        this.enabled = enabled;
        this.host = host;
    }

    private boolean disabledOrHasHost(boolean enabled, Optional<Host> host) {
        return !enabled || host.isPresent();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Host getHost() {
        Preconditions.checkState((boolean)this.isEnabled(), (Object)"Trying to access JMX host while JMX is not enabled");
        return this.host.get();
    }

    public final boolean equals(Object o) {
        if (o instanceof JmxConfiguration) {
            JmxConfiguration that = (JmxConfiguration)o;
            return Objects.equals(this.host, that.host) && Objects.equals(this.enabled, that.enabled);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.host, this.enabled);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("host", this.host).toString();
    }
}

