/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class POP3BeforeSMTPHelper {
    public static final Map<String, Instant> ipMap = Collections.synchronizedMap(new HashMap());
    public static final Duration EXPIRE_TIME = Duration.ofHours(60L);

    private POP3BeforeSMTPHelper() {
    }

    public static boolean isAuthorized(String ipAddress) {
        return ipMap.containsKey(ipAddress);
    }

    public static void addIPAddress(String ipAddress) {
        ipMap.put(ipAddress, Instant.now());
    }

    public static void removeExpiredIP() {
        POP3BeforeSMTPHelper.removeExpiredIP(EXPIRE_TIME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeExpiredIP(Duration clearTime) {
        Map<String, Instant> map = ipMap;
        synchronized (map) {
            Iterator<String> storedIP = ipMap.keySet().iterator();
            while (storedIP.hasNext()) {
                String key = storedIP.next();
                Instant storedTime = ipMap.get(key);
                if (!Instant.now().minus(clearTime).isAfter(storedTime)) continue;
                storedIP.remove();
                ipMap.remove(key);
            }
        }
    }

    public static void clearIP() {
        ipMap.clear();
    }
}

