/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.github.fge.lambdas.Throwing;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.util.streams.Iterators;
import org.apache.james.webadmin.service.MailRepositoryStoreService;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReprocessingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReprocessingService.class);
    private final MailQueueFactory<?> mailQueueFactory;
    private final MailRepositoryStoreService mailRepositoryStoreService;

    @Inject
    public ReprocessingService(MailQueueFactory<?> mailQueueFactory, MailRepositoryStoreService mailRepositoryStoreService) {
        this.mailQueueFactory = mailQueueFactory;
        this.mailRepositoryStoreService = mailRepositoryStoreService;
    }

    public void reprocessAll(MailRepositoryPath path, Optional<String> targetProcessor, MailQueueName targetQueue, Consumer<MailKey> keyListener) throws MailRepositoryStore.MailRepositoryStoreException, MessagingException {
        try (Reprocessor reprocessor = new Reprocessor(this.getMailQueue(targetQueue), targetProcessor);){
            this.mailRepositoryStoreService.getRepositories(path).forEach((Consumer<MailRepository>)Throwing.consumer(repository -> Iterators.toStream((Iterator)repository.list()).peek(keyListener).map(Throwing.function(key -> Optional.ofNullable(repository.retrieve(key)))).flatMap(Optional::stream).forEach(mail -> reprocessor.reprocess((MailRepository)repository, (Mail)mail))));
        }
    }

    public void reprocess(MailRepositoryPath path, MailKey key, Optional<String> targetProcessor, MailQueueName targetQueue) throws MailRepositoryStore.MailRepositoryStoreException, MessagingException {
        try (Reprocessor reprocessor = new Reprocessor(this.getMailQueue(targetQueue), targetProcessor);){
            Pair mailPair = this.mailRepositoryStoreService.getRepositories(path).map(Throwing.function(repository -> Pair.of((Object)repository, Optional.ofNullable(repository.retrieve(key))))).filter(pair -> ((Optional)pair.getRight()).isPresent()).map(pair -> Pair.of((Object)((MailRepository)pair.getLeft()), (Object)((Mail)((Optional)pair.getRight()).get()))).findFirst().orElseThrow(() -> new MissingKeyException(key));
            reprocessor.reprocess((MailRepository)mailPair.getKey(), (Mail)mailPair.getValue());
        }
    }

    private MailQueue getMailQueue(MailQueueName targetQueue) {
        return (MailQueue)this.mailQueueFactory.getQueue(targetQueue).orElseThrow(() -> new RuntimeException("Can not find queue " + targetQueue.asString()));
    }

    static class Reprocessor
    implements Closeable {
        private final MailQueue mailQueue;
        private final Optional<String> targetProcessor;

        Reprocessor(MailQueue mailQueue, Optional<String> targetProcessor) {
            this.mailQueue = mailQueue;
            this.targetProcessor = targetProcessor;
        }

        private void reprocess(MailRepository repository, Mail mail) {
            try {
                this.targetProcessor.ifPresent(arg_0 -> ((Mail)mail).setState(arg_0));
                this.mailQueue.enQueue(mail);
                repository.remove(mail);
            }
            catch (Exception e) {
                throw new RuntimeException("Error encountered while reprocessing mail " + mail.getName(), e);
            }
            finally {
                LifecycleUtil.dispose((Object)mail);
            }
        }

        @Override
        public void close() {
            try {
                this.mailQueue.close();
            }
            catch (IOException e) {
                LOGGER.debug("error closing queue", (Throwable)e);
            }
        }
    }

    public static class MissingKeyException
    extends RuntimeException {
        MissingKeyException(MailKey key) {
            super(key.asString() + " can not be found");
        }
    }
}

