/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.consumers.ThrowingConsumer;
import java.util.function.Consumer;
import org.apache.james.backends.rabbitmq.ReceiverProvider;
import org.apache.james.blob.api.ObjectNotFoundException;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.rabbitmq.EnqueueId;
import org.apache.james.queue.rabbitmq.MailLoader;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.MailReferenceDTO;
import org.apache.james.queue.rabbitmq.MailReferenceSerializer;
import org.apache.james.queue.rabbitmq.MailWithEnqueueId;
import org.apache.james.queue.rabbitmq.view.api.DeleteCondition;
import org.apache.james.queue.rabbitmq.view.api.MailQueueView;
import org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueBrowser;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.rabbitmq.AcknowledgableDelivery;
import reactor.rabbitmq.ConsumeOptions;
import reactor.rabbitmq.Receiver;

class Dequeuer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Dequeuer.class);
    private static final boolean REQUEUE = true;
    private final MailLoader mailLoader;
    private final Metric dequeueMetric;
    private final MailReferenceSerializer mailReferenceSerializer;
    private final MailQueueView<CassandraMailQueueBrowser.CassandraMailQueueItemView> mailQueueView;
    private final MailQueueFactory.PrefetchCount prefetchCount;
    private final ReceiverProvider receiverProvider;
    private final MailQueueName name;

    Dequeuer(MailQueueName name, ReceiverProvider receiverProvider, MailLoader mailLoader, MailReferenceSerializer serializer, MetricFactory metricFactory, MailQueueView<CassandraMailQueueBrowser.CassandraMailQueueItemView> mailQueueView, MailQueueFactory.PrefetchCount prefetchCount) {
        this.mailLoader = mailLoader;
        this.mailReferenceSerializer = serializer;
        this.mailQueueView = mailQueueView;
        this.dequeueMetric = metricFactory.generate("dequeuedMail:" + name.asString());
        this.receiverProvider = receiverProvider;
        this.prefetchCount = prefetchCount;
        this.name = name;
    }

    Flux<? extends MailQueue.MailQueueItem> deQueue() {
        return Flux.using(() -> ((ReceiverProvider)this.receiverProvider).createReceiver(), receiver -> receiver.consumeManualAck(this.name.toWorkQueueName().asString(), new ConsumeOptions().qos(this.prefetchCount.asInt())), Receiver::close).filter(getResponse -> getResponse.getBody() != null).flatMapSequential(this::loadItem).concatMap(this::filterIfDeleted);
    }

    private Mono<RabbitMQMailQueueItem> filterIfDeleted(RabbitMQMailQueueItem item) {
        return this.mailQueueView.isPresent(item.getEnqueueId()).handle((isPresent, sink) -> {
            if (isPresent.booleanValue()) {
                sink.next((Object)item);
            } else {
                item.done(true);
                sink.complete();
            }
        });
    }

    private Mono<RabbitMQMailQueueItem> loadItem(AcknowledgableDelivery response) {
        return this.loadMail(response).map(mailWithEnqueueId -> new RabbitMQMailQueueItem((Consumer<Boolean>)this.ack(response, (MailWithEnqueueId)mailWithEnqueueId), (MailWithEnqueueId)mailWithEnqueueId)).onErrorResume(e -> {
            LOGGER.error("Failed to load email, requeue corresponding message", e);
            response.nack(true);
            return Mono.empty();
        });
    }

    private ThrowingConsumer<Boolean> ack(AcknowledgableDelivery response, MailWithEnqueueId mailWithEnqueueId) {
        return success -> {
            if (success.booleanValue()) {
                this.dequeueMetric.increment();
                response.ack();
                this.mailQueueView.delete(DeleteCondition.withEnqueueId(mailWithEnqueueId.getEnqueueId(), mailWithEnqueueId.getBlobIds()));
            } else {
                response.nack(true);
            }
        };
    }

    private Mono<MailWithEnqueueId> loadMail(AcknowledgableDelivery delivery) {
        return this.toMailReference(delivery).flatMap(reference -> this.mailLoader.load((MailReferenceDTO)reference).onErrorResume(ObjectNotFoundException.class, e -> {
            LOGGER.error("Fail to load mail {} with enqueueId {} as underlying blobs do not exist. Discarding this message to prevent an infinite loop.", new Object[]{reference.getName(), reference.getEnqueueId(), e});
            delivery.nack(false);
            return Mono.empty();
        }).onErrorResume(e -> {
            LOGGER.error("Fail to load mail {} with enqueueId {}", new Object[]{reference.getName(), reference.getEnqueueId(), e});
            delivery.nack(true);
            return Mono.empty();
        }));
    }

    private Mono<MailReferenceDTO> toMailReference(AcknowledgableDelivery delivery) {
        return Mono.fromCallable(() -> ((AcknowledgableDelivery)delivery).getBody()).map(Throwing.function(this.mailReferenceSerializer::read).sneakyThrow()).onErrorResume(e -> {
            LOGGER.error("Fail to deserialize MailReferenceDTO. Discarding this message to prevent an infinite loop.", e);
            delivery.nack(false);
            return Mono.empty();
        });
    }

    private static class RabbitMQMailQueueItem
    implements MailQueue.MailQueueItem {
        private final Consumer<Boolean> ack;
        private final EnqueueId enqueueId;
        private final Mail mail;

        private RabbitMQMailQueueItem(Consumer<Boolean> ack, MailWithEnqueueId mailWithEnqueueId) {
            this.ack = ack;
            this.enqueueId = mailWithEnqueueId.getEnqueueId();
            this.mail = mailWithEnqueueId.getMail();
        }

        public Mail getMail() {
            return this.mail;
        }

        public EnqueueId getEnqueueId() {
            return this.enqueueId;
        }

        public void done(boolean success) {
            this.ack.accept(success);
        }
    }
}

