/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.ErrorCode$InvalidArguments$;
import org.apache.james.jmap.core.ErrorCode$UnknownMethod$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.Invocation$;
import org.apache.james.jmap.core.MissingCapabilityException;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.json.VacationSerializer$;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.MethodRequiringAccountId;
import org.apache.james.jmap.method.VacationResponseGetResult;
import org.apache.james.jmap.method.VacationResponseGetResult$;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.jmap.vacation.UnparsedVacationResponseId;
import org.apache.james.jmap.vacation.VacationResponse;
import org.apache.james.jmap.vacation.VacationResponse$;
import org.apache.james.jmap.vacation.VacationResponseGetRequest;
import org.apache.james.jmap.vacation.VacationResponseGetResponse;
import org.apache.james.jmap.vacation.VacationResponseIds;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.vacation.api.AccountId;
import org.apache.james.vacation.api.Vacation;
import org.apache.james.vacation.api.VacationService;
import org.reactivestreams.Publisher;
import play.api.libs.json.JsError;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f\u0001\u0002\t\u0012\u0001qA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tk\u0001\u0011)\u0019!C\u0001m!Aa\b\u0001B\u0001B\u0003%q\u0007\u0003\u0005@\u0001\t\u0015\r\u0011\"\u0001A\u0011!9\u0005A!A!\u0002\u0013\t\u0005\"\u0002%\u0001\t\u0003I\u0005bB,\u0001\u0005\u0004%\t\u0005\u0017\u0005\u0007_\u0002\u0001\u000b\u0011B-\t\u000fA\u0004!\u0019!C!c\"9\u00111\u0001\u0001!\u0002\u0013\u0011\bbBA\u0003\u0001\u0011\u0005\u0013q\u0001\u0005\b\u0003\u007f\u0001A\u0011IA!\u0011\u001d\t9\u0007\u0001C\u0005\u0003SBq!!!\u0001\t\u0013\t\u0019\tC\u0004\u0002\u0018\u0002!I!!'\u00033Y\u000b7-\u0019;j_:\u0014Vm\u001d9p]N,w)\u001a;NKRDw\u000e\u001a\u0006\u0003%M\ta!\\3uQ>$'B\u0001\u000b\u0016\u0003\u0011QW.\u00199\u000b\u0005Y9\u0012!\u00026b[\u0016\u001c(B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001;\r\u0002\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011a!\u00118z%\u00164\u0007c\u0001\u0013&O5\t\u0011#\u0003\u0002'#\tAR*\u001a;i_\u0012\u0014V-];je&tw-Q2d_VtG/\u00133\u0011\u0005!ZS\"A\u0015\u000b\u0005)\u001a\u0012\u0001\u0003<bG\u0006$\u0018n\u001c8\n\u00051J#A\u0007,bG\u0006$\u0018n\u001c8SKN\u0004xN\\:f\u000f\u0016$(+Z9vKN$\u0018a\u0004<bG\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005=\u001aT\"\u0001\u0019\u000b\u0005E\u0012\u0014aA1qS*\u0011!&F\u0005\u0003iA\u0012qBV1dCRLwN\\*feZL7-Z\u0001\u000e[\u0016$(/[2GC\u000e$xN]=\u0016\u0003]\u0002\"\u0001\u000f\u001f\u000e\u0003eR!!\r\u001e\u000b\u0005m*\u0012aB7fiJL7m]\u0005\u0003{e\u0012Q\"T3ue&\u001cg)Y2u_JL\u0018AD7fiJL7MR1di>\u0014\u0018\u0010I\u0001\u0010g\u0016\u001c8/[8o'V\u0004\b\u000f\\5feV\t\u0011\t\u0005\u0002C\u000b6\t1I\u0003\u0002E'\u00051!o\\;uKNL!AR\"\u0003\u001fM+7o]5p]N+\b\u000f\u001d7jKJ\f\u0001c]3tg&|gnU;qa2LWM\u001d\u0011\u0002\rqJg.\u001b;?)\u0011Q5\nT'\u0011\u0005\u0011\u0002\u0001\"B\u0017\u0007\u0001\u0004q\u0003\"B\u001b\u0007\u0001\u00049\u0004\"B \u0007\u0001\u0004\t\u0005F\u0001\u0004P!\t\u0001V+D\u0001R\u0015\t\u00116+\u0001\u0004j]*,7\r\u001e\u0006\u0002)\u0006)!.\u0019<bq&\u0011a+\u0015\u0002\u0007\u0013:TWm\u0019;\u0002\u00155,G\u000f[8e\u001d\u0006lW-F\u0001Z!\tQFN\u0004\u0002\\S:\u0011Al\u001a\b\u0003;\u001at!AX3\u000f\u0005}#gB\u00011d\u001b\u0005\t'B\u00012\u001c\u0003\u0019a$o\\8u}%\t!$\u0003\u0002\u00193%\u0011acF\u0005\u0003)UI!\u0001[\n\u0002\t\r|'/Z\u0005\u0003U.\f!\"\u00138w_\u000e\fG/[8o\u0015\tA7#\u0003\u0002n]\nQQ*\u001a;i_\u0012t\u0015-\\3\u000b\u0005)\\\u0017aC7fi\"|GMT1nK\u0002\nAC]3rk&\u0014X\rZ\"ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001cX#\u0001:\u0011\u0007M<(P\u0004\u0002ukB\u0011\u0001mH\u0005\u0003m~\ta\u0001\u0015:fI\u00164\u0017B\u0001=z\u0005\r\u0019V\r\u001e\u0006\u0003m~\u0001\"a\u001f@\u000f\u0005mc\u0018BA?l\u0003Q\u0019\u0015\r]1cS2LG/_%eK:$\u0018NZ5fe&\u0019q0!\u0001\u0003)\r\u000b\u0007/\u00192jY&$\u00180\u00133f]RLg-[3s\u0015\ti8.A\u000bsKF,\u0018N]3e\u0007\u0006\u0004\u0018MY5mSRLWm\u001d\u0011\u0002\u0013\u0011|\u0007K]8dKN\u001cHCCA\u0005\u0003G\t9#a\u000b\u0002<A1\u00111BA\r\u0003;i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\naV\u0014G.[:iKJT1\u0001IA\n\u0015\rA\u0017Q\u0003\u0006\u0003\u0003/\tqA]3bGR|'/\u0003\u0003\u0002\u001c\u00055!!B*N_:|\u0007c\u0001\u0013\u0002 %\u0019\u0011\u0011E\t\u0003+%sgo\\2bi&|gnV5uQ\u000e{g\u000e^3yi\"1\u0011QE\u0006A\u0002I\fAbY1qC\nLG.\u001b;jKNDq!!\u000b\f\u0001\u0004\ti\"\u0001\u0006j]Z|7-\u0019;j_:Dq!!\f\f\u0001\u0004\ty#\u0001\bnC&d'm\u001c=TKN\u001c\u0018n\u001c8\u0011\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000e\u0016\u0003\u001di\u0017-\u001b7c_bLA!!\u000f\u00024\tqQ*Y5mE>D8+Z:tS>t\u0007BBA\u001f\u0017\u0001\u0007q%A\u0004sKF,Xm\u001d;\u0002\u0015\u001d,GOU3rk\u0016\u001cH\u000f\u0006\u0004\u0002D\u0005m\u0013Q\f\t\b\u0003\u000b\ny%!\u0016(\u001d\u0011\t9%a\u0013\u000f\u0007\u0001\fI%C\u0001!\u0013\r\tieH\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t&a\u0015\u0003\r\u0015KG\u000f[3s\u0015\r\tie\b\t\u0005\u0003\u000b\n9&\u0003\u0003\u0002Z\u0005M#\u0001G%mY\u0016<\u0017\r\\!sOVlWM\u001c;Fq\u000e,\u0007\u000f^5p]\"9\u0011Q\u0006\u0007A\u0002\u0005=\u0002bBA\u0015\u0019\u0001\u0007\u0011q\f\t\u0005\u0003C\n\u0019'D\u0001l\u0013\r\t)g\u001b\u0002\u000b\u0013:4xnY1uS>t\u0017!\b5b]\u0012dWMU3rk\u0016\u001cHOV1mS\u0012\fG/[8o\u000bJ\u0014xN]:\u0015\r\u0005-\u0014QNA<!\u0019\tY!!\u0007\u0002`!9\u0011qN\u0007A\u0002\u0005E\u0014!C3yG\u0016\u0004H/[8o!\u0011\t)%a\u001d\n\t\u0005U\u00141\u000b\u0002\n\u000bb\u001cW\r\u001d;j_:Dq!!\u001f\u000e\u0001\u0004\tY(\u0001\u0007nKRDw\u000eZ\"bY2LE\rE\u0002[\u0003{J1!a o\u00051iU\r\u001e5pI\u000e\u000bG\u000e\\%e\u0003M9W\r\u001e,bG\u0006$\u0018n\u001c8SKN\u0004xN\\:f)\u0019\t))!%\u0002\u0016B1\u00111BAD\u0003\u0017KA!!#\u0002\u000e\t)1K\u00127vqB\u0019A%!$\n\u0007\u0005=\u0015CA\rWC\u000e\fG/[8o%\u0016\u001c\bo\u001c8tK\u001e+GOU3tk2$\bBBAJ\u001d\u0001\u0007q%\u0001\u000ewC\u000e\fG/[8o%\u0016\u001c\bo\u001c8tK\u001e+GOU3rk\u0016\u001cH\u000fC\u0004\u0002.9\u0001\r!a\f\u0002)\u001d,GOV1dCRLwN\\*j]\u001edW\r^8o)\u0011\tY*a)\u0011\r\u0005-\u0011\u0011DAO!\rA\u0013qT\u0005\u0004\u0003CK#\u0001\u0005,bG\u0006$\u0018n\u001c8SKN\u0004xN\\:f\u0011\u001d\tic\u0004a\u0001\u0003_\u0001")
public class VacationResponseGetMethod
implements MethodRequiringAccountId<VacationResponseGetRequest> {
    private final VacationService vacationService;
    private final MetricFactory metricFactory;
    private final SessionSupplier sessionSupplier;
    private final Invocation.MethodName methodName;
    private final Set<Refined<String, string.Uri>> requiredCapabilities;
    private String JMAP_RFC8621_PREFIX;

    @Override
    public Publisher<InvocationWithContext> process(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return MethodRequiringAccountId.process$(this, capabilities, invocation, mailboxSession);
    }

    @Override
    public String JMAP_RFC8621_PREFIX() {
        return this.JMAP_RFC8621_PREFIX;
    }

    @Override
    public void org$apache$james$jmap$method$Method$_setter_$JMAP_RFC8621_PREFIX_$eq(String x$1) {
        this.JMAP_RFC8621_PREFIX = x$1;
    }

    @Override
    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    @Override
    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    @Override
    public Invocation.MethodName methodName() {
        return this.methodName;
    }

    @Override
    public Set<Refined<String, string.Uri>> requiredCapabilities() {
        return this.requiredCapabilities;
    }

    public SMono<InvocationWithContext> doProcess(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession, VacationResponseGetRequest request) {
        SMono sMono;
        Properties requestedProperties = (Properties)request.properties().getOrElse((Function0 & Serializable)() -> VacationResponse$.MODULE$.allProperties());
        Properties properties = requestedProperties.$minus$minus(VacationResponse$.MODULE$.allProperties());
        if (properties.isEmpty()) {
            sMono = this.getVacationResponse(request, mailboxSession).reduce((Object)VacationResponseGetResult$.MODULE$.empty(), (Function2 & Serializable)(result1, result2) -> VacationResponseGetResult$.MODULE$.merge((VacationResponseGetResult)result1, (VacationResponseGetResult)result2)).map((Function1 & Serializable)vacationResult -> vacationResult.asResponse(request.accountId())).map((Function1 & Serializable)vacationResponseGetResponse -> new Invocation(this.methodName(), (JsObject)VacationSerializer$.MODULE$.serialize((VacationResponseGetResponse)vacationResponseGetResponse, requestedProperties).as((Reads)Reads$.MODULE$.JsObjectReads()), invocation.invocation().methodCallId()));
        } else if (properties != null) {
            Properties properties2 = properties;
            sMono = SMono$.MODULE$.just((Object)Invocation$.MODULE$.error(ErrorCode$InvalidArguments$.MODULE$, new StringBuilder(41).append("The following properties [").append(properties2.format()).append("] do not exist.").toString(), invocation.invocation().methodCallId()));
        } else {
            throw new MatchError((Object)properties);
        }
        return sMono.map((Function1 & Serializable)x$1 -> new InvocationWithContext((Invocation)x$1, invocation.processingContext())).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (!(throwable instanceof Exception)) {
                throw new MatchError((Object)throwable);
            }
            Exception exception = (Exception)throwable;
            SMono sMono = this.handleRequestValidationErrors(exception, invocation.invocation().methodCallId()).map((Function1 & Serializable)errorInvocation -> new InvocationWithContext((Invocation)errorInvocation, invocation.processingContext()));
            return sMono;
        });
    }

    @Override
    public Either<IllegalArgumentException, VacationResponseGetRequest> getRequest(MailboxSession mailboxSession, Invocation invocation) {
        Right right;
        JsResult<VacationResponseGetRequest> jsResult = VacationSerializer$.MODULE$.deserializeVacationResponseGetRequest((JsValue)invocation.arguments());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            VacationResponseGetRequest vacationResponseGetRequest = (VacationResponseGetRequest)jsSuccess.value();
            right = package$.MODULE$.Right().apply((Object)vacationResponseGetRequest);
        } else if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            right = package$.MODULE$.Left().apply((Object)new IllegalArgumentException(ResponseSerializer$.MODULE$.serialize(jsError).toString()));
        } else {
            throw new MatchError(jsResult);
        }
        return right;
    }

    private SMono<Invocation> handleRequestValidationErrors(Exception exception, Invocation.MethodCallId methodCallId) {
        SMono sMono;
        Exception exception2 = exception;
        if (exception2 instanceof MissingCapabilityException) {
            sMono = SMono$.MODULE$.just((Object)Invocation$.MODULE$.error(ErrorCode$UnknownMethod$.MODULE$, methodCallId));
        } else if (exception2 instanceof IllegalArgumentException) {
            IllegalArgumentException illegalArgumentException = (IllegalArgumentException)exception2;
            sMono = SMono$.MODULE$.just((Object)Invocation$.MODULE$.error(ErrorCode$InvalidArguments$.MODULE$, illegalArgumentException.getMessage(), methodCallId));
        } else {
            throw new MatchError((Object)exception2);
        }
        return sMono;
    }

    private SFlux<VacationResponseGetResult> getVacationResponse(VacationResponseGetRequest vacationResponseGetRequest, MailboxSession mailboxSession) {
        SFlux sFlux;
        Option<VacationResponseIds> option = vacationResponseGetRequest.ids();
        if (None$.MODULE$.equals(option)) {
            sFlux = this.getVacationSingleton(mailboxSession).map((Function1 & Serializable)vacationResponse -> VacationResponseGetResult$.MODULE$.found((VacationResponse)vacationResponse)).flux();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            VacationResponseIds ids = (VacationResponseIds)some.value();
            SFlux qual$1 = SFlux$.MODULE$.fromIterable(ids.value());
            Function1 & Serializable x$1 = (Function1 & Serializable)id -> {
                UnparsedVacationResponseId unparsedVacationResponseId = id;
                UnparsedVacationResponseId unparsedVacationResponseId2 = VacationResponse$.MODULE$.UNPARSED_SINGLETON();
                UnparsedVacationResponseId unparsedVacationResponseId3 = unparsedVacationResponseId;
                SMono sMono = !(unparsedVacationResponseId2 != null ? !((Object)unparsedVacationResponseId2).equals(unparsedVacationResponseId3) : unparsedVacationResponseId3 != null) ? this.getVacationSingleton(mailboxSession).map((Function1 & Serializable)vacationResponse -> VacationResponseGetResult$.MODULE$.found((VacationResponse)vacationResponse)) : SMono$.MODULE$.just((Object)VacationResponseGetResult$.MODULE$.notFound((UnparsedVacationResponseId)id));
                return sMono;
            };
            int x$2 = qual$1.flatMap$default$2();
            int x$3 = qual$1.flatMap$default$3();
            boolean x$4 = qual$1.flatMap$default$4();
            sFlux = qual$1.flatMap((Function1)x$1, x$2, x$3, x$4);
        } else {
            throw new MatchError(option);
        }
        return sFlux;
    }

    private SMono<VacationResponse> getVacationSingleton(MailboxSession mailboxSession) {
        AccountId accountId = AccountId.fromUsername((Username)mailboxSession.getUser());
        return SMono$.MODULE$.fromPublisher((Publisher)this.vacationService.retrieveVacation(accountId)).map((Function1 & Serializable)vacation -> VacationResponse$.MODULE$.asRfc8621((Vacation)vacation));
    }

    @Inject
    public VacationResponseGetMethod(VacationService vacationService, MetricFactory metricFactory, SessionSupplier sessionSupplier) {
        this.vacationService = vacationService;
        this.metricFactory = metricFactory;
        this.sessionSupplier = sessionSupplier;
        Method.$init$(this);
        MethodRequiringAccountId.$init$(this);
        this.methodName = new Invocation.MethodName((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"VacationResponse/get")).value());
        this.requiredCapabilities = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_CORE()), new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_VACATION_RESPONSE())}));
        Statics.releaseFence();
    }
}

