/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.NumericUtils;

final class LatLonPointInPolygonQuery
extends Query {
    final String field;
    final Polygon[] polygons;

    LatLonPointInPolygonQuery(String field, Polygon[] polygons) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (polygons == null) {
            throw new IllegalArgumentException("polygons must not be null");
        }
        if (polygons.length == 0) {
            throw new IllegalArgumentException("polygons must not be empty");
        }
        for (int i = 0; i < polygons.length; ++i) {
            if (polygons[i] != null) continue;
            throw new IllegalArgumentException("polygon[" + i + "] must not be null");
        }
        this.field = field;
        this.polygons = (Polygon[])polygons.clone();
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    private PointValues.IntersectVisitor getIntersectVisitor(final DocIdSetBuilder result, final Component2D tree, final GeoEncodingUtils.PolygonPredicate polygonPredicate, final byte[] minLat, final byte[] maxLat, final byte[] minLon, final byte[] maxLon) {
        return new PointValues.IntersectVisitor(){
            DocIdSetBuilder.BulkAdder adder;

            @Override
            public void grow(int count) {
                this.adder = result.grow(count);
            }

            @Override
            public void visit(int docID) {
                this.adder.add(docID);
            }

            @Override
            public void visit(int docID, byte[] packedValue) {
                if (polygonPredicate.test(NumericUtils.sortableBytesToInt(packedValue, 0), NumericUtils.sortableBytesToInt(packedValue, 4))) {
                    this.visit(docID);
                }
            }

            @Override
            public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
                if (polygonPredicate.test(NumericUtils.sortableBytesToInt(packedValue, 0), NumericUtils.sortableBytesToInt(packedValue, 4))) {
                    int docID;
                    while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                        this.visit(docID);
                    }
                }
            }

            @Override
            public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                if (Arrays.compareUnsigned(minPackedValue, 0, 4, maxLat, 0, 4) > 0 || Arrays.compareUnsigned(maxPackedValue, 0, 4, minLat, 0, 4) < 0 || Arrays.compareUnsigned(minPackedValue, 4, 8, maxLon, 0, 4) > 0 || Arrays.compareUnsigned(maxPackedValue, 4, 8, minLon, 0, 4) < 0) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                double cellMinLat = GeoEncodingUtils.decodeLatitude(minPackedValue, 0);
                double cellMinLon = GeoEncodingUtils.decodeLongitude(minPackedValue, 4);
                double cellMaxLat = GeoEncodingUtils.decodeLatitude(maxPackedValue, 0);
                double cellMaxLon = GeoEncodingUtils.decodeLongitude(maxPackedValue, 4);
                return tree.relate(cellMinLon, cellMaxLon, cellMinLat, cellMaxLat);
            }
        };
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final Component2D tree = LatLonGeometry.create(this.polygons);
        final GeoEncodingUtils.PolygonPredicate polygonPredicate = GeoEncodingUtils.createComponentPredicate(tree);
        final byte[] minLat = new byte[4];
        final byte[] maxLat = new byte[4];
        final byte[] minLon = new byte[4];
        final byte[] maxLon = new byte[4];
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLatitude(tree.getMinY()), minLat, 0);
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLatitude(tree.getMaxY()), maxLat, 0);
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLongitude(tree.getMinX()), minLon, 0);
        NumericUtils.intToSortableBytes(GeoEncodingUtils.encodeLongitude(tree.getMaxX()), maxLon, 0);
        return new ConstantScoreWeight(this, boost){

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final LeafReader reader = context.reader();
                final PointValues values = reader.getPointValues(LatLonPointInPolygonQuery.this.field);
                if (values == null) {
                    return null;
                }
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(LatLonPointInPolygonQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                LatLonPoint.checkCompatible(fieldInfo);
                final 2 weight = this;
                return new ScorerSupplier(){
                    long cost = -1L;
                    DocIdSetBuilder result;
                    final PointValues.IntersectVisitor visitor;
                    {
                        this.result = new DocIdSetBuilder(reader.maxDoc(), values, LatLonPointInPolygonQuery.this.field);
                        this.visitor = LatLonPointInPolygonQuery.this.getIntersectVisitor(this.result, tree, polygonPredicate, minLat, maxLat, minLon, maxLon);
                    }

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        values.intersect(this.visitor);
                        return new ConstantScoreScorer(weight, this.score(), scoreMode, this.result.build().iterator());
                    }

                    @Override
                    public long cost() {
                        if (this.cost == -1L) {
                            this.cost = values.estimateDocCount(this.visitor);
                            assert (this.cost >= 0L);
                        }
                        return this.cost;
                    }
                };
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public Polygon[] getPolygons() {
        return (Polygon[])this.polygons.clone();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Arrays.hashCode(this.polygons);
        return result;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((LatLonPointInPolygonQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(LatLonPointInPolygonQuery other) {
        return this.field.equals(other.field) && Arrays.equals(this.polygons, other.polygons);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(Arrays.toString(this.polygons));
        return sb.toString();
    }
}

