/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.time.Clock;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.events.Group;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.james.webadmin.service.EventDeadLettersRedeliverService;
import org.apache.james.webadmin.service.EventDeadLettersRedeliveryTaskAdditionalInformation;
import org.apache.james.webadmin.service.EventDeadLettersRedeliveryTaskAdditionalInformationDTO;
import org.apache.james.webadmin.service.EventRetriever;

public class EventDeadLettersRedeliverGroupTask
implements Task {
    public static final TaskType TYPE = TaskType.of((String)"event-dead-letters-redeliver-group");
    private final EventDeadLettersRedeliverService service;
    private final EventRetriever eventRetriever;
    private final AtomicLong successfulRedeliveriesCount;
    private final AtomicLong failedRedeliveriesCount;
    private final Group group;

    EventDeadLettersRedeliverGroupTask(EventDeadLettersRedeliverService service, Group group) {
        this.service = service;
        this.group = group;
        this.eventRetriever = EventRetriever.groupEvents(group);
        this.successfulRedeliveriesCount = new AtomicLong(0L);
        this.failedRedeliveriesCount = new AtomicLong(0L);
    }

    public Task.Result run() {
        return (Task.Result)this.service.redeliverEvents(this.eventRetriever).map(this::updateCounters).reduce((Object)Task.Result.COMPLETED, Task::combine).block();
    }

    private Task.Result updateCounters(Task.Result result) {
        switch (result) {
            case COMPLETED: {
                this.successfulRedeliveriesCount.incrementAndGet();
                break;
            }
            case PARTIAL: {
                this.failedRedeliveriesCount.incrementAndGet();
                break;
            }
            default: {
                throw new RuntimeException("Result case: " + result.toString() + " not recognized");
            }
        }
        return result;
    }

    public TaskType type() {
        return TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(this.createAdditionalInformation());
    }

    public Group getGroup() {
        return this.group;
    }

    private EventDeadLettersRedeliveryTaskAdditionalInformation createAdditionalInformation() {
        return new EventDeadLettersRedeliveryTaskAdditionalInformationDTO.EventDeadLettersRedeliveryTaskAdditionalInformationForGroup(this.successfulRedeliveriesCount.get(), this.failedRedeliveriesCount.get(), this.eventRetriever.forGroup(), Clock.systemUTC().instant());
    }
}

