/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.github.fge.lambdas.Throwing;
import com.google.inject.Inject;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.Startables;

public class InitializationOperations {
    private final Set<InitializationOperation> initializationOperations;
    private final Startables configurables;

    @Inject
    public InitializationOperations(Set<InitializationOperation> initializationOperations, Startables configurables) {
        this.initializationOperations = initializationOperations;
        this.configurables = configurables;
    }

    public void initModules() {
        Set<InitializationOperation> processed = this.processConfigurables();
        this.processOthers(processed);
    }

    private Set<InitializationOperation> processConfigurables() {
        return this.configurables.get().stream().flatMap(this::configurationPerformerFor).distinct().peek(Throwing.consumer(InitializationOperation::initModule).sneakyThrow()).collect(Collectors.toSet());
    }

    private Stream<InitializationOperation> configurationPerformerFor(Class<? extends Startable> configurable) {
        return this.initializationOperations.stream().filter(x -> x.forClass().equals(configurable));
    }

    private void processOthers(Set<InitializationOperation> processed) {
        this.initializationOperations.stream().filter(x -> !processed.contains(x)).forEach(Throwing.consumer(InitializationOperation::initModule).sneakyThrow());
    }
}

