/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.apache.james.json.DTOModule;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.webadmin.service.ReprocessingAllMailsTask;
import org.apache.james.webadmin.service.ReprocessingService;

public class ReprocessingAllMailsTaskDTO
implements TaskDTO {
    private final String type;
    private final long repositorySize;
    private final String repositoryPath;
    private final String targetQueue;
    private final Optional<String> targetProcessor;

    public static TaskDTOModule<ReprocessingAllMailsTask, ReprocessingAllMailsTaskDTO> module(ReprocessingService reprocessingService) {
        return (TaskDTOModule)DTOModule.forDomainObject(ReprocessingAllMailsTask.class).convertToDTO(ReprocessingAllMailsTaskDTO.class).toDomainObjectConverter(dto -> dto.fromDTO(reprocessingService)).toDTOConverter(ReprocessingAllMailsTaskDTO::toDTO).typeName(ReprocessingAllMailsTask.TYPE.asString()).withFactory(TaskDTOModule::new);
    }

    private static ReprocessingAllMailsTaskDTO toDTO(ReprocessingAllMailsTask domainObject, String typeName) {
        try {
            return new ReprocessingAllMailsTaskDTO(typeName, domainObject.getRepositorySize(), domainObject.getRepositoryPath().urlEncoded(), domainObject.getTargetQueue().asString(), domainObject.getTargetProcessor());
        }
        catch (Exception e) {
            throw new ReprocessingAllMailsTask.UrlEncodingFailureSerializationException(domainObject.getRepositoryPath());
        }
    }

    public ReprocessingAllMailsTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="repositorySize") long repositorySize, @JsonProperty(value="repositoryPath") String repositoryPath, @JsonProperty(value="targetQueue") String targetQueue, @JsonProperty(value="targetProcessor") Optional<String> targetProcessor) {
        this.type = type;
        this.repositorySize = repositorySize;
        this.repositoryPath = repositoryPath;
        this.targetQueue = targetQueue;
        this.targetProcessor = targetProcessor;
    }

    private ReprocessingAllMailsTask fromDTO(ReprocessingService reprocessingService) {
        try {
            return new ReprocessingAllMailsTask(reprocessingService, this.repositorySize, MailRepositoryPath.fromEncoded((String)this.repositoryPath), MailQueueName.of((String)this.targetQueue), this.targetProcessor);
        }
        catch (Exception e) {
            throw new ReprocessingAllMailsTask.InvalidMailRepositoryPathDeserializationException(this.repositoryPath);
        }
    }

    public String getType() {
        return this.type;
    }

    public long getRepositorySize() {
        return this.repositorySize;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public String getTargetQueue() {
        return this.targetQueue;
    }

    public Optional<String> getTargetProcessor() {
        return this.targetProcessor;
    }
}

