/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import eu.timepit.refined.api.Refined;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.fileupload.util.LimitedInputStream;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.api.model.UploadId;
import org.apache.james.jmap.api.model.UploadMetaData;
import org.apache.james.jmap.api.upload.UploadRepository;
import org.apache.james.jmap.core.AccountId;
import org.apache.james.jmap.core.AccountId$;
import org.apache.james.jmap.core.Id;
import org.apache.james.jmap.core.Id$;
import org.apache.james.jmap.core.JmapRfc8621Configuration;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.json.UploadSerializer;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.routes.ForbiddenException;
import org.apache.james.jmap.routes.TooBigUploadException;
import org.apache.james.jmap.routes.UploadResponse;
import org.apache.james.jmap.routes.UploadRoutes$;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t5u!\u0002\u0011\"\u0011\u0003ac!\u0002\u0018\"\u0011\u0003y\u0003\"\u0002\u001c\u0002\t\u00039\u0004b\u0002\u001d\u0002\u0005\u0004%\t!\u000f\u0005\u0007\u0001\u0006\u0001\u000b\u0011\u0002\u001e\u0007\t9\n\u0003!\u0011\u0005\t\u001d\u0016\u0011)\u0019!C\u0001\u001f\"Aa+\u0002B\u0001B\u0003%\u0001\u000b\u0003\u0005X\u000b\t\u0015\r\u0011\"\u0001Y\u0011!yVA!A!\u0002\u0013I\u0006\u0002\u00031\u0006\u0005\u000b\u0007I\u0011A1\t\u0011),!\u0011!Q\u0001\n\tD\u0001b[\u0003\u0003\u0006\u0004%\t\u0001\u001c\u0005\tg\u0016\u0011\t\u0011)A\u0005[\")a'\u0002C\u0001i\u001a1\u0011QC\u0003\u0001\u0003/AaAN\b\u0005\u0002\u0005EbABA\u001c\u000b\u0001\tI\u0004\u0003\u00047#\u0011\u0005\u00111\b\u0005\n\u0003\u007f)!\u0019!C\u0005\u0003\u0003B\u0001\"a\u0015\u0006A\u0003%\u00111\t\u0005\n\u0003+*!\u0019!C\u0005\u0003\u0003B\u0001\"a\u0016\u0006A\u0003%\u00111\t\u0005\u0007E\u0015!\t%!\u0017\t\u000f\u0005ET\u0001\"\u0001\u0002t!9\u0011\u0011O\u0003\u0005\u0002\u00055\u0006bBAp\u000b\u0011\u0005\u0011\u0011\u001d\u0005\b\u0005\u000b)A\u0011\u0001B\u0004\u0011\u001d\u0011Y\"\u0002C\u0005\u0005;AqAa\f\u0006\t\u0013\u0011\t\u0004C\u0004\u0003J\u0015!IAa\u0013\t\u0013\tUT!%A\u0005\n\t]\u0014\u0001D+qY>\fGMU8vi\u0016\u001c(B\u0001\u0012$\u0003\u0019\u0011x.\u001e;fg*\u0011A%J\u0001\u0005U6\f\u0007O\u0003\u0002'O\u0005)!.Y7fg*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0007\u0001\u0001\"!L\u0001\u000e\u0003\u0005\u0012A\"\u00169m_\u0006$'k\\;uKN\u001c\"!\u0001\u0019\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tA&\u0001\u0004M\u001f\u001e;UIU\u000b\u0002uA\u00111HP\u0007\u0002y)\u0011Q(K\u0001\u0006g24GG[\u0005\u0003\u007fq\u0012a\u0001T8hO\u0016\u0014\u0018a\u0002'P\u000f\u001e+%\u000bI\n\u0004\u000b\tS\u0005CA\"I\u001b\u0005!%BA#G\u0003\u0011a\u0017M\\4\u000b\u0003\u001d\u000bAA[1wC&\u0011\u0011\n\u0012\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005-cU\"A\u0012\n\u00055\u001b#A\u0003&N\u0003B\u0013v.\u001e;fg\u0006i\u0011-\u001e;iK:$\u0018nY1u_J,\u0012\u0001\u0015\t\u0003#Rk\u0011A\u0015\u0006\u0003'\u000e\nA\u0001\u001b;ua&\u0011QK\u0015\u0002\u000e\u0003V$\b.\u001a8uS\u000e\fGo\u001c:\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^8sA\u0005i1m\u001c8gS\u001e,(/\u0019;j_:,\u0012!\u0017\t\u00035vk\u0011a\u0017\u0006\u00039\u000e\nAaY8sK&\u0011al\u0017\u0002\u0019\u00156\f\u0007O\u00154dqY\u0012\u0014gQ8oM&<WO]1uS>t\u0017AD2p]\u001aLw-\u001e:bi&|g\u000eI\u0001\u0011kBdw.\u00193SKB|7/\u001b;pef,\u0012A\u0019\t\u0003G\"l\u0011\u0001\u001a\u0006\u0003K\u001a\fa!\u001e9m_\u0006$'BA4$\u0003\r\t\u0007/[\u0005\u0003S\u0012\u0014\u0001#\u00169m_\u0006$'+\u001a9pg&$xN]=\u0002#U\u0004Hn\\1e%\u0016\u0004xn]5u_JL\b%\u0001\u0006tKJL\u0017\r\\5{KJ,\u0012!\u001c\t\u0003]Fl\u0011a\u001c\u0006\u0003a\u000e\nAA[:p]&\u0011!o\u001c\u0002\u0011+Bdw.\u00193TKJL\u0017\r\\5{KJ\f1b]3sS\u0006d\u0017N_3sAQAQO^A\u0004\u0003\u0013\tY\u0001\u0005\u0002.\u000b!)aJ\u0004a\u0001!\"2a\u000f_A\u0001\u0003\u0007\u0001\"!\u001f@\u000e\u0003iT!a\u001f?\u0002\r%t'.Z2u\u0015\u0005i\u0018!\u00026bm\u0006D\u0018BA@{\u0005\u0015q\u0015-\\3e\u0003\u00151\u0018\r\\;fC\t\t)!\u0001\u0005S\r\u000ek\u0003H\u000e\u001a2\u0011\u00159f\u00021\u0001Z\u0011\u0015\u0001g\u00021\u0001c\u0011\u0015Yg\u00021\u0001nQ\rq\u0011q\u0002\t\u0004s\u0006E\u0011bAA\nu\n1\u0011J\u001c6fGR\u0014\u0001dQ1oG\u0016dG.\u001a3Va2|\u0017\rZ#yG\u0016\u0004H/[8o'\ry\u0011\u0011\u0004\t\u0005\u00037\tYC\u0004\u0003\u0002\u001e\u0005\u001db\u0002BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\r2&\u0001\u0004=e>|GOP\u0005\u0002g%\u0019\u0011\u0011\u0006\u001a\u0002\u000fA\f7m[1hK&!\u0011QFA\u0018\u0005A\u0011VO\u001c;j[\u0016,\u0005pY3qi&|gNC\u0002\u0002*I\"\"!a\r\u0011\u0007\u0005Ur\"D\u0001\u0006\u0005ii\u0015\r\u001f$jY\u0016\u001c\u0016N_3Va2|\u0017\rZ#yG\u0016\u0004H/[8o'\r\t\u0012\u0011\u0004\u000b\u0003\u0003{\u00012!!\u000e\u0012\u00039\t7mY8v]RLE\rU1sC6,\"!a\u0011\u0011\t\u0005\u0015\u0013Q\n\b\u0005\u0003\u000f\nI\u0005E\u0002\u0002 IJ1!a\u00133\u0003\u0019\u0001&/\u001a3fM&!\u0011qJA)\u0005\u0019\u0019FO]5oO*\u0019\u00111\n\u001a\u0002\u001f\u0005\u001c7m\\;oi&#\u0007+\u0019:b[\u0002\n\u0011\"\u001e9m_\u0006$WKU%\u0002\u0015U\u0004Hn\\1e+JK\u0005\u0005\u0006\u0002\u0002\\A1\u0011QLA4\u0003Wj!!a\u0018\u000b\t\u0005\u0005\u00141M\u0001\u0007gR\u0014X-Y7\u000b\u0007\u0005\u0015d)\u0001\u0003vi&d\u0017\u0002BA5\u0003?\u0012aa\u0015;sK\u0006l\u0007cA&\u0002n%\u0019\u0011qN\u0012\u0003\u0013)k\u0015\t\u0015*pkR,\u0017\u0001\u00029pgR$b!!\u001e\u0002\u000e\u0006\r\u0006CBA<\u0003\u0007\u000b9)\u0004\u0002\u0002z)!\u00111PA?\u0003%\u0001XO\u00197jg\",'OC\u0002]\u0003\u007fR!!!!\u0002\u000fI,\u0017m\u0019;pe&!\u0011QQA=\u0005\u0011iuN\\8\u0011\u0007\r\u000bI)C\u0002\u0002\f\u0012\u0013AAV8jI\"9\u0011q\u0012\rA\u0002\u0005E\u0015a\u0002:fcV,7\u000f\u001e\t\u0005\u0003'\u000by*\u0004\u0002\u0002\u0016*!\u0011qSAM\u0003\u0019\u0019XM\u001d<fe*\u00191+a'\u000b\t\u0005u\u0015qP\u0001\u0006]\u0016$H/_\u0005\u0005\u0003C\u000b)JA\tIiR\u00048+\u001a:wKJ\u0014V-];fgRDq!!*\u0019\u0001\u0004\t9+\u0001\u0005sKN\u0004xN\\:f!\u0011\t\u0019*!+\n\t\u0005-\u0016Q\u0013\u0002\u0013\u0011R$\boU3sm\u0016\u0014(+Z:q_:\u001cX\r\u0006\u0006\u00020\u0006m\u0016QXA`\u0003'\u0004b!!-\u00028\u0006\u001dUBAAZ\u0015\u0011\tY(!.\u000b\u0007M\ni(\u0003\u0003\u0002:\u0006M&!B*N_:|\u0007bBAH3\u0001\u0007\u0011\u0011\u0013\u0005\b\u0003KK\u0002\u0019AAT\u0011\u001d\t\t-\u0007a\u0001\u0003\u0007\f1bY8oi\u0016tG\u000fV=qKB!\u0011QYAh\u001b\t\t9M\u0003\u0003\u0002J\u0006-\u0017!B7pI\u0016d'bAAgK\u00059Q.Y5mE>D\u0018\u0002BAi\u0003\u000f\u00141bQ8oi\u0016tG\u000fV=qK\"9\u0011Q[\rA\u0002\u0005]\u0017aB:fgNLwN\u001c\t\u0005\u00033\fY.\u0004\u0002\u0002L&!\u0011Q\\Af\u00059i\u0015-\u001b7c_b\u001cVm]:j_:\fa\u0001[1oI2,G\u0003DAX\u0003G\fi/a<\u0002\u0000\n\r\u0001bBAs5\u0001\u0007\u0011q]\u0001\nC\u000e\u001cw.\u001e8u\u0013\u0012\u00042AWAu\u0013\r\tYo\u0017\u0002\n\u0003\u000e\u001cw.\u001e8u\u0013\u0012Dq!!1\u001b\u0001\u0004\t\u0019\rC\u0004\u0002rj\u0001\r!a=\u0002\u000f\r|g\u000e^3oiB!\u0011Q_A~\u001b\t\t9PC\u0002\u0002z\u001a\u000b!![8\n\t\u0005u\u0018q\u001f\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0004\u0003\u0002i\u0001\r!a6\u0002\u001d5\f\u0017\u000e\u001c2pqN+7o]5p]\"9\u0011Q\u0015\u000eA\u0002\u0005\u001d\u0016!D;qY>\fGmQ8oi\u0016tG\u000f\u0006\u0006\u0003\n\tE!1\u0003B\u000b\u00053\u0001b!!-\u00028\n-\u0001cA\u0017\u0003\u000e%\u0019!qB\u0011\u0003\u001dU\u0003Hn\\1e%\u0016\u001c\bo\u001c8tK\"9\u0011Q]\u000eA\u0002\u0005\u001d\bbBAa7\u0001\u0007\u00111\u0019\u0005\b\u0005/Y\u0002\u0019AAz\u0003-Ig\u000e];u'R\u0014X-Y7\t\u000f\u0005U7\u00041\u0001\u0002X\u0006qaM]8n\u0003R$\u0018m\u00195nK:$HC\u0002B\u0006\u0005?\u0011i\u0003C\u0004\u0003\"q\u0001\rAa\t\u0002\u001dU\u0004Hn\\1e\u001b\u0016$\u0018\rR1uCB!!Q\u0005B\u0015\u001b\t\u00119CC\u0002\u0002J\u001aLAAa\u000b\u0003(\tqQ\u000b\u001d7pC\u0012lU\r^1ECR\f\u0007bBAs9\u0001\u0007\u0011q]\u0001\tCN\u0014En\u001c2JIR!!1\u0007B !\u0011\u0011)Da\u000f\u000e\u0005\t]\"b\u0001B\u001dG\u0005!Q.Y5m\u0013\u0011\u0011iDa\u000e\u0003\r\tcwNY%e\u0011\u001d\u0011\t%\ba\u0001\u0005\u0007\n\u0001\"\u001e9m_\u0006$\u0017\n\u001a\t\u0005\u0005K\u0011)%\u0003\u0003\u0003H\t\u001d\"\u0001C+qY>\fG-\u00133\u0002\u001dI,7\u000f]8oI\u0012+G/Y5mgRA\u0011q\u0016B'\u0005#\u0012Y\u0006C\u0004\u0003Py\u0001\r!a*\u0002%!$H\u000f]*feZ,'OU3ta>t7/\u001a\u0005\b\u0005'r\u0002\u0019\u0001B+\u0003\u001d!W\r^1jYN\u00042A\u0017B,\u0013\r\u0011If\u0017\u0002\u000f!J|'\r\\3n\t\u0016$\u0018-\u001b7t\u0011%\u0011iF\bI\u0001\u0002\u0004\u0011y&\u0001\u0006ti\u0006$Xo]\"pI\u0016\u0004BA!\u0019\u0003r5\u0011!1\r\u0006\u0004'\n\u0015$\u0002\u0002B4\u0005S\nQaY8eK\u000eTAAa\u001b\u0003n\u00059\u0001.\u00198eY\u0016\u0014(\u0002BAO\u0005_R!!!?\n\t\tM$1\r\u0002\u0013\u0011R$\bOU3ta>t7/Z*uCR,8/\u0001\rsKN\u0004xN\u001c3EKR\f\u0017\u000e\\:%I\u00164\u0017-\u001e7uIM*\"A!\u001f+\t\t}#1P\u0016\u0003\u0005{\u0002BAa \u0003\n6\u0011!\u0011\u0011\u0006\u0005\u0005\u0007\u0013))A\u0005v]\u000eDWmY6fI*\u0019!q\u0011\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\f\n\u0005%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class UploadRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final JmapRfc8621Configuration configuration;
    private final UploadRepository uploadRepository;
    private final UploadSerializer serializer;
    private final String accountIdParam;
    private final String uploadURI;

    public static Logger LOGGER() {
        return UploadRoutes$.MODULE$.LOGGER();
    }

    public Mono<Void> handleInternalError(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleInternalError(x$1, x$2, x$3);
    }

    public Mono<Void> handleBadRequest(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleBadRequest(x$1, x$2, x$3);
    }

    public Mono<Void> handleAuthenticationFailure(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleAuthenticationFailure(x$1, x$2, x$3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public JmapRfc8621Configuration configuration() {
        return this.configuration;
    }

    public UploadRepository uploadRepository() {
        return this.uploadRepository;
    }

    public UploadSerializer serializer() {
        return this.serializer;
    }

    private String accountIdParam() {
        return this.accountIdParam;
    }

    private String uploadURI() {
        return this.uploadURI;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.POST, this.uploadURI())).action((request, response) -> this.post(request, response)).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, this.uploadURI())).action(JMAPRoutes.CORS_CONTROL).noCorsHeaders()});
    }

    public Mono<Void> post(HttpServerRequest request, HttpServerResponse response) {
        String string2 = request.requestHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        Mono mono = SMono$.MODULE$.fromPublisher((Publisher)this.authenticator().authenticate(request)).flatMap((Function1 & Serializable)session -> this.post(request, response, ContentType.of((String)string2), (MailboxSession)session)).onErrorResume((Function1 & Serializable)x0$1 -> {
            SMono<Void> sMono;
            Throwable throwable = x0$1;
            if (throwable instanceof UnauthorizedException) {
                UnauthorizedException unauthorizedException = (UnauthorizedException)throwable;
                UploadRoutes$.MODULE$.LOGGER().warn("Unauthorized", (Throwable)unauthorizedException);
                HttpResponseStatus x$1 = HttpResponseStatus.UNAUTHORIZED;
                String x$2 = unauthorizedException.getMessage();
                String x$3 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$4 = ProblemDetails$.MODULE$.apply$default$3();
                sMono = this.respondDetails(unauthorizedException.addHeaders(response), new ProblemDetails(x$3, x$1, x$4, x$2), HttpResponseStatus.UNAUTHORIZED);
            } else if (throwable instanceof TooBigUploadException) {
                HttpResponseStatus x$5 = HttpResponseStatus.BAD_REQUEST;
                String x$6 = "Attempt to upload exceed max size";
                String x$7 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$8 = ProblemDetails$.MODULE$.apply$default$3();
                sMono = this.respondDetails(response, new ProblemDetails(x$7, x$5, x$8, "Attempt to upload exceed max size"), HttpResponseStatus.BAD_REQUEST);
            } else if (throwable instanceof ForbiddenException) {
                HttpResponseStatus x$9 = HttpResponseStatus.FORBIDDEN;
                String x$10 = "Upload to other accounts is forbidden";
                String x$11 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$12 = ProblemDetails$.MODULE$.apply$default$3();
                sMono = this.respondDetails(response, new ProblemDetails(x$11, x$9, x$12, "Upload to other accounts is forbidden"), HttpResponseStatus.FORBIDDEN);
            } else {
                UploadRoutes$.MODULE$.LOGGER().error("Unexpected error upon uploads", throwable);
                HttpResponseStatus x$13 = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                String x$14 = throwable.getMessage();
                String x$15 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$16 = ProblemDetails$.MODULE$.apply$default$3();
                sMono = this.respondDetails(response, new ProblemDetails(x$15, x$13, x$16, x$14), HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
            return sMono;
        }).asJava().subscribeOn(Schedulers.elastic()).then();
        return mono;
    }

    public SMono<Void> post(HttpServerRequest request, HttpServerResponse response, ContentType contentType, MailboxSession session) {
        Left left;
        IllegalArgumentException throwable;
        SMono sMono;
        Right right;
        String id;
        Either<IllegalArgumentException, Refined<String, Id.IdConstraint>> either = Id$.MODULE$.validate(request.param((CharSequence)this.accountIdParam()));
        if (either instanceof Right && new Refined((Object)(id = (String)((Refined)(right = (Right)either).value()).value())) instanceof Refined) {
            String string2 = id;
            AccountId targetAccountId = new AccountId(string2);
            sMono = (SMono)AccountId$.MODULE$.from(session.getUser()).map((Function1 & Serializable)accountId -> BoxesRunTime.boxToBoolean((boolean)accountId.equals(targetAccountId))).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)value -> UploadRoutes.$anonfun$post$5(this, request, targetAccountId, contentType, session, response, BoxesRunTime.unboxToBoolean((Object)value)));
        } else if (either instanceof Left && (throwable = (IllegalArgumentException)(left = (Left)either).value()) != null) {
            IllegalArgumentException illegalArgumentException = throwable;
            sMono = SMono$.MODULE$.error((Throwable)illegalArgumentException);
        } else {
            throw new MatchError(either);
        }
        return sMono;
    }

    public SMono<Void> handle(AccountId accountId, ContentType contentType, InputStream content, MailboxSession mailboxSession, HttpServerResponse response) {
        long maxSize = BoxesRunTime.unboxToLong((Object)this.configuration().maxUploadSize().value());
        return SMono$.MODULE$.fromCallable(() -> new LimitedInputStream(null, content, maxSize){

            public void raiseError(long max, long count) {
                if (count > max) {
                    throw new TooBigUploadException();
                }
            }
        }).flatMap((Function1 & Serializable)x$1 -> this.uploadContent(accountId, contentType, (InputStream)x$1, mailboxSession)).flatMap((Function1 & Serializable)uploadResponse -> {
            JsValue jsonValue = this.serializer().serialize((UploadResponse)uploadResponse);
            String json = Json$.MODULE$.stringify(jsonValue);
            byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
            return SMono$.MODULE$.fromPublisher((Publisher)response.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(bytes.length)).status(HttpResponseStatus.CREATED).sendByteArray((Publisher)SMono$.MODULE$.just((Object)bytes)));
        });
    }

    public SMono<UploadResponse> uploadContent(AccountId accountId, ContentType contentType, InputStream inputStream, MailboxSession session) {
        return SMono$.MODULE$.fromPublisher(this.uploadRepository().upload(inputStream, contentType, session.getUser())).map((Function1 & Serializable)x$2 -> this.fromAttachment((UploadMetaData)x$2, accountId));
    }

    private UploadResponse fromAttachment(UploadMetaData uploadMetaData, AccountId accountId) {
        BlobId x$1 = this.asBlobId(uploadMetaData.uploadId());
        ContentType x$2 = uploadMetaData.contentType();
        Long x$3 = uploadMetaData.size();
        AccountId x$4 = accountId;
        return new UploadResponse(x$4, x$1, x$2, x$3);
    }

    private BlobId asBlobId(UploadId uploadId) {
        return (BlobId)BlobId$.MODULE$.of(new StringBuilder(8).append("uploads-").append(uploadId.asString()).toString()).get();
    }

    private SMono<Void> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details, HttpResponseStatus statusCode) {
        return SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()).map((Function1 & Serializable)x$3 -> x$3.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then()));
    }

    private HttpResponseStatus respondDetails$default$3() {
        return HttpResponseStatus.BAD_REQUEST;
    }

    public static final /* synthetic */ SMono $anonfun$post$5(UploadRoutes $this, HttpServerRequest request$2, AccountId targetAccountId$1, ContentType contentType$1, MailboxSession session$1, HttpServerResponse response$2, boolean value) {
        return value ? SMono$.MODULE$.fromCallable(() -> ReactorUtils.toInputStream((Flux)request$2.receive().asByteArray().map(array -> ByteBuffer.wrap(array)))).flatMap((Function1 & Serializable)content -> $this.handle(targetAccountId$1, contentType$1, (InputStream)content, session$1, response$2)) : SMono$.MODULE$.error((Throwable)new ForbiddenException());
    }

    @Inject
    public UploadRoutes(@Named(value="RFC-8621") Authenticator authenticator, JmapRfc8621Configuration configuration, UploadRepository uploadRepository, UploadSerializer serializer) {
        this.authenticator = authenticator;
        this.configuration = configuration;
        this.uploadRepository = uploadRepository;
        this.serializer = serializer;
        this.accountIdParam = "accountId";
        this.uploadURI = new StringBuilder(10).append("/upload/{").append(this.accountIdParam()).append("}").toString();
    }

    public class CancelledUploadException
    extends RuntimeException {
        public /* synthetic */ UploadRoutes org$apache$james$jmap$routes$UploadRoutes$CancelledUploadException$$$outer() {
            return UploadRoutes.this;
        }

        public CancelledUploadException() {
            if (UploadRoutes.this == null) {
                throw null;
            }
        }
    }

    public class MaxFileSizeUploadException
    extends RuntimeException {
        public /* synthetic */ UploadRoutes org$apache$james$jmap$routes$UploadRoutes$MaxFileSizeUploadException$$$outer() {
            return UploadRoutes.this;
        }

        public MaxFileSizeUploadException() {
            if (UploadRoutes.this == null) {
                throw null;
            }
        }
    }
}

