/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.core.Username;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.core.JmapRfc8621Configuration;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.Session;
import org.apache.james.jmap.core.UrlPrefixes$;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.routes.SessionRoutes$;
import org.apache.james.jmap.routes.SessionSupplier;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.Json$;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dx!\u0002\u000e\u001c\u0011\u00031c!\u0002\u0015\u001c\u0011\u0003I\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004b\u0002\u001a\u0002\u0005\u0004%Ia\r\u0005\u0007\u007f\u0005\u0001\u000b\u0011\u0002\u001b\t\u000f\u0001\u000b!\u0019!C\u0005g!1\u0011)\u0001Q\u0001\nQBqAQ\u0001C\u0002\u0013%1\t\u0003\u0004K\u0003\u0001\u0006I\u0001\u0012\u0004\u0005Qm\u00011\n\u0003\u0005Y\u0013\t\u0015\r\u0011\"\u0001Z\u0011!\u0001\u0017B!A!\u0002\u0013Q\u0006\u0002C1\n\u0005\u000b\u0007I\u0011\u00012\t\u0011\u0019L!\u0011!Q\u0001\n\rD\u0001bZ\u0005\u0003\u0006\u0004%\t\u0001\u001b\u0005\t_&\u0011\t\u0011)A\u0005S\")\u0001'\u0003C\u0001a\"I\u00111B\u0005C\u0002\u0013%\u0011Q\u0002\u0005\t\u0003;I\u0001\u0015!\u0003\u0002\u0010!I\u0011qD\u0005C\u0002\u0013%\u0011Q\u0002\u0005\t\u0003CI\u0001\u0015!\u0003\u0002\u0010!1A$\u0003C!\u0003GAq!a\u000f\n\t\u0013\ti\u0004C\u0004\u0002z%!\t!a\u001f\t\u000f\u0005\u0005\u0016\u0002\"\u0003\u0002$\"I\u0011qZ\u0005\u0012\u0002\u0013%\u0011\u0011[\u0001\u000e'\u0016\u001c8/[8o%>,H/Z:\u000b\u0005qi\u0012A\u0002:pkR,7O\u0003\u0002\u001f?\u0005!!.\\1q\u0015\t\u0001\u0013%A\u0003kC6,7O\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<7\u0001\u0001\t\u0003O\u0005i\u0011a\u0007\u0002\u000e'\u0016\u001c8/[8o%>,H/Z:\u0014\u0005\u0005Q\u0003CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002M\u0005a!*T!Q?N+5kU%P\u001dV\tA\u0007\u0005\u00026y9\u0011aG\u000f\t\u0003o1j\u0011\u0001\u000f\u0006\u0003s\u0015\na\u0001\u0010:p_Rt\u0014BA\u001e-\u0003\u0019\u0001&/\u001a3fM&\u0011QH\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005mb\u0013!\u0004&N\u0003B{6+R*T\u0013>s\u0005%A\bX\u000b2cul\u0013(P/:{&*T!Q\u0003A9V\t\u0014'`\u0017:{uKT0K\u001b\u0006\u0003\u0006%\u0001\u0004M\u001f\u001e;UIU\u000b\u0002\tB\u0011Q\tS\u0007\u0002\r*\u0011qiI\u0001\u0006g24GG[\u0005\u0003\u0013\u001a\u0013a\u0001T8hO\u0016\u0014\u0018a\u0002'P\u000f\u001e+%\u000bI\n\u0004\u00131#\u0006CA'S\u001b\u0005q%BA(Q\u0003\u0011a\u0017M\\4\u000b\u0003E\u000bAA[1wC&\u00111K\u0014\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005U3V\"A\u000f\n\u0005]k\"A\u0003&N\u0003B\u0013v.\u001e;fg\u0006i\u0011-\u001e;iK:$\u0018nY1u_J,\u0012A\u0017\t\u00037zk\u0011\u0001\u0018\u0006\u0003;v\tA\u0001\u001b;ua&\u0011q\f\u0018\u0002\u000e\u0003V$\b.\u001a8uS\u000e\fGo\u001c:\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^8sA\u0005y1/Z:tS>t7+\u001e9qY&,'/F\u0001d!\t9C-\u0003\u0002f7\ty1+Z:tS>t7+\u001e9qY&,'/\u0001\ttKN\u001c\u0018n\u001c8TkB\u0004H.[3sA\u0005A\".\\1q%\u001a\u001c\u0007H\u000e\u001a2\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0016\u0003%\u0004\"A[7\u000e\u0003-T!\u0001\\\u000f\u0002\t\r|'/Z\u0005\u0003].\u0014\u0001DS7baJ37\r\u000f\u001c3c\r{gNZ5hkJ\fG/[8o\u0003eQW.\u00199SM\u000eDdGM\u0019D_:4\u0017nZ;sCRLwN\u001c\u0011\u0015\u000bE\u0014x0!\u0001\u0011\u0005\u001dJ\u0001\"\u0002-\u0011\u0001\u0004Q\u0006\u0006\u0002:uyv\u0004\"!\u001e>\u000e\u0003YT!a\u001e=\u0002\r%t'.Z2u\u0015\u0005I\u0018!\u00026bm\u0006D\u0018BA>w\u0005\u0015q\u0015-\\3e\u0003\u00151\u0018\r\\;fC\u0005q\u0018\u0001\u0003*G\u00076BdGM\u0019\t\u000b\u0005\u0004\u0002\u0019A2\t\u000b\u001d\u0004\u0002\u0019A5)\u0007A\t)\u0001E\u0002v\u0003\u000fI1!!\u0003w\u0005\u0019IeN[3di\u0006yq-\u001a8fe\u0006$XmU3tg&|g.\u0006\u0002\u0002\u0010A!\u0011\u0011CA\f\u001d\r)\u00161C\u0005\u0004\u0003+i\u0012!\u0003&N\u0003B\u0013v.\u001e;f\u0013\u0011\tI\"a\u0007\u0003\r\u0005\u001bG/[8o\u0015\r\t)\"H\u0001\u0011O\u0016tWM]1uKN+7o]5p]\u0002\n\u0011C]3eSJ,7\r\u001e+p'\u0016\u001c8/[8o\u0003I\u0011X\rZ5sK\u000e$Hk\\*fgNLwN\u001c\u0011\u0015\u0005\u0005\u0015\u0002CBA\u0014\u0003c\t)$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003\u0019\u0019HO]3b[*\u0019\u0011q\u0006)\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003g\tIC\u0001\u0004TiJ,\u0017-\u001c\t\u0004+\u0006]\u0012bAA\u001d;\tI!*T!Q%>,H/Z\u0001\fg\u0016tGMU3ta>tG\r\u0006\u0004\u0002@\u0005e\u00131\r\t\u0007\u0003\u0003\ny%a\u0015\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\n\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u00075\nIEC\u0002m\u0003\u0017R!!!\u0014\u0002\u000fI,\u0017m\u0019;pe&!\u0011\u0011KA\"\u0005\u0015\u0019Vj\u001c8p!\ri\u0015QK\u0005\u0004\u0003/r%\u0001\u0002,pS\u0012Dq!a\u0017\u0017\u0001\u0004\ti&A\u0004tKN\u001c\u0018n\u001c8\u0011\u0007)\fy&C\u0002\u0002b-\u0014qaU3tg&|g\u000eC\u0004\u0002fY\u0001\r!a\u001a\u0002\tI,7\u000f\u001d\t\u0005\u0003S\n)(\u0004\u0002\u0002l)!\u0011QNA8\u0003\u0019\u0019XM\u001d<fe*\u0019Q,!\u001d\u000b\t\u0005M\u00141J\u0001\u0006]\u0016$H/_\u0005\u0005\u0003o\nYG\u0001\nIiR\u00048+\u001a:wKJ\u0014Vm\u001d9p]N,\u0017!D3se>\u0014\b*\u00198eY&tw\r\u0006\u0004\u0002~\u0005\u001d\u0015Q\u0014\t\u0007\u0003\u007f\n\u0019)a\u0015\u000e\u0005\u0005\u0005%\u0002BA#\u0003\u0013JA!!\"\u0002\u0002\n!Qj\u001c8p\u0011\u001d\tIi\u0006a\u0001\u0003\u0017\u000b\u0011\u0002\u001e5s_^\f'\r\\3\u0011\t\u00055\u0015q\u0013\b\u0005\u0003\u001f\u000b\u0019JD\u00028\u0003#K\u0011!L\u0005\u0004\u0003+c\u0013a\u00029bG.\fw-Z\u0005\u0005\u00033\u000bYJA\u0005UQJ|w/\u00192mK*\u0019\u0011Q\u0013\u0017\t\u000f\u0005}u\u00031\u0001\u0002h\u0005A!/Z:q_:\u001cX-\u0001\bsKN\u0004xN\u001c3EKR\f\u0017\u000e\\:\u0015\u0011\u0005u\u0014QUAU\u0003gCq!a*\u0019\u0001\u0004\t9'\u0001\niiR\u00048+\u001a:wKJ\u0014Vm\u001d9p]N,\u0007bBAV1\u0001\u0007\u0011QV\u0001\bI\u0016$\u0018-\u001b7t!\rQ\u0017qV\u0005\u0004\u0003c['A\u0004)s_\ndW-\u001c#fi\u0006LGn\u001d\u0005\n\u0003kC\u0002\u0013!a\u0001\u0003o\u000b!b\u001d;biV\u001c8i\u001c3f!\u0011\tI,a3\u000e\u0005\u0005m&bA/\u0002>*!\u0011qXAa\u0003\u0015\u0019w\u000eZ3d\u0015\u0011\t\u0019-!2\u0002\u000f!\fg\u000e\u001a7fe*!\u00111OAd\u0015\t\tI-\u0001\u0002j_&!\u0011QZA^\u0005IAE\u000f\u001e9SKN\u0004xN\\:f'R\fG/^:\u00021I,7\u000f]8oI\u0012+G/Y5mg\u0012\"WMZ1vYR$3'\u0006\u0002\u0002T*\"\u0011qWAkW\t\t9\u000e\u0005\u0003\u0002Z\u0006\rXBAAn\u0015\u0011\ti.a8\u0002\u0013Ut7\r[3dW\u0016$'bAAqY\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00181\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class SessionRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final SessionSupplier sessionSupplier;
    private final JmapRfc8621Configuration jmapRfc8621Configuration;
    private final JMAPRoute.Action generateSession;
    private final JMAPRoute.Action redirectToSession;

    public Mono<Void> handleInternalError(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleInternalError(x$1, x$2, x$3);
    }

    public Mono<Void> handleBadRequest(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleBadRequest(x$1, x$2, x$3);
    }

    public Mono<Void> handleAuthenticationFailure(HttpServerResponse x$1, Logger x$2, Throwable x$3) {
        return super.handleAuthenticationFailure(x$1, x$2, x$3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    public JmapRfc8621Configuration jmapRfc8621Configuration() {
        return this.jmapRfc8621Configuration;
    }

    private JMAPRoute.Action generateSession() {
        return this.generateSession;
    }

    private JMAPRoute.Action redirectToSession() {
        return this.redirectToSession;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.GET, SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$JMAP_SESSION())).action(this.generateSession()).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$JMAP_SESSION())).action(JMAPRoutes.CORS_CONTROL).noCorsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.GET, SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$WELL_KNOWN_JMAP())).action(this.redirectToSession()).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$WELL_KNOWN_JMAP())).action(JMAPRoutes.CORS_CONTROL).noCorsHeaders()});
    }

    private SMono<Void> sendRespond(Session session, HttpServerResponse resp) {
        return SMono$.MODULE$.fromCallable(() -> Json$.MODULE$.stringify(ResponseSerializer$.MODULE$.serialize(session))).map((Function1 & Serializable)x$2 -> x$2.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.apply((Publisher)resp.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8").status(HttpResponseStatus.OK).header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then()));
    }

    public Mono<Void> errorHandling(Throwable throwable, HttpServerResponse response) {
        Mono<Void> mono;
        Throwable throwable2 = throwable;
        if (throwable2 instanceof UnauthorizedException) {
            UnauthorizedException unauthorizedException = (UnauthorizedException)throwable2;
            SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$LOGGER().warn("Unauthorized", (Throwable)unauthorizedException);
            HttpResponseStatus x$1 = HttpResponseStatus.UNAUTHORIZED;
            String x$2 = unauthorizedException.getMessage();
            String x$3 = ProblemDetails$.MODULE$.apply$default$1();
            Option<String> x$4 = ProblemDetails$.MODULE$.apply$default$3();
            mono = this.respondDetails(unauthorizedException.addHeaders(response), new ProblemDetails(x$3, x$1, x$4, x$2), HttpResponseStatus.UNAUTHORIZED);
        } else {
            SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$LOGGER().error("Unexpected error upon requesting session", throwable2);
            HttpResponseStatus x$5 = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            String x$6 = throwable2.getMessage();
            String x$7 = ProblemDetails$.MODULE$.apply$default$1();
            Option<String> x$8 = ProblemDetails$.MODULE$.apply$default$3();
            mono = this.respondDetails(response, new ProblemDetails(x$7, x$5, x$8, x$6), HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
        return mono;
    }

    private Mono<Void> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details, HttpResponseStatus statusCode) {
        return SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()).map((Function1 & Serializable)x$3 -> x$3.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then())).asJava();
    }

    private HttpResponseStatus respondDetails$default$3() {
        return HttpResponseStatus.BAD_REQUEST;
    }

    public static final /* synthetic */ void $anonfun$generateSession$3(SessionRoutes $this, HttpServerRequest request$1, Username x0$1, SynchronousSink x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Username username = (Username)tuple2._1();
        SynchronousSink sink = (SynchronousSink)tuple2._2();
        BoxedUnit boxedUnit = (BoxedUnit)$this.sessionSupplier().generate(username, UrlPrefixes$.MODULE$.from($this.jmapRfc8621Configuration(), request$1)).fold((Function1 & Serializable)x$1 -> {
            sink.error(x$1);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)session -> {
            sink.next((Object)session);
            return BoxedUnit.UNIT;
        });
    }

    @Inject
    public SessionRoutes(@Named(value="RFC-8621") Authenticator authenticator, SessionSupplier sessionSupplier, JmapRfc8621Configuration jmapRfc8621Configuration) {
        this.authenticator = authenticator;
        this.sessionSupplier = sessionSupplier;
        this.jmapRfc8621Configuration = jmapRfc8621Configuration;
        this.generateSession = (request, response) -> SMono$.MODULE$.fromPublisher((Publisher)this.authenticator().authenticate(request)).map((Function1 & Serializable)x$1 -> x$1.getUser()).handle((Function2 & Serializable)(x0$1, x1$1) -> {
            SessionRoutes.$anonfun$generateSession$3(this, request, x0$1, x1$1);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)session -> this.sendRespond((Session)session, response)).onErrorResume((Function1 & Serializable)throwable -> SMono$.MODULE$.fromPublisher(this.errorHandling((Throwable)throwable, response))).subscribeOn(Schedulers.elastic()).asJava();
        this.redirectToSession = JMAPRoutes.redirectTo((String)SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$JMAP_SESSION());
    }
}

