/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.auto$;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.ClientId;
import org.apache.james.jmap.core.Id$;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.core.ServerId;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.json.MailboxSerializer;
import org.apache.james.jmap.mail.IsSubscribed;
import org.apache.james.jmap.mail.MailboxCreationId;
import org.apache.james.jmap.mail.MailboxCreationRequest;
import org.apache.james.jmap.mail.MailboxCreationRequest$;
import org.apache.james.jmap.mail.MailboxCreationResponse;
import org.apache.james.jmap.mail.MailboxRights;
import org.apache.james.jmap.mail.MailboxRights$;
import org.apache.james.jmap.mail.MailboxSetRequest;
import org.apache.james.jmap.mail.Quota;
import org.apache.james.jmap.mail.QuotaId;
import org.apache.james.jmap.mail.Quotas;
import org.apache.james.jmap.mail.SortOrder;
import org.apache.james.jmap.mail.SortOrder$;
import org.apache.james.jmap.mail.TotalEmails;
import org.apache.james.jmap.mail.TotalThreads;
import org.apache.james.jmap.mail.UnreadEmails;
import org.apache.james.jmap.mail.UnreadThreads;
import org.apache.james.jmap.method.MailboxCreationParseException;
import org.apache.james.jmap.routes.ProcessingContext;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.jmap.utils.quotas.QuotaLoaderWithPreloadedDefaultFactory;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.InsufficientRightsException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNameException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import play.api.libs.json.JsError;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.JsonValidationError;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scheduler.Schedulers;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u00115s!B2e\u0011\u0003yg!B9e\u0011\u0003\u0011\b\"B=\u0002\t\u0003QhaB>\u0002!\u0003\r\n\u0003 \u0005\u0006{\u000e1\tA \u0004\u0007\u00037\f\u0001)!8\t\u0011u,!Q3A\u0005\u0002yD\u0011\"a\r\u0006\u0005#\u0005\u000b\u0011B@\t\u0015\u0005}WA!f\u0001\n\u0003\t\t\u000f\u0003\u0006\u0002j\u0016\u0011\t\u0012)A\u0005\u0003GDa!_\u0003\u0005\u0002\u0005-\b\"CA-\u000b\u0005\u0005I\u0011AAz\u0011%\t\t'BI\u0001\n\u0003\t\u0019\u0007C\u0005\u0002z\u0015\t\n\u0011\"\u0001\u0002z\"I\u0011qP\u0003\u0002\u0002\u0013\u0005\u0013\u0011\u0011\u0005\n\u0003'+\u0011\u0011!C\u0001\u0003+C\u0011\"!(\u0006\u0003\u0003%\t!!@\t\u0013\u0005-V!!A\u0005B\u00055\u0006\"CA^\u000b\u0005\u0005I\u0011\u0001B\u0001\u0011%\t9-BA\u0001\n\u0003\u0012)\u0001C\u0005\u0002N\u0016\t\t\u0011\"\u0011\u0002P\"I\u0011\u0011[\u0003\u0002\u0002\u0013\u0005\u00131\u001b\u0005\n\u0003+,\u0011\u0011!C!\u0005\u00139\u0011B!\u0004\u0002\u0003\u0003E\tAa\u0004\u0007\u0013\u0005m\u0017!!A\t\u0002\tE\u0001BB=\u0019\t\u0003\u0011I\u0003C\u0005\u0002Rb\t\t\u0011\"\u0012\u0002T\"I!1\u0006\r\u0002\u0002\u0013\u0005%Q\u0006\u0005\n\u0005gA\u0012\u0011!CA\u0005kA\u0011Ba\u0012\u0019\u0003\u0003%IA!\u0013\u0007\r\u00055\u0011\u0001QA\b\u0011!ihD!f\u0001\n\u0003q\b\"CA\u001a=\tE\t\u0015!\u0003\u0000\u0011)\t)D\bBK\u0002\u0013\u0005\u0011q\u0007\u0005\u000b\u0003\u007fq\"\u0011#Q\u0001\n\u0005e\u0002BB=\u001f\t\u0003\t\t\u0005C\u0004\u0002Jy!\t!a\u0013\t\u0013\u0005ec$!A\u0005\u0002\u0005m\u0003\"CA1=E\u0005I\u0011AA2\u0011%\tIHHI\u0001\n\u0003\tY\bC\u0005\u0002\u0000y\t\t\u0011\"\u0011\u0002\u0002\"I\u00111\u0013\u0010\u0002\u0002\u0013\u0005\u0011Q\u0013\u0005\n\u0003;s\u0012\u0011!C\u0001\u0003?C\u0011\"a+\u001f\u0003\u0003%\t%!,\t\u0013\u0005mf$!A\u0005\u0002\u0005u\u0006\"CAd=\u0005\u0005I\u0011IAe\u0011%\tiMHA\u0001\n\u0003\ny\rC\u0005\u0002Rz\t\t\u0011\"\u0011\u0002T\"I\u0011Q\u001b\u0010\u0002\u0002\u0013\u0005\u0013q[\u0004\n\u0005#\n\u0011\u0011!E\u0001\u0005'2\u0011\"!\u0004\u0002\u0003\u0003E\tA!\u0016\t\re\u0014D\u0011\u0001B-\u0011%\t\tNMA\u0001\n\u000b\n\u0019\u000eC\u0005\u0003,I\n\t\u0011\"!\u0003\\!I!1\u0007\u001a\u0002\u0002\u0013\u0005%\u0011\r\u0005\n\u0005\u000f\u0012\u0014\u0011!C\u0005\u0005\u00132aA!\u001b\u0002\u0001\n-\u0004B\u0003B7q\tU\r\u0011\"\u0001\u0003p!Q!q\u000f\u001d\u0003\u0012\u0003\u0006IA!\u001d\t\reDD\u0011\u0001B=\u0011\u001d\u0011y\b\u000fC\u0001\u0005\u0003CqAa%9\t\u0003\u0011)\nC\u0005\u0002Za\n\t\u0011\"\u0001\u0003\u001a\"I\u0011\u0011\r\u001d\u0012\u0002\u0013\u0005!Q\u0014\u0005\n\u0003\u007fB\u0014\u0011!C!\u0003\u0003C\u0011\"a%9\u0003\u0003%\t!!&\t\u0013\u0005u\u0005(!A\u0005\u0002\t\u0005\u0006\"CAVq\u0005\u0005I\u0011IAW\u0011%\tY\fOA\u0001\n\u0003\u0011)\u000bC\u0005\u0002Hb\n\t\u0011\"\u0011\u0003*\"I\u0011Q\u001a\u001d\u0002\u0002\u0013\u0005\u0013q\u001a\u0005\n\u0003#D\u0014\u0011!C!\u0003'D\u0011\"!69\u0003\u0003%\tE!,\b\u0013\tE\u0016!!A\t\u0002\tMf!\u0003B5\u0003\u0005\u0005\t\u0012\u0001B[\u0011\u0019I(\n\"\u0001\u0003>\"I\u0011\u0011\u001b&\u0002\u0002\u0013\u0015\u00131\u001b\u0005\n\u0005WQ\u0015\u0011!CA\u0005\u007fC\u0011Ba\rK\u0003\u0003%\tIa1\t\u0013\t\u001d#*!A\u0005\n\t%c!B9e\u0001\t%\u0007B\u0003Bf!\n\u0005\t\u0015!\u0003\u0003N\"Q!\u0011\u001c)\u0003\u0002\u0003\u0006IAa7\t\u0015\t\u001d\bK!A!\u0002\u0013\u0011I\u000f\u0003\u0006\u0003pB\u0013\t\u0011)A\u0005\u0005cD!b!\u0002Q\u0005\u0003\u0005\u000b\u0011BB\u0004\u0011)\u00199\u0002\u0015BC\u0002\u0013\u00051\u0011\u0004\u0005\u000b\u0007W\u0001&\u0011!Q\u0001\n\rm\u0001BCB\u0017!\n\u0015\r\u0011\"\u0001\u00040!Q1Q\b)\u0003\u0002\u0003\u0006Ia!\r\t\re\u0004F\u0011AB \u0011\u001d\u0019\u0019\u0007\u0015C\u0001\u0007KBqaa-Q\t\u0013\u0019)\fC\u0004\u0004ZB#Iaa7\t\u000f\rE\b\u000b\"\u0003\u0004t\"9A1\u0001)\u0005\n\u0011\u0015\u0001b\u0002C\n!\u0012%AQ\u0003\u0005\b\tK\u0001F\u0011\u0002C\u0014\u0011\u001d\u0019\u0019\f\u0015C\u0005\t\u0003\n\u0011$T1jY\n|\u0007pU3u\u0007J,\u0017\r^3QKJ4wN]7fe*\u0011QMZ\u0001\u0007[\u0016$\bn\u001c3\u000b\u0005\u001dD\u0017\u0001\u00026nCBT!!\u001b6\u0002\u000b)\fW.Z:\u000b\u0005-d\u0017AB1qC\u000eDWMC\u0001n\u0003\ry'oZ\u0002\u0001!\t\u0001\u0018!D\u0001e\u0005ei\u0015-\u001b7c_b\u001cV\r^\"sK\u0006$X\rU3sM>\u0014X.\u001a:\u0014\u0005\u0005\u0019\bC\u0001;x\u001b\u0005)(\"\u0001<\u0002\u000bM\u001c\u0017\r\\1\n\u0005a,(AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002_\n)R*Y5mE>D8I]3bi&|gNU3tk2$8CA\u0002t\u0003Ei\u0017-\u001b7c_b\u001c%/Z1uS>t\u0017\nZ\u000b\u0002\u007fB!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006\u0019\fA!\\1jY&!\u0011\u0011BA\u0002\u0005Ei\u0015-\u001b7c_b\u001c%/Z1uS>t\u0017\nZ\u0015\u0004\u0007y)!AF'bS2\u0014w\u000e_\"sK\u0006$\u0018n\u001c8GC&dWO]3\u0014\u0011y\u0019\u0018\u0011CA\u000b\u00037\u00012!a\u0005\u0004\u001b\u0005\t\u0001c\u0001;\u0002\u0018%\u0019\u0011\u0011D;\u0003\u000fA\u0013x\u000eZ;diB!\u0011QDA\u0017\u001d\u0011\ty\"!\u000b\u000f\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\no\u0003\u0019a$o\\8u}%\ta/C\u0002\u0002,U\fq\u0001]1dW\u0006<W-\u0003\u0003\u00020\u0005E\"\u0001D*fe&\fG.\u001b>bE2,'bAA\u0016k\u0006\u0011R.Y5mE>D8I]3bi&|g.\u00133!\u0003%)\u0007pY3qi&|g.\u0006\u0002\u0002:A!\u0011QDA\u001e\u0013\u0011\ti$!\r\u0003\u0013\u0015C8-\u001a9uS>t\u0017AC3yG\u0016\u0004H/[8oAQ1\u00111IA#\u0003\u000f\u00022!a\u0005\u001f\u0011\u0015i8\u00051\u0001\u0000\u0011\u001d\t)d\ta\u0001\u0003s\t\u0011#Y:NC&d'm\u001c=TKR,%O]8s+\t\ti\u0005\u0005\u0003\u0002P\u0005USBAA)\u0015\r\t\u0019FZ\u0001\u0005G>\u0014X-\u0003\u0003\u0002X\u0005E#\u0001C*fi\u0016\u0013(o\u001c:\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003\u0007\ni&a\u0018\t\u000fu,\u0003\u0013!a\u0001\u007f\"I\u0011QG\u0013\u0011\u0002\u0003\u0007\u0011\u0011H\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)GK\u0002\u0000\u0003OZ#!!\u001b\u0011\t\u0005-\u0014QO\u0007\u0003\u0003[RA!a\u001c\u0002r\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003g*\u0018AC1o]>$\u0018\r^5p]&!\u0011qOA7\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tiH\u000b\u0003\u0002:\u0005\u001d\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0004B!\u0011QQAH\u001b\t\t9I\u0003\u0003\u0002\n\u0006-\u0015\u0001\u00027b]\u001eT!!!$\u0002\t)\fg/Y\u0005\u0005\u0003#\u000b9I\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003/\u00032\u0001^AM\u0013\r\tY*\u001e\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003C\u000b9\u000bE\u0002u\u0003GK1!!*v\u0005\r\te.\u001f\u0005\n\u0003SS\u0013\u0011!a\u0001\u0003/\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAX!\u0019\t\t,a.\u0002\"6\u0011\u00111\u0017\u0006\u0004\u0003k+\u0018AC2pY2,7\r^5p]&!\u0011\u0011XAZ\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005}\u0016Q\u0019\t\u0004i\u0006\u0005\u0017bAAbk\n9!i\\8mK\u0006t\u0007\"CAUY\u0005\u0005\t\u0019AAQ\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005\r\u00151\u001a\u0005\n\u0003Sk\u0013\u0011!a\u0001\u0003/\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003/\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0007\u000ba!Z9vC2\u001cH\u0003BA`\u00033D\u0011\"!+1\u0003\u0003\u0005\r!!)\u0003-5\u000b\u0017\u000e\u001c2pq\u000e\u0013X-\u0019;j_:\u001cVoY2fgN\u001c\u0002\"B:\u0002\u0012\u0005U\u00111D\u0001\u0018[\u0006LGNY8y\u0007J,\u0017\r^5p]J+7\u000f]8og\u0016,\"!a9\u0011\t\u0005\u0005\u0011Q]\u0005\u0005\u0003O\f\u0019AA\fNC&d'm\u001c=De\u0016\fG/[8o%\u0016\u001c\bo\u001c8tK\u0006AR.Y5mE>D8I]3bi&|gNU3ta>t7/\u001a\u0011\u0015\r\u00055\u0018q^Ay!\r\t\u0019\"\u0002\u0005\u0006{*\u0001\ra \u0005\b\u0003?T\u0001\u0019AAr)\u0019\ti/!>\u0002x\"9Qp\u0003I\u0001\u0002\u0004y\b\"CAp\u0017A\u0005\t\u0019AAr+\t\tYP\u000b\u0003\u0002d\u0006\u001dD\u0003BAQ\u0003\u007fD\u0011\"!+\u0011\u0003\u0003\u0005\r!a&\u0015\t\u0005}&1\u0001\u0005\n\u0003S\u0013\u0012\u0011!a\u0001\u0003C#B!a!\u0003\b!I\u0011\u0011V\n\u0002\u0002\u0003\u0007\u0011q\u0013\u000b\u0005\u0003\u007f\u0013Y\u0001C\u0005\u0002*Z\t\t\u00111\u0001\u0002\"\u00061R*Y5mE>D8I]3bi&|gnU;dG\u0016\u001c8\u000fE\u0002\u0002\u0014a\u0019R\u0001\u0007B\n\u0005?\u0001\u0012B!\u0006\u0003\u001c}\f\u0019/!<\u000e\u0005\t]!b\u0001B\rk\u00069!/\u001e8uS6,\u0017\u0002\u0002B\u000f\u0005/\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\u0011\tCa\n\u000e\u0005\t\r\"\u0002\u0002B\u0013\u0003\u0017\u000b!![8\n\t\u0005=\"1\u0005\u000b\u0003\u0005\u001f\tQ!\u00199qYf$b!!<\u00030\tE\u0002\"B?\u001c\u0001\u0004y\bbBAp7\u0001\u0007\u00111]\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u00119Da\u0011\u0011\u000bQ\u0014ID!\u0010\n\u0007\tmRO\u0001\u0004PaRLwN\u001c\t\u0007i\n}r0a9\n\u0007\t\u0005SO\u0001\u0004UkBdWM\r\u0005\n\u0005\u000bb\u0012\u0011!a\u0001\u0003[\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011Y\u0005\u0005\u0003\u0002\u0006\n5\u0013\u0002\u0002B(\u0003\u000f\u0013aa\u00142kK\u000e$\u0018AF'bS2\u0014w\u000e_\"sK\u0006$\u0018n\u001c8GC&dWO]3\u0011\u0007\u0005M!gE\u00033\u0005/\u0012y\u0002E\u0005\u0003\u0016\tmq0!\u000f\u0002DQ\u0011!1\u000b\u000b\u0007\u0003\u0007\u0012iFa\u0018\t\u000bu,\u0004\u0019A@\t\u000f\u0005UR\u00071\u0001\u0002:Q!!1\rB4!\u0015!(\u0011\bB3!\u0019!(qH@\u0002:!I!Q\t\u001c\u0002\u0002\u0003\u0007\u00111\t\u0002\u0017\u001b\u0006LGNY8y\u0007J,\u0017\r^5p]J+7/\u001e7ugN1\u0001h]A\u000b\u00037\tqa\u0019:fCR,G-\u0006\u0002\u0003rA1\u0011Q\u0004B:\u0003#IAA!\u001e\u00022\t\u00191+Z9\u0002\u0011\r\u0014X-\u0019;fI\u0002\"BAa\u001f\u0003~A\u0019\u00111\u0003\u001d\t\u000f\t54\b1\u0001\u0003r\u0005y!/\u001a;sS\u00164Xm\u0011:fCR,G-\u0006\u0002\u0003\u0004B9!Q\u0011BG\u007f\u0006\rh\u0002\u0002BD\u0005\u0013\u00032!!\tv\u0013\r\u0011Y)^\u0001\u0007!J,G-\u001a4\n\t\t=%\u0011\u0013\u0002\u0004\u001b\u0006\u0004(b\u0001BFk\u0006q!/\u001a;sS\u00164X-\u0012:s_J\u001cXC\u0001BL!\u001d\u0011)I!$\u0000\u0003\u001b\"BAa\u001f\u0003\u001c\"I!Q\u000e \u0011\u0002\u0003\u0007!\u0011O\u000b\u0003\u0005?SCA!\u001d\u0002hQ!\u0011\u0011\u0015BR\u0011%\tIKQA\u0001\u0002\u0004\t9\n\u0006\u0003\u0002@\n\u001d\u0006\"CAU\t\u0006\u0005\t\u0019AAQ)\u0011\t\u0019Ia+\t\u0013\u0005%V)!AA\u0002\u0005]E\u0003BA`\u0005_C\u0011\"!+I\u0003\u0003\u0005\r!!)\u0002-5\u000b\u0017\u000e\u001c2pq\u000e\u0013X-\u0019;j_:\u0014Vm];miN\u00042!a\u0005K'\u0015Q%q\u0017B\u0010!!\u0011)B!/\u0003r\tm\u0014\u0002\u0002B^\u0005/\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82)\t\u0011\u0019\f\u0006\u0003\u0003|\t\u0005\u0007b\u0002B7\u001b\u0002\u0007!\u0011\u000f\u000b\u0005\u0005\u000b\u00149\rE\u0003u\u0005s\u0011\t\bC\u0005\u0003F9\u000b\t\u00111\u0001\u0003|M\u0011\u0001k]\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0003\u0002Bh\u0005+l!A!5\u000b\u0007\tMg-\u0001\u0003kg>t\u0017\u0002\u0002Bl\u0005#\u0014\u0011#T1jY\n|\u0007pU3sS\u0006d\u0017N_3s\u00039i\u0017-\u001b7c_bl\u0015M\\1hKJ\u0004BA!8\u0003d6\u0011!q\u001c\u0006\u0004\u0005CD\u0017aB7bS2\u0014w\u000e_\u0005\u0005\u0005K\u0014yN\u0001\bNC&d'm\u001c=NC:\fw-\u001a:\u0002'M,(m]2sSB$\u0018n\u001c8NC:\fw-\u001a:\u0011\t\tu'1^\u0005\u0005\u0005[\u0014yNA\nTk\n\u001c8M]5qi&|g.T1oC\u001e,'/\u0001\tnC&d'm\u001c=JI\u001a\u000b7\r^8ssB!!1\u001fB\u0000\u001d\u0011\u0011)Pa?\u000e\u0005\t](\u0002\u0002B}\u0005?\fQ!\\8eK2LAA!@\u0003x\u0006IQ*Y5mE>D\u0018\nZ\u0005\u0005\u0007\u0003\u0019\u0019AA\u0004GC\u000e$xN]=\u000b\t\tu(q_\u0001\rcV|G/\u0019$bGR|'/\u001f\t\u0005\u0007\u0013\u0019\u0019\"\u0004\u0002\u0004\f)!1QBB\b\u0003\u0019\tXo\u001c;bg*\u00191\u0011\u00034\u0002\u000bU$\u0018\u000e\\:\n\t\rU11\u0002\u0002'#V|G/\u0019'pC\u0012,'oV5uQB\u0013X\r\\8bI\u0016$G)\u001a4bk2$h)Y2u_JL\u0018!D7fiJL7MR1di>\u0014\u00180\u0006\u0002\u0004\u001cA!1QDB\u0014\u001b\t\u0019yB\u0003\u0003\u0004\"\r\r\u0012aA1qS*\u00191Q\u00055\u0002\u000f5,GO]5dg&!1\u0011FB\u0010\u00055iU\r\u001e:jG\u001a\u000b7\r^8ss\u0006qQ.\u001a;sS\u000e4\u0015m\u0019;pef\u0004\u0013aD:fgNLwN\\*vaBd\u0017.\u001a:\u0016\u0005\rE\u0002\u0003BB\u001a\u0007si!a!\u000e\u000b\u0007\r]b-\u0001\u0004s_V$Xm]\u0005\u0005\u0007w\u0019)DA\bTKN\u001c\u0018n\u001c8TkB\u0004H.[3s\u0003A\u0019Xm]:j_:\u001cV\u000f\u001d9mS\u0016\u0014\b\u0005\u0006\t\u0004B\r\r3QIB$\u0007\u0013\u001aYe!\u0014\u0004PA\u0011\u0001\u000f\u0015\u0005\b\u0005\u0017T\u0006\u0019\u0001Bg\u0011\u001d\u0011IN\u0017a\u0001\u00057DqAa:[\u0001\u0004\u0011I\u000fC\u0004\u0003pj\u0003\rA!=\t\u000f\r\u0015!\f1\u0001\u0004\b!91q\u0003.A\u0002\rm\u0001bBB\u00175\u0002\u00071\u0011\u0007\u0015\u00045\u000eM\u0003\u0003BB+\u0007?j!aa\u0016\u000b\t\re31L\u0001\u0007S:TWm\u0019;\u000b\u0005\ru\u0013!\u00026bm\u0006D\u0018\u0002BB1\u0007/\u0012a!\u00138kK\u000e$\u0018aD2sK\u0006$X-T1jY\n|\u00070Z:\u0015\u0011\r\u001d41TBS\u0007_\u0003ba!\u001b\u0004x\rmTBAB6\u0015\u0011\u0019iga\u001c\u0002\u0013A,(\r\\5tQ\u0016\u0014(b\u0001<\u0004r)!\u00111KB:\u0015\t\u0019)(A\u0004sK\u0006\u001cGo\u001c:\n\t\re41\u000e\u0002\u0006'6{gn\u001c\t\bi\n}2QPBK!\r\u0019y\b\u000f\b\u0004\u0007\u0003\u0003a\u0002BBB\u0007'sAa!\"\u0004\u0012:!1qQBH\u001d\u0011\u0019Ii!$\u000f\t\u0005\u000521R\u0005\u0002[&\u00111\u000e\\\u0005\u0003S*L!a\u001a5\n\u0005\u00154\u0007\u0003BB\u001a\u0007/KAa!'\u00046\t\t\u0002K]8dKN\u001c\u0018N\\4D_:$X\r\u001f;\t\u000f\ru5\f1\u0001\u0004 \u0006qQ.Y5mE>D8+Z:tS>t\u0007\u0003\u0002Bo\u0007CKAaa)\u0003`\nqQ*Y5mE>D8+Z:tS>t\u0007bBBT7\u0002\u00071\u0011V\u0001\u0012[\u0006LGNY8y'\u0016$(+Z9vKN$\b\u0003BA\u0001\u0007WKAa!,\u0002\u0004\t\tR*Y5mE>D8+\u001a;SKF,Xm\u001d;\t\u000f\rE6\f1\u0001\u0004\u0016\u0006\t\u0002O]8dKN\u001c\u0018N\\4D_:$X\r\u001f;\u0002\u001b\r\u0014X-\u0019;f\u001b\u0006LGNY8y))\u00199la/\u0004>\u000e}6q\u001b\t\bi\n}2\u0011XBK!\r\u0019yh\u0001\u0005\b\u0007;c\u0006\u0019ABP\u0011\u0015iH\f1\u0001\u0000\u0011\u001d\u0019\t\r\u0018a\u0001\u0007\u0007\f\u0001B[:PE*,7\r\u001e\t\u0005\u0007\u000b\u001c\u0019.\u0004\u0002\u0004H*!!1[Be\u0015\u0011\u0019Ym!4\u0002\t1L'm\u001d\u0006\u0005\u0007C\u0019yM\u0003\u0002\u0004R\u0006!\u0001\u000f\\1z\u0013\u0011\u0019)na2\u0003\u0011)\u001bxJ\u00196fGRDqa!-]\u0001\u0004\u0019)*A\u0006qCJ\u001cXm\u0011:fCR,G\u0003BBo\u0007_\u0004\u0002\"!\b\u0004`\u000e\r8\u0011^\u0005\u0005\u0007C\f\tD\u0001\u0004FSRDWM\u001d\t\u0004a\u000e\u0015\u0018bABtI\niR*Y5mE>D8I]3bi&|g\u000eU1sg\u0016,\u0005pY3qi&|g\u000e\u0005\u0003\u0002\u0002\r-\u0018\u0002BBw\u0003\u0007\u0011a#T1jY\n|\u0007p\u0011:fCRLwN\u001c*fcV,7\u000f\u001e\u0005\b\u0007\u0003l\u0006\u0019ABb\u0003-\u0011Xm]8mm\u0016\u0004\u0016\r\u001e5\u0015\r\rU8Q`B\u0000!!\tiba8\u0002:\r]\b\u0003\u0002B{\u0007sLAaa?\u0003x\nYQ*Y5mE>D\b+\u0019;i\u0011\u001d\u0019iJ\u0018a\u0001\u0007?Cq\u0001\"\u0001_\u0001\u0004\u0019I/\u0001\fnC&d'm\u001c=De\u0016\fG/[8o%\u0016\fX/Z:u\u00031\u0011X\r\u001e:jKZ,\u0007+\u0019;i)\u0019\u0019)\u0010b\u0002\u0005\u0012!9A\u0011B0A\u0002\u0011-\u0011!C7bS2\u0014w\u000e_%e!\u0011\u0011)\u0010\"\u0004\n\t\u0011=!q\u001f\u0002\n\u001b\u0006LGNY8y\u0013\u0012Dqa!(`\u0001\u0004\u0019y*A\u0012sK\u000e|'\u000fZ\"sK\u0006$\u0018n\u001c8JI&s\u0007K]8dKN\u001c\u0018N\\4D_:$X\r\u001f;\u0015\u0011\u0011]Aq\u0004C\u0011\tG\u0001\u0002\"!\b\u0004`\u0012e1Q\u0013\t\u0005\u0003;!Y\"\u0003\u0003\u0005\u001e\u0005E\"\u0001G%mY\u0016<\u0017\r\\!sOVlWM\u001c;Fq\u000e,\u0007\u000f^5p]\")Q\u0010\u0019a\u0001\u007f\"91\u0011\u00171A\u0002\rU\u0005b\u0002C\u0005A\u0002\u0007A1B\u0001\u0010[\u0006LGNY8y'\u0016$XI\u001d:peR!\u0011Q\nC\u0015\u0011\u001d!Y#\u0019a\u0001\t[\ta!\u001a:s_J\u001c\bCBAY\t_!\t$\u0003\u0003\u0003v\u0005M\u0006c\u0002;\u0003@\u0011MB\u0011\b\t\u0005\u0007\u000b$)$\u0003\u0003\u00058\r\u001d'A\u0002&t!\u0006$\b\u000e\u0005\u0004\u00022\u0012=B1\b\t\u0005\u0007\u000b$i$\u0003\u0003\u0005@\r\u001d'a\u0005&t_:4\u0016\r\\5eCRLwN\\#se>\u0014H\u0003\u0003C\"\t\u000b\"9\u0005b\u0013\u0011\u0011\u0005u1q\\A\u001d\u0003GDqa!(c\u0001\u0004\u0019y\nC\u0004\u0005J\t\u0004\raa>\u0002\tA\fG\u000f\u001b\u0005\b\t\u0003\u0011\u0007\u0019ABu\u0001")
public class MailboxSetCreatePerformer {
    private final MailboxSerializer serializer;
    private final MailboxManager mailboxManager;
    private final SubscriptionManager subscriptionManager;
    private final MailboxId.Factory mailboxIdFactory;
    private final QuotaLoaderWithPreloadedDefaultFactory quotaFactory;
    private final MetricFactory metricFactory;
    private final SessionSupplier sessionSupplier;

    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    public SMono<Tuple2<MailboxCreationResults, ProcessingContext>> createMailboxes(MailboxSession mailboxSession, MailboxSetRequest mailboxSetRequest, ProcessingContext processingContext) {
        return SFlux$.MODULE$.fromIterable((Iterable)((MapOps)mailboxSetRequest.create().getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())).view()).fold((Object)new Tuple2((Object)new MailboxCreationResults((scala.collection.immutable.Seq<MailboxCreationResult>)package$.MODULE$.Nil()), (Object)processingContext), (Function2 & Serializable)(acc, elem) -> {
            Tuple2 tuple2 = elem;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MailboxCreationId mailboxCreationId = (MailboxCreationId)tuple2._1();
            JsObject jsObject = (JsObject)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)mailboxCreationId, (Object)jsObject);
            Tuple2 tuple23 = tuple22;
            MailboxCreationId mailboxCreationId2 = (MailboxCreationId)tuple23._1();
            JsObject jsObject2 = (JsObject)tuple23._2();
            Tuple2<MailboxCreationResult, ProcessingContext> tuple24 = this.createMailbox(mailboxSession, mailboxCreationId2, jsObject2, (ProcessingContext)acc._2());
            if (tuple24 == null) {
                throw new MatchError(tuple24);
            }
            MailboxCreationResult creationResult = (MailboxCreationResult)tuple24._1();
            ProcessingContext updatedProcessingContext = (ProcessingContext)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)creationResult, (Object)updatedProcessingContext);
            Tuple2 tuple26 = tuple25;
            MailboxCreationResult creationResult2 = (MailboxCreationResult)tuple26._1();
            ProcessingContext updatedProcessingContext2 = (ProcessingContext)tuple26._2();
            return new Tuple2((Object)new MailboxCreationResults((scala.collection.immutable.Seq<MailboxCreationResult>)((scala.collection.immutable.Seq)((MailboxCreationResults)acc._1()).created().$colon$plus((Object)creationResult2))), (Object)updatedProcessingContext2);
        }).subscribeOn(Schedulers.elastic());
    }

    private Tuple2<MailboxCreationResult, ProcessingContext> createMailbox(MailboxSession mailboxSession, MailboxCreationId mailboxCreationId, JsObject jsObject, ProcessingContext processingContext) {
        return (Tuple2)this.parseCreate(jsObject).flatMap((Function1 & Serializable)mailboxCreationRequest -> this.resolvePath(mailboxSession, (MailboxCreationRequest)mailboxCreationRequest).flatMap((Function1 & Serializable)path -> this.createMailbox(mailboxSession, (MailboxPath)path, (MailboxCreationRequest)mailboxCreationRequest))).flatMap((Function1 & Serializable)creationResponse -> this.recordCreationIdInProcessingContext(mailboxCreationId, processingContext, creationResponse.id()).map((Function1 & Serializable)context -> new Tuple2(creationResponse, context))).fold((Function1 & Serializable)e -> new Tuple2((Object)new MailboxCreationFailure(mailboxCreationId, (Exception)e), (Object)processingContext), (Function1 & Serializable)creationResponseWithUpdatedContext -> new Tuple2((Object)new MailboxCreationSuccess(mailboxCreationId, (MailboxCreationResponse)creationResponseWithUpdatedContext._1()), creationResponseWithUpdatedContext._2()));
    }

    private Either<MailboxCreationParseException, MailboxCreationRequest> parseCreate(JsObject jsObject) {
        return MailboxCreationRequest$.MODULE$.validateProperties(jsObject).flatMap((Function1 & Serializable)validJsObject -> {
            Right right;
            JsResult jsResult = Json$.MODULE$.fromJson((JsValue)validJsObject, $this.serializer.mailboxCreationRequest());
            if (jsResult instanceof JsSuccess) {
                JsSuccess jsSuccess = (JsSuccess)jsResult;
                MailboxCreationRequest creationRequest = (MailboxCreationRequest)jsSuccess.value();
                right = package$.MODULE$.Right().apply((Object)creationRequest);
            } else if (jsResult instanceof JsError) {
                JsError jsError = (JsError)jsResult;
                Seq errors = jsError.errors();
                right = package$.MODULE$.Left().apply((Object)new MailboxCreationParseException(this.mailboxSetError((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)errors)));
            } else {
                throw new MatchError((Object)jsResult);
            }
            return right;
        });
    }

    private Either<Exception, MailboxPath> resolvePath(MailboxSession mailboxSession, MailboxCreationRequest mailboxCreationRequest) {
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(mailboxCreationRequest.name()), mailboxSession.getPathDelimiter())) {
            return package$.MODULE$.Left().apply((Object)new MailboxNameException(new StringBuilder(48).append("The mailbox '").append(mailboxCreationRequest.name()).append("' contains an illegal character: '").append(mailboxSession.getPathDelimiter()).append("'").toString()));
        }
        return (Either)mailboxCreationRequest.parentId().map((Function1 & Serializable)maybeParentId -> Try$.MODULE$.apply((Function0 & Serializable)() -> $this.mailboxIdFactory.fromString((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)maybeParentId.id()), RefType$.MODULE$.refinedRefType()))).toEither().left().map((Function1 & Serializable)e -> new IllegalArgumentException(e.getMessage(), (Throwable)e)).flatMap((Function1 & Serializable)parentId -> this.retrievePath((MailboxId)parentId, mailboxSession).map((Function1 & Serializable)parentPath -> parentPath.child((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)mailboxCreationRequest.name()), RefType$.MODULE$.refinedRefType()), mailboxSession.getPathDelimiter())))).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Right().apply((Object)MailboxPath.forUser((Username)mailboxSession.getUser(), (String)((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)mailboxCreationRequest.name()), RefType$.MODULE$.refinedRefType())))));
    }

    private Either<Exception, MailboxPath> retrievePath(MailboxId mailboxId, MailboxSession mailboxSession) {
        Left left;
        try {
            left = package$.MODULE$.Right().apply((Object)this.mailboxManager.getMailbox(mailboxId, mailboxSession).getMailboxPath());
        }
        catch (Exception e) {
            left = package$.MODULE$.Left().apply((Object)e);
        }
        return left;
    }

    private Either<IllegalArgumentException, ProcessingContext> recordCreationIdInProcessingContext(MailboxCreationId mailboxCreationId, ProcessingContext processingContext, MailboxId mailboxId) {
        return Id$.MODULE$.validate(mailboxId.serialize()).map((Function1 & Serializable)serverAssignedId -> processingContext.recordCreatedId(new ClientId(mailboxCreationId.id()), new ServerId((String)((Refined)serverAssignedId).value())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SetError mailboxSetError(Seq<Tuple2<JsPath, Seq<JsonValidationError>>> errors) {
        Tuple2 tuple2 = (Tuple2)errors.head();
        if (tuple2 != null) {
            JsPath path = (JsPath)tuple2._1();
            Seq seq = (Seq)tuple2._2();
            if (seq instanceof scala.collection.immutable.Seq) {
                scala.collection.immutable.Seq seq2 = (scala.collection.immutable.Seq)seq;
                SeqOps seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq2);
                if (!SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0) {
                    return SetError$.MODULE$.invalidArguments(new StringBuilder(42).append("'").append(path).append("' property in mailbox object is not valid").toString(), SetError$.MODULE$.invalidArguments$default$2());
                }
            }
        }
        if (tuple2 != null) {
            JsPath path = (JsPath)tuple2._1();
            Seq seq = (Seq)tuple2._2();
            if (seq instanceof scala.collection.immutable.Seq) {
                String string2;
                SeqOps seqOps;
                scala.collection.immutable.Seq seq3;
                JsonValidationError jsonValidationError;
                scala.collection.immutable.Seq seq4 = (scala.collection.immutable.Seq)seq;
                SeqOps seqOps2 = package$.MODULE$.Seq().unapplySeq((SeqOps)seq4);
                if (!SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0 && (jsonValidationError = (JsonValidationError)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0)) != null && jsonValidationError.args() != null && jsonValidationError.args().lengthCompare(0) == 0 && (seq3 = jsonValidationError.messages()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq3)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && "error.path.missing".equals(string2 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0))) {
                    return SetError$.MODULE$.invalidArguments(new StringBuilder(37).append("Missing '").append(path).append("' property in mailbox object").toString(), SetError$.MODULE$.invalidArguments$default$2());
                }
            }
        }
        if (tuple2 != null) {
            JsPath path = (JsPath)tuple2._1();
            Seq seq = (Seq)tuple2._2();
            if (seq instanceof scala.collection.immutable.Seq) {
                SeqOps seqOps;
                scala.collection.immutable.Seq seq5;
                JsonValidationError jsonValidationError;
                scala.collection.immutable.Seq seq6 = (scala.collection.immutable.Seq)seq;
                SeqOps seqOps3 = package$.MODULE$.Seq().unapplySeq((SeqOps)seq6);
                if (!SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1) == 0 && (jsonValidationError = (JsonValidationError)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0)) != null && jsonValidationError.args() != null && jsonValidationError.args().lengthCompare(0) == 0 && (seq5 = jsonValidationError.messages()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq5)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
                    String message = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                    return SetError$.MODULE$.invalidArguments(new StringBuilder(44).append("'").append(path).append("' property in mailbox object is not valid: ").append(message).toString(), SetError$.MODULE$.invalidArguments$default$2());
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        JsPath path = (JsPath)tuple2._1();
        return SetError$.MODULE$.invalidArguments(new StringBuilder(28).append("Unknown error on property '").append(path).append("'").toString(), SetError$.MODULE$.invalidArguments$default$2());
    }

    private Either<Exception, MailboxCreationResponse> createMailbox(MailboxSession mailboxSession, MailboxPath path, MailboxCreationRequest mailboxCreationRequest) {
        Left left;
        try {
            MailboxId mailboxId = (MailboxId)this.mailboxManager.createMailbox(path, mailboxSession).get();
            boolean defaultSubscribed = true;
            if (((IsSubscribed)mailboxCreationRequest.isSubscribed().getOrElse((Function0 & Serializable)() -> new IsSubscribed(defaultSubscribed))).value()) {
                this.subscriptionManager.subscribe(mailboxSession, path.getName());
            }
            mailboxCreationRequest.rights().foreach((Function1 & Serializable)rights -> {
                this.mailboxManager.setRights(mailboxId, rights.toMailboxAcl().asJava(), mailboxSession);
                return BoxedUnit.UNIT;
            });
            SMono qual$1 = this.quotaFactory.loadFor(mailboxSession).flatMap((Function1 & Serializable)quotaLoader -> quotaLoader.getQuotas(path));
            Duration x$1 = qual$1.block$default$1();
            Map<QuotaId, Quota> quotas = ((Quotas)qual$1.block(x$1)).quotas();
            MailboxId x$2 = mailboxId;
            SortOrder x$3 = SortOrder$.MODULE$.defaultSortOrder();
            None$ x$4 = None$.MODULE$;
            TotalEmails x$5 = new TotalEmails((Long)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToLong((long)0L))).value());
            UnreadEmails x$6 = new UnreadEmails((Long)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToLong((long)0L))).value());
            TotalThreads x$7 = new TotalThreads((Long)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToLong((long)0L))).value());
            UnreadThreads x$8 = new UnreadThreads((Long)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)BoxesRunTime.boxToLong((long)0L))).value());
            MailboxRights x$9 = MailboxRights$.MODULE$.FULL();
            Some x$10 = new Some((Object)new Quotas(quotas));
            None$ x$11 = mailboxCreationRequest.isSubscribed().isEmpty() ? new Some((Object)new IsSubscribed(defaultSubscribed)) : None$.MODULE$;
            left = package$.MODULE$.Right().apply((Object)new MailboxCreationResponse(x$2, (Option<Role>)x$4, x$3, x$5, x$6, x$7, x$8, x$9, (Option<Quotas>)x$10, (Option<IsSubscribed>)x$11));
        }
        catch (Exception error) {
            left = package$.MODULE$.Left().apply((Object)error);
        }
        return left;
    }

    @Inject
    public MailboxSetCreatePerformer(MailboxSerializer serializer, MailboxManager mailboxManager, SubscriptionManager subscriptionManager, MailboxId.Factory mailboxIdFactory, QuotaLoaderWithPreloadedDefaultFactory quotaFactory, MetricFactory metricFactory, SessionSupplier sessionSupplier) {
        this.serializer = serializer;
        this.mailboxManager = mailboxManager;
        this.subscriptionManager = subscriptionManager;
        this.mailboxIdFactory = mailboxIdFactory;
        this.quotaFactory = quotaFactory;
        this.metricFactory = metricFactory;
        this.sessionSupplier = sessionSupplier;
    }

    public static class MailboxCreationFailure
    implements MailboxCreationResult,
    Product,
    Serializable {
        private final MailboxCreationId mailboxCreationId;
        private final Exception exception;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public MailboxCreationId mailboxCreationId() {
            return this.mailboxCreationId;
        }

        public Exception exception() {
            return this.exception;
        }

        public SetError asMailboxSetError() {
            SetError setError;
            Exception exception = this.exception();
            if (exception instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)exception;
                setError = SetError$.MODULE$.invalidArguments(mailboxNotFoundException.getMessage(), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((scala.collection.immutable.Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            } else if (exception instanceof MailboxExistsException) {
                MailboxExistsException mailboxExistsException = (MailboxExistsException)((Object)exception);
                setError = SetError$.MODULE$.invalidArguments(mailboxExistsException.getMessage(), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((scala.collection.immutable.Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value()))}))));
            } else if (exception instanceof MailboxNameException) {
                MailboxNameException mailboxNameException = (MailboxNameException)exception;
                setError = SetError$.MODULE$.invalidArguments(mailboxNameException.getMessage(), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((scala.collection.immutable.Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value()))}))));
            } else if (exception instanceof MailboxCreationParseException) {
                MailboxCreationParseException mailboxCreationParseException = (MailboxCreationParseException)exception;
                setError = mailboxCreationParseException.setError();
            } else {
                setError = exception instanceof InsufficientRightsException ? SetError$.MODULE$.forbidden("Insufficient rights", (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((scala.collection.immutable.Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))})))) : SetError$.MODULE$.serverFail(this.exception().getMessage());
            }
            return setError;
        }

        public MailboxCreationFailure copy(MailboxCreationId mailboxCreationId, Exception exception) {
            return new MailboxCreationFailure(mailboxCreationId, exception);
        }

        public MailboxCreationId copy$default$1() {
            return this.mailboxCreationId();
        }

        public Exception copy$default$2() {
            return this.exception();
        }

        public String productPrefix() {
            return "MailboxCreationFailure";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.mailboxCreationId();
                    break;
                }
                case 1: {
                    object = this.exception();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxCreationFailure;
        }

        public String productElementName(int x$1) {
            String string2;
            int n = x$1;
            switch (n) {
                case 0: {
                    string2 = "mailboxCreationId";
                    break;
                }
                case 1: {
                    string2 = "exception";
                    break;
                }
                default: {
                    string2 = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxCreationFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxCreationFailure mailboxCreationFailure = (MailboxCreationFailure)x$1;
            MailboxCreationId mailboxCreationId = this.mailboxCreationId();
            MailboxCreationId mailboxCreationId2 = mailboxCreationFailure.mailboxCreationId();
            if (mailboxCreationId == null) {
                if (mailboxCreationId2 != null) {
                    return false;
                }
            } else if (!((Object)mailboxCreationId).equals(mailboxCreationId2)) return false;
            Exception exception = this.exception();
            Exception exception2 = mailboxCreationFailure.exception();
            if (exception == null) {
                if (exception2 != null) {
                    return false;
                }
            } else if (!exception.equals(exception2)) return false;
            if (!mailboxCreationFailure.canEqual(this)) return false;
            return true;
        }

        public MailboxCreationFailure(MailboxCreationId mailboxCreationId, Exception exception) {
            this.mailboxCreationId = mailboxCreationId;
            this.exception = exception;
            Product.$init$((Product)this);
        }
    }

    public static interface MailboxCreationResult {
        public MailboxCreationId mailboxCreationId();
    }

    public static class MailboxCreationResults
    implements Product,
    Serializable {
        private final scala.collection.immutable.Seq<MailboxCreationResult> created;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public scala.collection.immutable.Seq<MailboxCreationResult> created() {
            return this.created;
        }

        public Map<MailboxCreationId, MailboxCreationResponse> retrieveCreated() {
            return (Map)((IterableOnceOps)this.created().flatMap((Function1 & Serializable)result -> {
                None$ none$;
                MailboxCreationResult mailboxCreationResult = result;
                if (mailboxCreationResult instanceof MailboxCreationSuccess) {
                    MailboxCreationSuccess mailboxCreationSuccess = (MailboxCreationSuccess)mailboxCreationResult;
                    none$ = new Some((Object)new Tuple2((Object)mailboxCreationSuccess.mailboxCreationId(), (Object)mailboxCreationSuccess.mailboxCreationResponse()));
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)creation -> new Tuple2(creation._1(), creation._2()));
        }

        public Map<MailboxCreationId, SetError> retrieveErrors() {
            return ((IterableOnceOps)this.created().flatMap((Function1 & Serializable)result -> {
                None$ none$;
                MailboxCreationResult mailboxCreationResult = result;
                if (mailboxCreationResult instanceof MailboxCreationFailure) {
                    MailboxCreationFailure mailboxCreationFailure = (MailboxCreationFailure)mailboxCreationResult;
                    none$ = new Some((Object)new Tuple2((Object)mailboxCreationFailure.mailboxCreationId(), (Object)mailboxCreationFailure.asMailboxSetError()));
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public MailboxCreationResults copy(scala.collection.immutable.Seq<MailboxCreationResult> created) {
            return new MailboxCreationResults(created);
        }

        public scala.collection.immutable.Seq<MailboxCreationResult> copy$default$1() {
            return this.created();
        }

        public String productPrefix() {
            return "MailboxCreationResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.created();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxCreationResults;
        }

        public String productElementName(int x$1) {
            String string2;
            int n = x$1;
            switch (n) {
                case 0: {
                    string2 = "created";
                    break;
                }
                default: {
                    string2 = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxCreationResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxCreationResults mailboxCreationResults = (MailboxCreationResults)x$1;
            scala.collection.immutable.Seq<MailboxCreationResult> seq = this.created();
            scala.collection.immutable.Seq<MailboxCreationResult> seq2 = mailboxCreationResults.created();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!mailboxCreationResults.canEqual(this)) return false;
            return true;
        }

        public MailboxCreationResults(scala.collection.immutable.Seq<MailboxCreationResult> created) {
            this.created = created;
            Product.$init$((Product)this);
        }
    }

    public static class MailboxCreationSuccess
    implements MailboxCreationResult,
    Product,
    Serializable {
        private final MailboxCreationId mailboxCreationId;
        private final MailboxCreationResponse mailboxCreationResponse;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        @Override
        public MailboxCreationId mailboxCreationId() {
            return this.mailboxCreationId;
        }

        public MailboxCreationResponse mailboxCreationResponse() {
            return this.mailboxCreationResponse;
        }

        public MailboxCreationSuccess copy(MailboxCreationId mailboxCreationId, MailboxCreationResponse mailboxCreationResponse) {
            return new MailboxCreationSuccess(mailboxCreationId, mailboxCreationResponse);
        }

        public MailboxCreationId copy$default$1() {
            return this.mailboxCreationId();
        }

        public MailboxCreationResponse copy$default$2() {
            return this.mailboxCreationResponse();
        }

        public String productPrefix() {
            return "MailboxCreationSuccess";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.mailboxCreationId();
                    break;
                }
                case 1: {
                    object = this.mailboxCreationResponse();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxCreationSuccess;
        }

        public String productElementName(int x$1) {
            String string2;
            int n = x$1;
            switch (n) {
                case 0: {
                    string2 = "mailboxCreationId";
                    break;
                }
                case 1: {
                    string2 = "mailboxCreationResponse";
                    break;
                }
                default: {
                    string2 = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxCreationSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxCreationSuccess mailboxCreationSuccess = (MailboxCreationSuccess)x$1;
            MailboxCreationId mailboxCreationId = this.mailboxCreationId();
            MailboxCreationId mailboxCreationId2 = mailboxCreationSuccess.mailboxCreationId();
            if (mailboxCreationId == null) {
                if (mailboxCreationId2 != null) {
                    return false;
                }
            } else if (!((Object)mailboxCreationId).equals(mailboxCreationId2)) return false;
            MailboxCreationResponse mailboxCreationResponse = this.mailboxCreationResponse();
            MailboxCreationResponse mailboxCreationResponse2 = mailboxCreationSuccess.mailboxCreationResponse();
            if (mailboxCreationResponse == null) {
                if (mailboxCreationResponse2 != null) {
                    return false;
                }
            } else if (!((Object)mailboxCreationResponse).equals(mailboxCreationResponse2)) return false;
            if (!mailboxCreationSuccess.canEqual(this)) return false;
            return true;
        }

        public MailboxCreationSuccess(MailboxCreationId mailboxCreationId, MailboxCreationResponse mailboxCreationResponse) {
            this.mailboxCreationId = mailboxCreationId;
            this.mailboxCreationResponse = mailboxCreationResponse;
            Product.$init$((Product)this);
        }
    }
}

