/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.auto$;
import eu.timepit.refined.string;
import java.io.Serializable;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.mail.Message;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.james.jmap.api.model.Identity;
import org.apache.james.jmap.api.model.IdentityId;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.json.MDNSerializer;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.mail.EmailHeaderName$;
import org.apache.james.jmap.mail.EmailSetRequest;
import org.apache.james.jmap.mail.ErrorField;
import org.apache.james.jmap.mail.ExtensionFieldName;
import org.apache.james.jmap.mail.ExtensionFieldValue;
import org.apache.james.jmap.mail.FinalRecipientField;
import org.apache.james.jmap.mail.FinalRecipientField$;
import org.apache.james.jmap.mail.IdentityIdNotFoundException;
import org.apache.james.jmap.mail.IncludeOriginalMessageField;
import org.apache.james.jmap.mail.MDN$;
import org.apache.james.jmap.mail.MDNGatewayField;
import org.apache.james.jmap.mail.MDNId$;
import org.apache.james.jmap.mail.MDNSend$;
import org.apache.james.jmap.mail.MDNSendAlreadySentException;
import org.apache.james.jmap.mail.MDNSendCreateRequest;
import org.apache.james.jmap.mail.MDNSendCreateRequest$;
import org.apache.james.jmap.mail.MDNSendCreateResponse;
import org.apache.james.jmap.mail.MDNSendCreateSuccess;
import org.apache.james.jmap.mail.MDNSendCreationId;
import org.apache.james.jmap.mail.MDNSendForbiddenFromException;
import org.apache.james.jmap.mail.MDNSendNotFoundException;
import org.apache.james.jmap.mail.MDNSendRequest;
import org.apache.james.jmap.mail.MDNSendRequestInvalidException;
import org.apache.james.jmap.mail.MDNSendRequestInvalidException$;
import org.apache.james.jmap.mail.MDNSendResults;
import org.apache.james.jmap.mail.MDNSendResults$;
import org.apache.james.jmap.mail.OriginalMessageIdField;
import org.apache.james.jmap.mail.OriginalRecipientField;
import org.apache.james.jmap.mail.ReportUAField;
import org.apache.james.jmap.mail.ReportUAField$;
import org.apache.james.jmap.mail.SubjectField;
import org.apache.james.jmap.mail.TextBodyField;
import org.apache.james.jmap.mail.TextHeaderValue$;
import org.apache.james.jmap.method.EmailSetMethod;
import org.apache.james.jmap.method.EmailSubmissionSetMethod$;
import org.apache.james.jmap.method.IdentityResolver;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.MethodRequiringAccountId;
import org.apache.james.jmap.routes.ProcessingContext;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mdn.MDN;
import org.apache.james.mdn.MDNReport;
import org.apache.james.mdn.fields.Disposition;
import org.apache.james.mdn.fields.Error;
import org.apache.james.mdn.fields.ExtensionField;
import org.apache.james.mdn.fields.FinalRecipient;
import org.apache.james.mdn.fields.OriginalRecipient;
import org.apache.james.mdn.fields.Text;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.field.AddressListField;
import org.apache.james.mime4j.field.AddressListFieldLenientImpl;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.server.core.MailImpl;
import org.apache.mailet.Mail;
import org.reactivestreams.Publisher;
import play.api.libs.json.JsError;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.JsonValidationError;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\r\u0005f\u0001B\u0014)\u0001MB\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"Aq\r\u0001B\u0001B\u0003%\u0001\u000e\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003p\u0011!\u0011\bA!b\u0001\n\u0003\u0019\b\u0002C<\u0001\u0005\u0003\u0005\u000b\u0011\u0002;\t\u0011a\u0004!Q1A\u0005\u0002eD\u0011\"a\u0001\u0001\u0005\u0003\u0005\u000b\u0011\u0002>\t\u0015\u0005\u0015\u0001A!b\u0001\n\u0003\t9\u0001\u0003\u0006\u0002\u0016\u0001\u0011\t\u0011)A\u0005\u0003\u0013Aq!a\u0006\u0001\t\u0003\tI\u0002C\u0005\u0002F\u0001\u0011\r\u0011\"\u0011\u0002H!A\u0011Q\u000f\u0001!\u0002\u0013\tI\u0005C\u0005\u0002x\u0001\u0011\r\u0011\"\u0011\u0002z!A\u0011\u0011\u0014\u0001!\u0002\u0013\tY\b\u0003\u0006Z\u0001\u0001\u0007\t\u0019!C\u0001\u00037C1\"!(\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002 \"Q\u00111\u0016\u0001A\u0002\u0003\u0005\u000b\u0015\u00023\t\u000f\u00055\u0006\u0001\"\u0001\u00020\"9\u0011\u0011\u0017\u0001\u0005\u0002\u0005=\u0006bBAa\u0001\u0011\u0005\u00131\u0019\u0005\b\u0003k\u0004A\u0011IA|\u0011\u001d\u0011i\u0002\u0001C\u0005\u0005?AqA!\u0016\u0001\t\u0013\u00119\u0006C\u0004\u0003\u0002\u0002!IAa!\t\u000f\tU\u0005\u0001\"\u0003\u0003\u0018\"9!\u0011\u0017\u0001\u0005\n\tM\u0006b\u0002Bc\u0001\u0011%!q\u0019\u0005\b\u0005?\u0004A\u0011\u0002Bq\u0011\u001d\u0011y\u000f\u0001C\u0005\u0005cDqaa\b\u0001\t\u0013\u0019\t\u0003C\u0004\u0004L\u0001!Ia!\u0014\t\u000f\rM\u0003\u0001\"\u0003\u0004V!91\u0011\u000e\u0001\u0005\n\r-\u0004bBB@\u0001\u0011%1\u0011\u0011\u0005\b\u0007\u000b\u0003A\u0011BBD\u0011\u001d\u0019i\t\u0001C\u0005\u0007\u001fCqa!'\u0001\t\u0013\u0019YJA\u0007N\t:\u001bVM\u001c3NKRDw\u000e\u001a\u0006\u0003S)\na!\\3uQ>$'BA\u0016-\u0003\u0011QW.\u00199\u000b\u00055r\u0013!\u00026b[\u0016\u001c(BA\u00181\u0003\u0019\t\u0007/Y2iK*\t\u0011'A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001ii\"\u0005CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$AB!osJ+g\rE\u0002<yyj\u0011\u0001K\u0005\u0003{!\u0012\u0001$T3uQ>$'+Z9vSJLgnZ!dG>,h\u000e^%e!\ty$)D\u0001A\u0015\t\t%&\u0001\u0003nC&d\u0017BA\"A\u00059iEIT*f]\u0012\u0014V-];fgR\u0004\"!\u0012&\u000e\u0003\u0019S!a\u0012%\u0002\u0007\u0005\u0004\u0018N\u0003\u0002JY\u0005IA.\u001b4fGf\u001cG.Z\u0005\u0003\u0017\u001a\u0013\u0011b\u0015;beR\f'\r\\3\u0002\u0015M,'/[1mSj,'\u000f\u0005\u0002O#6\tqJ\u0003\u0002QU\u0005!!n]8o\u0013\t\u0011vJA\u0007N\t:\u001bVM]5bY&TXM]\u0001\u0011[\u0006LG.U;fk\u00164\u0015m\u0019;pef\u0004$!\u00160\u0011\u0007YSF,D\u0001X\u0015\t9\u0005L\u0003\u0002ZY\u0005)\u0011/^3vK&\u00111l\u0016\u0002\u0011\u001b\u0006LG.U;fk\u00164\u0015m\u0019;pef\u0004\"!\u00180\r\u0001\u0011IqLAA\u0001\u0002\u0003\u0015\t\u0001\u0019\u0002\u0004?\u0012\n\u0014CA1e!\t)$-\u0003\u0002dm\t9aj\u001c;iS:<\u0007C\u0001,f\u0013\t1wKA\u0005NC&d\u0017+^3vK\u0006\u0001R.Z:tC\u001e,\u0017\nZ'b]\u0006<WM\u001d\t\u0003S2l\u0011A\u001b\u0006\u0003W2\nq!\\1jY\n|\u00070\u0003\u0002nU\n\u0001R*Z:tC\u001e,\u0017\nZ'b]\u0006<WM]\u0001\u000fK6\f\u0017\u000e\\*fi6+G\u000f[8e!\tY\u0004/\u0003\u0002rQ\tqQ)\\1jYN+G/T3uQ>$\u0017\u0001E5eK:$\u0018\u000e^=SKN|GN^3s+\u0005!\bCA\u001ev\u0013\t1\bF\u0001\tJI\u0016tG/\u001b;z%\u0016\u001cx\u000e\u001c<fe\u0006\t\u0012\u000eZ3oi&$\u0018PU3t_24XM\u001d\u0011\u0002\u001b5,GO]5d\r\u0006\u001cGo\u001c:z+\u0005Q\bCA>\u0000\u001b\u0005a(BA$~\u0015\tqH&A\u0004nKR\u0014\u0018nY:\n\u0007\u0005\u0005APA\u0007NKR\u0014\u0018n\u0019$bGR|'/_\u0001\u000f[\u0016$(/[2GC\u000e$xN]=!\u0003=\u0019Xm]:j_:\u001cV\u000f\u001d9mS\u0016\u0014XCAA\u0005!\u0011\tY!!\u0005\u000e\u0005\u00055!bAA\bU\u00051!o\\;uKNLA!a\u0005\u0002\u000e\ty1+Z:tS>t7+\u001e9qY&,'/\u0001\ttKN\u001c\u0018n\u001c8TkB\u0004H.[3sA\u00051A(\u001b8jiz\"\u0002#a\u0007\u0002\u001e\u0005}\u0011\u0011FA\u0016\u0003[\ty#!\r\u0011\u0005m\u0002\u0001\"\u0002'\f\u0001\u0004i\u0005BB*\f\u0001\u0004\t\t\u0003\r\u0003\u0002$\u0005\u001d\u0002\u0003\u0002,[\u0003K\u00012!XA\u0014\t)y\u0016qDA\u0001\u0002\u0003\u0015\t\u0001\u0019\u0005\u0006O.\u0001\r\u0001\u001b\u0005\u0006].\u0001\ra\u001c\u0005\u0006e.\u0001\r\u0001\u001e\u0005\u0006q.\u0001\rA\u001f\u0005\b\u0003\u000bY\u0001\u0019AA\u0005Q\rY\u0011Q\u0007\t\u0005\u0003o\t\t%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003\u0019IgN[3di*\u0011\u0011qH\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003\u0007\nID\u0001\u0004J]*,7\r^\u0001\u000b[\u0016$\bn\u001c3OC6,WCAA%!\u0011\tY%a\u001c\u000f\t\u00055\u0013\u0011\u000e\b\u0005\u0003\u001f\n)G\u0004\u0003\u0002R\u0005\rd\u0002BA*\u0003CrA!!\u0016\u0002`9!\u0011qKA/\u001b\t\tIFC\u0002\u0002\\I\na\u0001\u0010:p_Rt\u0014\"A\u0019\n\u0005=\u0002\u0014BA\u0017/\u0013\tYC&C\u0002\u0002h)\nAaY8sK&!\u00111NA7\u0003)IeN^8dCRLwN\u001c\u0006\u0004\u0003OR\u0013\u0002BA9\u0003g\u0012!\"T3uQ>$g*Y7f\u0015\u0011\tY'!\u001c\u0002\u00175,G\u000f[8e\u001d\u0006lW\rI\u0001\u0015e\u0016\fX/\u001b:fI\u000e\u000b\u0007/\u00192jY&$\u0018.Z:\u0016\u0005\u0005m\u0004CBA?\u0003\u000b\u000bYI\u0004\u0003\u0002\u0000\u0005\u0005\u0005cAA,m%\u0019\u00111\u0011\u001c\u0002\rA\u0013X\rZ3g\u0013\u0011\t9)!#\u0003\u0007M+GOC\u0002\u0002\u0004Z\u0002B!!$\u0002\u0014:!\u0011QJAH\u0013\u0011\t\t*!\u001c\u0002)\r\u000b\u0007/\u00192jY&$\u00180\u00133f]RLg-[3s\u0013\u0011\t)*a&\u0003)\r\u000b\u0007/\u00192jY&$\u00180\u00133f]RLg-[3s\u0015\u0011\t\t*!\u001c\u0002+I,\u0017/^5sK\u0012\u001c\u0015\r]1cS2LG/[3tAU\tA-A\u0005rk\u0016,Xm\u0018\u0013fcR!\u0011\u0011UAT!\r)\u00141U\u0005\u0004\u0003K3$\u0001B+oSRD\u0001\"!+\u0012\u0003\u0003\u0005\r\u0001Z\u0001\u0004q\u0012\n\u0014AB9vKV,\u0007%\u0001\u0003j]&$XCAAQ\u0003\u001d!\u0017n\u001d9pg\u0016D3\u0001FA[!\u0011\t9,!0\u000e\u0005\u0005e&\u0002BA^\u0003{\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty,!/\u0003\u0015A\u0013X\rR3tiJ|\u00170A\u0005e_B\u0013xnY3tgRQ\u0011QYAp\u0003G\f9/!=\u0011\r\u0005\u001d\u0017Q[Am\u001b\t\tIM\u0003\u0003\u0002L\u00065\u0017!\u00039vE2L7\u000f[3s\u0015\r9\u0014q\u001a\u0006\u0005\u0003O\n\tN\u0003\u0002\u0002T\u00069!/Z1di>\u0014\u0018\u0002BAl\u0003\u0013\u0014Qa\u0015$mkb\u00042aOAn\u0013\r\ti\u000e\u000b\u0002\u0016\u0013:4xnY1uS>tw+\u001b;i\u0007>tG/\u001a=u\u0011\u001d\t\t/\u0006a\u0001\u0003w\nAbY1qC\nLG.\u001b;jKNDq!!:\u0016\u0001\u0004\tI.\u0001\u0006j]Z|7-\u0019;j_:Dq!!;\u0016\u0001\u0004\tY/\u0001\bnC&d'm\u001c=TKN\u001c\u0018n\u001c8\u0011\u0007%\fi/C\u0002\u0002p*\u0014a\"T1jY\n|\u0007pU3tg&|g\u000e\u0003\u0004\u0002tV\u0001\rAP\u0001\be\u0016\fX/Z:u\u0003)9W\r\u001e*fcV,7\u000f\u001e\u000b\u0007\u0003s\u0014\tBa\u0005\u0011\u000f\u0005m(Q\u0001B\u0006}9!\u0011Q B\u0001\u001d\u0011\t9&a@\n\u0003]J1Aa\u00017\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0002\u0003\n\t1Q)\u001b;iKJT1Aa\u00017!\u0011\tYP!\u0004\n\t\t=!\u0011\u0002\u0002\n\u000bb\u001cW\r\u001d;j_:Dq!!;\u0017\u0001\u0004\tY\u000fC\u0004\u0002fZ\u0001\rA!\u0006\u0011\t\t]!\u0011D\u0007\u0003\u0003[JAAa\u0007\u0002n\tQ\u0011J\u001c<pG\u0006$\u0018n\u001c8\u0002\r\r\u0014X-\u0019;f))\u0011\tC!\u000f\u0003L\t5#\u0011\u000b\t\u0007\u0003\u000f\u0014\u0019Ca\n\n\t\t\u0015\u0012\u0011\u001a\u0002\u0006'6{gn\u001c\t\bk\t%\"Q\u0006B\u001a\u0013\r\u0011YC\u000e\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007}\u0012y#C\u0002\u00032\u0001\u0013a\"\u0014#O'\u0016tGMU3tk2$8\u000f\u0005\u0003\u0002\f\tU\u0012\u0002\u0002B\u001c\u0003\u001b\u0011\u0011\u0003\u0015:pG\u0016\u001c8/\u001b8h\u0007>tG/\u001a=u\u0011\u001d\u0011Yd\u0006a\u0001\u0005{\t\u0001\"\u001b3f]RLG/\u001f\t\u0005\u0005\u007f\u00119%\u0004\u0002\u0003B)!!1\tB#\u0003\u0015iw\u000eZ3m\u0015\t9%&\u0003\u0003\u0003J\t\u0005#\u0001C%eK:$\u0018\u000e^=\t\r\u0005Mx\u00031\u0001?\u0011\u001d\u0011ye\u0006a\u0001\u0003W\fqa]3tg&|g\u000eC\u0004\u0003T]\u0001\rAa\r\u0002#A\u0014xnY3tg&twmQ8oi\u0016DH/A\u0007de\u0016\fG/Z'E\u001dN+g\u000e\u001a\u000b\r\u0005O\u0011IFa\u0017\u0003^\t\u001d$q\u0010\u0005\b\u0005\u001fB\u0002\u0019AAv\u0011\u001d\u0011Y\u0004\u0007a\u0001\u0005{AqAa\u0018\u0019\u0001\u0004\u0011\t'A\tnI:\u001cVM\u001c3De\u0016\fG/[8o\u0013\u0012\u00042a\u0010B2\u0013\r\u0011)\u0007\u0011\u0002\u0012\u001b\u0012s5+\u001a8e\u0007J,\u0017\r^5p]&#\u0007b\u0002B51\u0001\u0007!1N\u0001\tUN|%M[3diB!!Q\u000eB>\u001b\t\u0011yGC\u0002Q\u0005cRAAa\u001d\u0003v\u0005!A.\u001b2t\u0015\r9%q\u000f\u0006\u0003\u0005s\nA\u0001\u001d7bs&!!Q\u0010B8\u0005!Q5o\u00142kK\u000e$\bb\u0002B*1\u0001\u0007!1G\u0001\u0010a\u0006\u00148/Z'E\u001dJ+\u0017/^3tiR!!Q\u0011BJ!!\tYP!\u0002\u0003\b\n5\u0005cA \u0003\n&\u0019!1\u0012!\u0003=5#ejU3oIJ+\u0017/^3ti&sg/\u00197jI\u0016C8-\u001a9uS>t\u0007cA \u0003\u0010&\u0019!\u0011\u0013!\u0003)5#ejU3oI\u000e\u0013X-\u0019;f%\u0016\fX/Z:u\u0011\u001d\u0011I'\u0007a\u0001\u0005W\nqa]3oI6#e\n\u0006\u0006\u0003\u001a\n\u001d&\u0011\u0016BV\u0005[\u0003\u0002\"a?\u0003\u0006\tm%\u0011\u0015\t\u0005\u0003w\u0014i*\u0003\u0003\u0003 \n%!!\u0003+ie><\u0018M\u00197f!\ry$1U\u0005\u0004\u0005K\u0003%\u0001F'E\u001dN+g\u000eZ\"sK\u0006$XmU;dG\u0016\u001c8\u000fC\u0004\u0003Pi\u0001\r!a;\t\u000f\tm\"\u00041\u0001\u0003>!9!q\f\u000eA\u0002\t\u0005\u0004b\u0002BX5\u0001\u0007!QR\u0001\re\u0016\fX/Z:u\u000b:$(/_\u0001\bK:\fX/Z;f)\u0011\t\tK!.\t\r\u0005[\u0002\u0019\u0001B\\!\u0011\u0011IL!1\u000e\u0005\tm&\u0002BA4\u0005{S1Aa0-\u0003\u0019\u0019XM\u001d<fe&!!1\u0019B^\u0005!i\u0015-\u001b7J[Bd\u0017\u0001\b:fiJLWM^3SK2\fG/\u001a3NKN\u001c\u0018mZ3SKN,H\u000e\u001e\u000b\u0007\u0005\u0013\u0014YN!8\u0011\u0011\u0005m(Q\u0001Bf\u0005#\u00042a\u0010Bg\u0013\r\u0011y\r\u0011\u0002\u0019\u001b\u0012s5+\u001a8e\u001d>$hi\\;oI\u0016C8-\u001a9uS>t\u0007\u0003\u0002Bj\u0005/l!A!6\u000b\u0007\t\r#.\u0003\u0003\u0003Z\nU'!D'fgN\fw-\u001a*fgVdG\u000fC\u0004\u0003Pq\u0001\r!a;\t\u000f\t=F\u00041\u0001\u0003\u000e\u0006Ib/\u00197jI\u0006$X-\u0014#O\u001d>$\u0018\t\u001c:fC\u0012L8+\u001a8u)\u0011\u0011\u0019Oa;\u0011\u0011\u0005m(Q\u0001Bs\u0005#\u00042a\u0010Bt\u0013\r\u0011I\u000f\u0011\u0002\u001c\u001b\u0012s5+\u001a8e\u00032\u0014X-\u00193z'\u0016tG/\u0012=dKB$\u0018n\u001c8\t\u000f\t5X\u00041\u0001\u0003R\u0006!\"/\u001a7bi\u0016$W*Z:tC\u001e,'+Z:vYR\fACY;jY\u0012l\u0015-\u001b7B]\u0012\u0014Vm\u001d9p]N,GC\u0003Bz\u0005{\u0014yp!\u0003\u0004\fAA\u00111 B\u0003\u00057\u0013)\u0010E\u00046\u0005S\u00119La>\u0011\u0007}\u0012I0C\u0002\u0003|\u0002\u0013Q#\u0014#O'\u0016tGm\u0011:fCR,'+Z:q_:\u001cX\rC\u0004\u0003<y\u0001\rA!\u0010\t\u000f\r\u0005a\u00041\u0001\u0004\u0004\u000511/\u001a8eKJ\u0004B!! \u0004\u0006%!1qAAE\u0005\u0019\u0019FO]5oO\"9!q\u0016\u0010A\u0002\t5\u0005bBB\u0007=\u0001\u00071qB\u0001\u0010_JLw-\u001b8bY6+7o]1hKB!1\u0011CB\u000e\u001b\t\u0019\u0019B\u0003\u0003\u0004\u0016\r]\u0011a\u00013p[*\u00191\u0011\u0004\u0017\u0002\r5LW.\u001a\u001bk\u0013\u0011\u0019iba\u0005\u0003\u000f5+7o]1hK\u00069\"-^5mI6\u000b\u0017\u000e\\!oI6KW.Z'fgN\fw-\u001a\u000b\u000b\u0007G\u0019\u0019d!\u000e\u0004:\ru\u0002cB\u001b\u0003*\t]6Q\u0005\t\u0005\u0007O\u0019y#\u0004\u0002\u0004*)!11FB\u0017\u0003!Ig\u000e^3s]\u0016$(bA!\u0002>%!1\u0011GB\u0015\u0005-i\u0015.\\3NKN\u001c\u0018mZ3\t\u000f\r\u0005q\u00041\u0001\u0004\u0004!91qG\u0010A\u0002\r\r\u0011!\u0003:fG&\u0004\u0018.\u001a8u\u0011\u001d\u0019Yd\ba\u0001\u0007\u0007\tqa];cU\u0016\u001cG\u000fC\u0004\u0004@}\u0001\ra!\u0011\u0002\u00075$g\u000e\u0005\u0003\u0004D\r\u001dSBAB#\u0015\r\u0019y\u0004L\u0005\u0005\u0007\u0013\u001a)EA\u0002N\t:\u000b\u0001cZ3u\u001b\u0006LGNU3dSBLWM\u001c;\u0015\t\r=3\u0011\u000b\t\t\u0003w\u0014)Aa3\u0004\u0004!91Q\u0002\u0011A\u0002\r=\u0011\u0001F4fi6#eJR5oC2\u0014VmY5qS\u0016tG\u000f\u0006\u0004\u0004X\r\u00154q\r\t\t\u0003w\u0014)Aa'\u0004ZA!11LB1\u001b\t\u0019iF\u0003\u0003\u0004`\r\u0015\u0013A\u00024jK2$7/\u0003\u0003\u0004d\ru#A\u0004$j]\u0006d'+Z2ja&,g\u000e\u001e\u0005\b\u0005_\u000b\u0003\u0019\u0001BG\u0011\u001d\u0011Y$\ta\u0001\u0005{\t\u0001BY;jY\u0012lEI\u0014\u000b\u000b\u0007\u0003\u001aiga\u001c\u0004r\rU\u0004b\u0002BXE\u0001\u0007!Q\u0012\u0005\b\u0007\u001b\u0011\u0003\u0019AB\b\u0011\u001d\u0019\u0019H\ta\u0001\u00073\naBZ5oC2\u0014VmY5qS\u0016tG\u000fC\u0004\u0004x\t\u0002\ra!\u001f\u0002#=\u0014\u0018nZ5oC2\u0014VmY5qS\u0016tG\u000f\u0005\u0003\u0004\\\rm\u0014\u0002BB?\u0007;\u0012\u0011c\u0014:jO&t\u0017\r\u001c*fG&\u0004\u0018.\u001a8u\u0003e\u0011W/\u001b7e\u001b\u0012s\u0005*^7b]J+\u0017\rZ1cY\u0016$V\r\u001f;\u0015\t\r\r11\u0011\u0005\b\u0005_\u001b\u0003\u0019\u0001BG\u0003M\u0011W/\u001b7e\u001b\u0016\u001c8/Y4f'V\u0014'.Z2u)\u0019\u0019\u0019a!#\u0004\f\"9!q\u0016\u0013A\u0002\t5\u0005bBB\u0007I\u0001\u00071qB\u0001\u001bEVLG\u000eZ'E\u001dN+g\u000eZ\"sK\u0006$XMU3ta>t7/\u001a\u000b\t\u0005o\u001c\tja%\u0004\u0016\"9!qV\u0013A\u0002\t5\u0005bBB K\u0001\u00071\u0011\t\u0005\b\u0007/+\u0003\u0019AB\u0013\u0003-i\u0017.\\3NKN\u001c\u0018mZ3\u0002\u001dA\f'o]3Bg6+7o]1hKR!1qBBO\u0011\u001d\u0019yJ\na\u0001\u0005#\fa\"\\3tg\u0006<WMU3mCR,G\r")
public class MDNSendMethod
implements MethodRequiringAccountId<MDNSendRequest>,
Startable {
    private final MDNSerializer serializer;
    private final MailQueueFactory<? extends MailQueue> mailQueueFactory;
    private final MessageIdManager messageIdManager;
    private final EmailSetMethod emailSetMethod;
    private final IdentityResolver identityResolver;
    private final MetricFactory metricFactory;
    private final SessionSupplier sessionSupplier;
    private final Invocation.MethodName methodName;
    private final Set<Refined<String, string.Uri>> requiredCapabilities;
    private MailQueue queue;
    private String JMAP_RFC8621_PREFIX;

    @Override
    public Publisher<InvocationWithContext> process(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return MethodRequiringAccountId.process$(this, capabilities, invocation, mailboxSession);
    }

    @Override
    public String JMAP_RFC8621_PREFIX() {
        return this.JMAP_RFC8621_PREFIX;
    }

    @Override
    public void org$apache$james$jmap$method$Method$_setter_$JMAP_RFC8621_PREFIX_$eq(String x$1) {
        this.JMAP_RFC8621_PREFIX = x$1;
    }

    public IdentityResolver identityResolver() {
        return this.identityResolver;
    }

    @Override
    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    @Override
    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    @Override
    public Invocation.MethodName methodName() {
        return this.methodName;
    }

    @Override
    public Set<Refined<String, string.Uri>> requiredCapabilities() {
        return this.requiredCapabilities;
    }

    public MailQueue queue() {
        return this.queue;
    }

    public void queue_$eq(MailQueue x$1) {
        this.queue = x$1;
    }

    public void init() {
        this.queue_$eq(this.mailQueueFactory.createQueue(MailQueueFactory.SPOOL));
    }

    @PreDestroy
    public void dispose() {
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.queue().close()).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 e, Function1<A1, B1> function1) {
                A1 A1 = e;
                EmailSubmissionSetMethod$.MODULE$.LOGGER().debug("error closing queue", e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Throwable e) {
                Throwable throwable = e;
                boolean bl = true;
                return bl;
            }
        });
    }

    public SFlux<InvocationWithContext> doProcess(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession, MDNSendRequest request) {
        return ((SMono)request.identityId().validate().fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)new IllegalArgumentException("The IdentityId cannot be found", (Throwable)e)), (Function1 & Serializable)id -> this.identityResolver().resolveIdentityId((IdentityId)id, mailboxSession))).flatMap((Function1 & Serializable)maybeIdentity -> (SMono)maybeIdentity.map((Function1 & Serializable)identity -> this.create((Identity)identity, request, mailboxSession, invocation.processingContext())).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.error((Throwable)new IdentityIdNotFoundException("The IdentityId cannot be found")))).flatMapMany((Function1 & Serializable)createdResults -> {
            InvocationWithContext explicitInvocation = new InvocationWithContext(new Invocation(invocation.invocation().methodName(), (JsObject)$this.serializer.serializeMDNSendResponse(((MDNSendResults)createdResults._1()).asResponse(request.accountId())).as((Reads)Reads$.MODULE$.JsObjectReads()), invocation.invocation().methodCallId()), (ProcessingContext)createdResults._2());
            SMono emailSetCall = (SMono)request.implicitEmailSetRequest((Function1<MDNSendCreationId, Either<IllegalArgumentException, Option<MessageId>>>)(Function1 & Serializable)sendId -> ((MDNSendResults)createdResults._1()).resolveMessageId((MDNSendCreationId)sendId)).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)maybeEmailSetRequest -> (SMono)maybeEmailSetRequest.map((Function1 & Serializable)emailSetRequest -> $this.emailSetMethod.doProcess(capabilities, invocation, mailboxSession, (EmailSetRequest)emailSetRequest)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty()));
            return SFlux$.MODULE$.concat((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Publisher[]{SMono$.MODULE$.just((Object)explicitInvocation), emailSetCall}));
        });
    }

    @Override
    public Either<Exception, MDNSendRequest> getRequest(MailboxSession mailboxSession, Invocation invocation) {
        Left left;
        JsResult<MDNSendRequest> jsResult = this.serializer.deserializeMDNSendRequest((JsValue)invocation.arguments());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            MDNSendRequest mdnSendRequest = (MDNSendRequest)jsSuccess.value();
            left = mdnSendRequest.validate();
        } else if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            left = package$.MODULE$.Left().apply((Object)new IllegalArgumentException(Json$.MODULE$.stringify(ResponseSerializer$.MODULE$.serialize(jsError))));
        } else {
            throw new MatchError(jsResult);
        }
        return left;
    }

    private SMono<Tuple2<MDNSendResults, ProcessingContext>> create(Identity identity, MDNSendRequest request, MailboxSession session, ProcessingContext processingContext) {
        return SFlux$.MODULE$.fromIterable((Iterable)request.send().view()).fold((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MDNSendResults$.MODULE$.empty()), (Object)processingContext), (Function2 & Serializable)(acc, elem) -> {
            Tuple2 tuple2 = elem;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MDNSendCreationId mdnSendId = (MDNSendCreationId)tuple2._1();
            JsObject jsObject = (JsObject)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)mdnSendId, (Object)jsObject);
            Tuple2 tuple23 = tuple22;
            MDNSendCreationId mdnSendId2 = (MDNSendCreationId)tuple23._1();
            JsObject jsObject2 = (JsObject)tuple23._2();
            Tuple2<MDNSendResults, ProcessingContext> tuple24 = this.createMDNSend(session, identity, mdnSendId2, jsObject2, (ProcessingContext)acc._2());
            if (tuple24 == null) {
                throw new MatchError(tuple24);
            }
            MDNSendResults creationResult = (MDNSendResults)tuple24._1();
            ProcessingContext updatedProcessingContext = (ProcessingContext)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)creationResult, (Object)updatedProcessingContext);
            Tuple2 tuple26 = tuple25;
            MDNSendResults creationResult2 = (MDNSendResults)tuple26._1();
            ProcessingContext updatedProcessingContext2 = (ProcessingContext)tuple26._2();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MDNSendResults$.MODULE$.merge((MDNSendResults)acc._1(), creationResult2)), (Object)updatedProcessingContext2);
        }).subscribeOn(Schedulers.elastic());
    }

    private Tuple2<MDNSendResults, ProcessingContext> createMDNSend(MailboxSession session, Identity identity, MDNSendCreationId mdnSendCreationId, JsObject jsObject, ProcessingContext processingContext) {
        return (Tuple2)this.parseMDNRequest(jsObject).flatMap((Function1 & Serializable)createRequest -> this.sendMDN(session, identity, mdnSendCreationId, (MDNSendCreateRequest)createRequest)).fold((Function1 & Serializable)error -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MDNSendResults$.MODULE$.notSent(mdnSendCreationId, (Throwable)error)), (Object)processingContext), (Function1 & Serializable)creation -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MDNSendResults$.MODULE$.sent((MDNSendCreateSuccess)creation)), (Object)processingContext));
    }

    private Either<MDNSendRequestInvalidException, MDNSendCreateRequest> parseMDNRequest(JsObject jsObject) {
        return MDNSendCreateRequest$.MODULE$.validateProperties(jsObject).flatMap((Function1 & Serializable)validJson -> {
            Left left;
            JsResult<MDNSendCreateRequest> jsResult = $this.serializer.deserializeMDNSendCreateRequest((JsValue)validJson);
            if (jsResult instanceof JsSuccess) {
                JsSuccess jsSuccess = (JsSuccess)jsResult;
                MDNSendCreateRequest createRequest = (MDNSendCreateRequest)jsSuccess.value();
                left = createRequest.validate();
            } else if (jsResult instanceof JsError) {
                JsError jsError = (JsError)jsResult;
                Seq errors = jsError.errors();
                left = package$.MODULE$.Left().apply((Object)MDNSendRequestInvalidException$.MODULE$.parse((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)errors));
            } else {
                throw new MatchError(jsResult);
            }
            return left;
        });
    }

    private Either<Throwable, MDNSendCreateSuccess> sendMDN(MailboxSession session, Identity identity, MDNSendCreationId mdnSendCreationId, MDNSendCreateRequest requestEntry) {
        return this.retrieveRelatedMessageResult(session, requestEntry).flatMap((Function1 & Serializable)mdnRelatedMessageResult -> this.validateMDNNotAlreadySent((MessageResult)mdnRelatedMessageResult).map((Function1 & Serializable)mdnRelatedMessageResultAlready -> {
            Message messageRelated = this.parseAsMessage((MessageResult)mdnRelatedMessageResultAlready);
            return new Tuple2(mdnRelatedMessageResultAlready, (Object)messageRelated);
        }).flatMap((Function1 & Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MessageResult mdnRelatedMessageResultAlready = (MessageResult)tuple2._1();
            Message messageRelated = (Message)tuple2._2();
            Either either = this.buildMailAndResponse(identity, session.getUser().asString(), requestEntry, messageRelated).flatMap((Function1 & Serializable)mailAndResponseAndId -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.enqueue((MailImpl)mailAndResponseAndId._1())).toEither().map((Function1 & Serializable)x$4 -> {
                BoxedUnit boxedUnit = x$4;
                MDNSendCreateSuccess mDNSendCreateSuccess = new MDNSendCreateSuccess(mdnSendCreationId, (MDNSendCreateResponse)mailAndResponseAndId._2(), mdnRelatedMessageResultAlready.getMessageId());
                return mDNSendCreateSuccess;
            }));
            return either;
        }));
    }

    private void enqueue(MailImpl mail) {
        try {
            this.queue().enQueue((Mail)mail);
        }
        finally {
            LifecycleUtil.dispose((Object)mail);
        }
    }

    private Either<MDNSendNotFoundException, MessageResult> retrieveRelatedMessageResult(MailboxSession session, MDNSendCreateRequest requestEntry) {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.messageIdManager.getMessage(requestEntry.forEmailId(), FetchGroup.FULL_CONTENT, session)).asScala().toList().headOption().toRight((Function0 & Serializable)() -> new MDNSendNotFoundException("The reference \"forEmailId\" cannot be found."));
    }

    private Either<MDNSendAlreadySentException, MessageResult> validateMDNNotAlreadySent(MessageResult relatedMessageResult) {
        return relatedMessageResult.getFlags().contains(MDNSend$.MODULE$.MDN_ALREADY_SENT_FLAG()) ? package$.MODULE$.Left().apply((Object)new MDNSendAlreadySentException()) : package$.MODULE$.Right().apply((Object)relatedMessageResult);
    }

    private Either<Throwable, Tuple2<MailImpl, MDNSendCreateResponse>> buildMailAndResponse(Identity identity, String sender, MDNSendCreateRequest requestEntry, Message originalMessage) {
        return this.getMailRecipient(originalMessage).flatMap((Function1 & Serializable)mailRecipient -> this.getMDNFinalRecipient(requestEntry, identity).map((Function1 & Serializable)mdnFinalRecipient -> {
            OriginalRecipient mdnOriginalRecipient = OriginalRecipient.builder().originalRecipient(Text.fromRawText((String)sender)).build();
            MDN mdn = this.buildMDN(requestEntry, originalMessage, (FinalRecipient)mdnFinalRecipient, mdnOriginalRecipient);
            String subject = this.buildMessageSubject(requestEntry, originalMessage);
            Tuple2<MailImpl, MimeMessage> tuple2 = this.buildMailAndMimeMessage(sender, (String)mailRecipient, subject, mdn);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            MailImpl mailImpl = (MailImpl)tuple2._1();
            MimeMessage mimeMessage = (MimeMessage)tuple2._2();
            Tuple3 tuple3 = new Tuple3(tuple2, (Object)mailImpl, (Object)mimeMessage);
            Tuple3 tuple32 = tuple3;
            Tuple2 x$6 = (Tuple2)tuple32._1();
            MailImpl mailImpl2 = (MailImpl)tuple32._2();
            MimeMessage mimeMessage2 = (MimeMessage)tuple32._3();
            return new Tuple5(mdnFinalRecipient, (Object)mdnOriginalRecipient, (Object)mdn, (Object)subject, (Object)x$6);
        }).map((Function1 & Serializable)x$8 -> {
            Tuple2 tuple2;
            MDN mdn;
            block3: {
                Tuple5 tuple5;
                block2: {
                    tuple5 = x$8;
                    if (tuple5 == null) break block2;
                    mdn = (MDN)tuple5._3();
                    tuple2 = (Tuple2)tuple5._5();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple5);
            }
            MailImpl mailImpl = (MailImpl)tuple2._1();
            MimeMessage mimeMessage = (MimeMessage)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)mailImpl, (Object)this.buildMDNSendCreateResponse(requestEntry, mdn, mimeMessage));
            return tuple22;
        }));
    }

    private Tuple2<MailImpl, MimeMessage> buildMailAndMimeMessage(String sender, String recipient, String subject, MDN mdn) {
        MimeMessage mimeMessage = mdn.asMimeMessage();
        mimeMessage.setFrom(sender);
        mimeMessage.setRecipients(Message.RecipientType.TO, recipient);
        mimeMessage.setSubject(subject);
        mimeMessage.saveChanges();
        MailImpl mailImpl = MailImpl.builder().name((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)MDNId$.MODULE$.generate().value()), RefType$.MODULE$.refinedRefType())).sender(sender).addRecipient(recipient).mimeMessage(mimeMessage).build();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mailImpl), (Object)mimeMessage);
    }

    private Either<MDNSendNotFoundException, String> getMailRecipient(Message originalMessage) {
        return CollectionConverters$.MODULE$.ListHasAsScala(originalMessage.getHeader().getFields(MDN$.MODULE$.DISPOSITION_NOTIFICATION_TO())).asScala().headOption().map((Function1 & Serializable)field -> (AddressListField)AddressListFieldLenientImpl.PARSER.parse(field, new DecodeMonitor())).map((Function1 & Serializable)addressListField -> addressListField.getAddressList()).map((Function1 & Serializable)addressList -> addressList.flatten()).flatMap((Function1 & Serializable)mailboxList -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mailboxList.stream().findAny()))).map((Function1 & Serializable)mailbox -> mailbox.getAddress()).toRight((Function0 & Serializable)() -> new MDNSendNotFoundException("Invalid \"Disposition-Notification-To\" header field."));
    }

    private Either<Throwable, FinalRecipient> getMDNFinalRecipient(MDNSendCreateRequest requestEntry, Identity identity) {
        return (Either)requestEntry.finalRecipient().map((Function1 & Serializable)finalRecipient -> MDNSendMethod.$anonfun$getMDNFinalRecipient$1(((FinalRecipientField)finalRecipient).value())).map((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            Right right = null;
            Either either = x0$1;
            if (either instanceof Right) {
                bl = true;
                right = (Right)either;
                MailAddress mailAddress = (MailAddress)right.value();
                if (mailAddress.equals((Object)identity.email())) {
                    return package$.MODULE$.Right().apply(FinalRecipientField$.MODULE$.asJava$extension(((FinalRecipientField)requestEntry.finalRecipient().get()).value()).get());
                }
            }
            if (bl) {
                return package$.MODULE$.Left().apply((Object)new MDNSendForbiddenFromException("The user is not allowed to use the given \"finalRecipient\" property"));
            }
            if (!(either instanceof Left)) throw new MatchError((Object)either);
            Left left = (Left)either;
            Throwable error = (Throwable)left.value();
            return package$.MODULE$.Left().apply((Object)error);
        }).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Right().apply((Object)FinalRecipient.builder().finalRecipient(Text.fromRawText((String)identity.email().asString())).build()));
    }

    private MDN buildMDN(MDNSendCreateRequest requestEntry, Message originalMessage, FinalRecipient finalRecipient, OriginalRecipient originalRecipient) {
        MDNReport.Builder reportBuilder = MDNReport.builder().dispositionField((Disposition)requestEntry.disposition().asJava().get()).finalRecipientField(finalRecipient).originalRecipientField(originalRecipient);
        CollectionConverters$.MODULE$.ListHasAsScala(originalMessage.getHeader().getFields("Message-ID")).asScala().map((Function1 & Serializable)field -> reportBuilder.originalMessageIdField(field.getBody()));
        requestEntry.reportingUA().map((Function1 & Serializable)uaField -> MDNSendMethod.$anonfun$buildMDN$2(reportBuilder, ((ReportUAField)uaField).value()));
        requestEntry.extensionFields().map((Function1 & Serializable)extensions -> (scala.collection.immutable.Iterable)extensions.map((Function1 & Serializable)extension2 -> reportBuilder.withExtensionField(ExtensionField.builder().fieldName(((ExtensionFieldName)extension2._1()).value()).rawValue(((ExtensionFieldValue)extension2._2()).value()).build())));
        CollectionConverters$.MODULE$.ListHasAsScala(originalMessage.getHeader().getFields(EmailHeaderName$.MODULE$.MESSAGE_ID())).asScala().headOption().map((Function1 & Serializable)messageIdHeader -> reportBuilder.originalMessageIdField(TextHeaderValue$.MODULE$.from((Field)messageIdHeader).value()));
        return MDN.builder().report(reportBuilder.build()).humanReadableText(this.buildMDNHumanReadableText(requestEntry)).message(OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(requestEntry.includeOriginalMessage().filter((Function1 & Serializable)isInclude -> BoxesRunTime.boxToBoolean((boolean)((IncludeOriginalMessageField)isInclude).value())).map((Function1 & Serializable)x$9 -> originalMessage)))).build();
    }

    private String buildMDNHumanReadableText(MDNSendCreateRequest requestEntry) {
        return (String)requestEntry.textBody().map((Function1 & Serializable)textBody -> ((TextBodyField)textBody).value()).getOrElse((Function0 & Serializable)() -> new StringBuilder(48).append("The email has been ").append(requestEntry.disposition().type()).append(" on your recipient's computer").toString());
    }

    private String buildMessageSubject(MDNSendCreateRequest requestEntry, Message originalMessage) {
        return (String)requestEntry.subject().map((Function1 & Serializable)subject -> ((SubjectField)subject).value()).getOrElse((Function0 & Serializable)() -> new StringBuilder(11).append("[Received] ").append(originalMessage.getSubject()).toString());
    }

    private MDNSendCreateResponse buildMDNSendCreateResponse(MDNSendCreateRequest requestEntry, MDN mdn, MimeMessage mimeMessage) {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        None$ none$5;
        Option<SubjectField> option = requestEntry.subject();
        if (option instanceof Some) {
            none$5 = None$.MODULE$;
        } else if (None$.MODULE$.equals(option)) {
            none$5 = new Some((Object)new SubjectField(mimeMessage.getSubject()));
        } else {
            throw new MatchError(option);
        }
        None$ x$1 = none$5;
        Option<TextBodyField> option2 = requestEntry.textBody();
        if (option2 instanceof Some) {
            none$4 = None$.MODULE$;
        } else if (None$.MODULE$.equals(option2)) {
            none$4 = new Some((Object)new TextBodyField(mdn.getHumanReadableText()));
        } else {
            throw new MatchError(option2);
        }
        None$ x$2 = none$4;
        Option<ReportUAField> option3 = requestEntry.reportingUA();
        if (option3 instanceof Some) {
            none$3 = None$.MODULE$;
        } else if (None$.MODULE$.equals(option3)) {
            none$3 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mdn.getReport().getReportingUserAgentField().map(ua -> new ReportUAField(ua.fieldValue()))));
        } else {
            throw new MatchError(option3);
        }
        None$ x$3 = none$3;
        Option x$4 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mdn.getReport().getGatewayField().map(gateway -> new MDNGatewayField(gateway.fieldValue()))));
        Option x$5 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mdn.getReport().getOriginalRecipientField().map(originalRecipient -> new OriginalRecipientField(originalRecipient.fieldValue()))));
        Option<IncludeOriginalMessageField> option4 = requestEntry.includeOriginalMessage();
        if (option4 instanceof Some) {
            none$2 = None$.MODULE$;
        } else if (None$.MODULE$.equals(option4)) {
            none$2 = new Some((Object)new IncludeOriginalMessageField(mdn.getOriginalMessage().isPresent()));
        } else {
            throw new MatchError(option4);
        }
        None$ x$6 = none$2;
        Option x$7 = Option$.MODULE$.apply((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(mdn.getReport().getErrorFields()).asScala().map((Function1 & Serializable)error -> new ErrorField(MDNSendMethod.$anonfun$buildMDNSendCreateResponse$4(error)))).toSeq()).filter((Function1 & Serializable)error -> BoxesRunTime.boxToBoolean((boolean)error.nonEmpty()));
        Option<FinalRecipientField> option5 = requestEntry.finalRecipient();
        if (option5 instanceof Some) {
            none$ = None$.MODULE$;
        } else if (None$.MODULE$.equals(option5)) {
            none$ = new Some((Object)new FinalRecipientField(mdn.getReport().getFinalRecipientField().fieldValue()));
        } else {
            throw new MatchError(option5);
        }
        None$ x$8 = none$;
        Option x$9 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mdn.getReport().getOriginalMessageIdField().map(originalMessageId -> new OriginalMessageIdField(originalMessageId.getOriginalMessageId()))));
        return new MDNSendCreateResponse((Option<SubjectField>)x$1, (Option<TextBodyField>)x$2, (Option<ReportUAField>)x$3, (Option<MDNGatewayField>)x$4, (Option<OriginalRecipientField>)x$5, (Option<FinalRecipientField>)x$8, (Option<IncludeOriginalMessageField>)x$6, (Option<OriginalMessageIdField>)x$9, (Option<scala.collection.immutable.Seq<ErrorField>>)x$7);
    }

    private Message parseAsMessage(MessageResult messageRelated) {
        DefaultMessageBuilder messageBuilder = new DefaultMessageBuilder();
        messageBuilder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
        messageBuilder.setDecodeMonitor(DecodeMonitor.SILENT);
        return messageBuilder.parseMessage(messageRelated.getFullContent().getInputStream());
    }

    public static final /* synthetic */ Either $anonfun$getMDNFinalRecipient$1(String finalRecipient) {
        return FinalRecipientField$.MODULE$.getMailAddress$extension(finalRecipient).toEither();
    }

    public static final /* synthetic */ Try $anonfun$buildMDN$2(MDNReport.Builder reportBuilder$1, String uaField) {
        return ReportUAField$.MODULE$.asJava$extension(uaField).map((Function1 & Serializable)reportingUserAgent -> reportBuilder$1.reportingUserAgentField(reportingUserAgent));
    }

    public static final /* synthetic */ String $anonfun$buildMDNSendCreateResponse$4(Error error) {
        return error.getText().formatted();
    }

    @Inject
    public MDNSendMethod(MDNSerializer serializer, MailQueueFactory<? extends MailQueue> mailQueueFactory, MessageIdManager messageIdManager, EmailSetMethod emailSetMethod, IdentityResolver identityResolver, MetricFactory metricFactory, SessionSupplier sessionSupplier) {
        this.serializer = serializer;
        this.mailQueueFactory = mailQueueFactory;
        this.messageIdManager = messageIdManager;
        this.emailSetMethod = emailSetMethod;
        this.identityResolver = identityResolver;
        this.metricFactory = metricFactory;
        this.sessionSupplier = sessionSupplier;
        Method.$init$(this);
        MethodRequiringAccountId.$init$(this);
        this.methodName = new Invocation.MethodName((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"MDN/send")).value());
        this.requiredCapabilities = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_MDN()), new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_MAIL()), new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_CORE())}));
        Statics.releaseFence();
    }
}

