/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.mail.Mailbox;
import org.apache.james.jmap.mail.MailboxACL$;
import org.apache.james.jmap.mail.MailboxNamespace;
import org.apache.james.jmap.mail.MailboxRights;
import org.apache.james.jmap.mail.MailboxRights$;
import org.apache.james.jmap.mail.MailboxValidation;
import org.apache.james.jmap.mail.MailboxValidation$;
import org.apache.james.jmap.mail.NamespaceFactory;
import org.apache.james.jmap.mail.Quota;
import org.apache.james.jmap.mail.QuotaId;
import org.apache.james.jmap.mail.Quotas;
import org.apache.james.jmap.mail.Rfc4314Rights$;
import org.apache.james.jmap.mail.Right;
import org.apache.james.jmap.mail.Right$;
import org.apache.james.jmap.mail.Rights;
import org.apache.james.jmap.mail.Rights$;
import org.apache.james.jmap.mail.SortOrder;
import org.apache.james.jmap.mail.SortOrder$;
import org.apache.james.jmap.mail.Subscriptions;
import org.apache.james.jmap.mail.TotalEmails;
import org.apache.james.jmap.mail.TotalThreads;
import org.apache.james.jmap.mail.UnreadEmails;
import org.apache.james.jmap.mail.UnreadThreads;
import org.apache.james.jmap.utils.quotas.QuotaLoader;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005-f\u0001\u0002\b\u0010\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!)Q\u0006\u0001C\u0001]!)1\b\u0001C\u0005y!)\u0001\u000b\u0001C\u0005#\")q\u000b\u0001C\u00051\")\u0011\r\u0001C\u0005E\")\u0001\u000e\u0001C\u0005S\")Q\u000e\u0001C\u0005]\"9\u0011\u0011\u0002\u0001\u0005\n\u0005-\u0001bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\b\u00033\u0001A\u0011AA=\u0011\u001d\tY\t\u0001C\u0005\u0003\u001b\u0013a\"T1jY\n|\u0007PR1di>\u0014\u0018P\u0003\u0002\u0011#\u0005!Q.Y5m\u0015\t\u00112#\u0001\u0003k[\u0006\u0004(B\u0001\u000b\u0016\u0003\u0015Q\u0017-\\3t\u0015\t1r#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00021\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\u0007\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0002\u001d5\f\u0017\u000e\u001c2pq6\u000bg.Y4feB\u00111EJ\u0007\u0002I)\u0011QeE\u0001\b[\u0006LGNY8y\u0013\t9CE\u0001\bNC&d'm\u001c=NC:\fw-\u001a:\u0002!9\fW.Z:qC\u000e,g)Y2u_JL\bC\u0001\u0016,\u001b\u0005y\u0011B\u0001\u0017\u0010\u0005Aq\u0015-\\3ta\u0006\u001cWMR1di>\u0014\u00180\u0001\u0004=S:LGO\u0010\u000b\u0004_A\n\u0004C\u0001\u0016\u0001\u0011\u0015\t3\u00011\u0001#\u0011\u0015A3\u00011\u0001*Q\t\u00191\u0007\u0005\u00025s5\tQG\u0003\u00027o\u00051\u0011N\u001c6fGRT\u0011\u0001O\u0001\u0006U\u00064\u0018\r_\u0005\u0003uU\u0012a!\u00138kK\u000e$\u0018aB4fiJ{G.\u001a\u000b\u0004{\r[\u0005c\u0001\u000f?\u0001&\u0011q(\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\r\n\u0015B\u0001\"%\u0005\u0011\u0011v\u000e\\3\t\u000b\u0011#\u0001\u0019A#\u0002\u00175\f\u0017\u000e\u001c2pqB\u000bG\u000f\u001b\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\u0012\nQ!\\8eK2L!AS$\u0003\u00175\u000b\u0017\u000e\u001c2pqB\u000bG\u000f\u001b\u0005\u0006\u0019\u0012\u0001\r!T\u0001\u000f[\u0006LGNY8y'\u0016\u001c8/[8o!\t\u0019c*\u0003\u0002PI\tqQ*Y5mE>D8+Z:tS>t\u0017\u0001D4fiN{'\u000f^(sI\u0016\u0014HC\u0001*V!\tQ3+\u0003\u0002U\u001f\tI1k\u001c:u\u001fJ$WM\u001d\u0005\u0006-\u0016\u0001\r!P\u0001\u0005e>dW-A\u0005hKR\u0014\u0016n\u001a5ugR\u0011\u0011\f\u0018\t\u0003UiK!aW\b\u0003\rIKw\r\u001b;t\u0011\u0015if\u00011\u0001_\u0003E\u0011Xm]8mm\u0016l\u0015-\u001b7c_b\f5\t\u0014\t\u0003\r~K!\u0001Y$\u0003\u00155\u000b\u0017\u000e\u001c2pq\u0006\u001bE*\u0001\u0007hKRt\u0015-\\3ta\u0006\u001cW\rF\u0002dM\u001e\u0004\"A\u000b3\n\u0005\u0015|!\u0001E'bS2\u0014w\u000e\u001f(b[\u0016\u001c\b/Y2f\u0011\u0015!u\u00011\u0001F\u0011\u0015au\u00011\u0001N\u000359W\r\u001e)be\u0016tG\u000fU1uQR\u0019!n\u001b7\u0011\u0007qqT\tC\u0003E\u0011\u0001\u0007Q\tC\u0003M\u0011\u0001\u0007Q*A\u0006bG2,e\u000e\u001e:z\u0017\u0016LHcA8\u0002\bA\u0019\u0001/!\u0001\u000f\u0005EthB\u0001:~\u001d\t\u0019HP\u0004\u0002uw:\u0011QO\u001f\b\u0003mfl\u0011a\u001e\u0006\u0003qf\ta\u0001\u0010:p_Rt\u0014\"\u0001\r\n\u0005Y9\u0012B\u0001\u000b\u0016\u0013\t)3#\u0003\u0002II%\u0011qpR\u0001\u000b\u001b\u0006LGNY8y\u0003\u000ec\u0015\u0002BA\u0002\u0003\u000b\u0011\u0001\"\u00128uef\\U-\u001f\u0006\u0003\u007f\u001eCQ\u0001T\u0005A\u00025\u000b1bZ3u\u001bf\u0014\u0016n\u001a5ugRA\u0011QBA\n\u0003+\t9\u0002E\u0002+\u0003\u001fI1!!\u0005\u0010\u00055i\u0015-\u001b7c_b\u0014\u0016n\u001a5ug\")AI\u0003a\u0001\u000b\")QL\u0003a\u0001=\")AJ\u0003a\u0001\u001b\u000611M]3bi\u0016$B\"!\b\u0002:\u0005\r\u0013QIA(\u0003K\u0002b!a\b\u00020\u0005MRBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\u0013A,(\r\\5tQ\u0016\u0014(b\u0001\u0010\u0002()!\u0011\u0011FA\u0016\u0003\u0011\u0019wN]3\u000b\u0005\u00055\u0012a\u0002:fC\u000e$xN]\u0005\u0005\u0003c\t\tCA\u0003T\u001b>tw\u000eE\u0002+\u0003kI1!a\u000e\u0010\u0005\u001di\u0015-\u001b7c_bDq!a\u000f\f\u0001\u0004\ti$A\bnC&d'm\u001c=NKR\fG)\u0019;b!\r1\u0015qH\u0005\u0004\u0003\u0003:%aD'bS2\u0014w\u000e_'fi\u0006$\u0015\r^1\t\u000b1[\u0001\u0019A'\t\u000f\u0005\u001d3\u00021\u0001\u0002J\u0005i1/\u001e2tGJL\u0007\u000f^5p]N\u00042AKA&\u0013\r\tie\u0004\u0002\u000e'V\u00147o\u0019:jaRLwN\\:\t\u000f\u0005E3\u00021\u0001\u0002T\u0005!\u0012\r\u001c7NC&d'm\u001c=fg6+G/\u00193bi\u0006\u0004b!!\u0016\u0002`\u0005ub\u0002BA,\u00037r1A^A-\u0013\u0005q\u0012bAA/;\u00059\u0001/Y2lC\u001e,\u0017\u0002BA1\u0003G\u00121aU3r\u0015\r\ti&\b\u0005\b\u0003OZ\u0001\u0019AA5\u0003-\tXo\u001c;b\u0019>\fG-\u001a:\u0011\t\u0005-\u0014QO\u0007\u0003\u0003[RA!a\u001c\u0002r\u00051\u0011/^8uCNT1!a\u001d\u0012\u0003\u0015)H/\u001b7t\u0013\u0011\t9(!\u001c\u0003\u0017E+x\u000e^1M_\u0006$WM\u001d\u000b\u000b\u0003;\tY(!\"\u0002\b\u0006%\u0005bBA?\u0019\u0001\u0007\u0011qP\u0001\u0003S\u0012\u00042ARAA\u0013\r\t\u0019i\u0012\u0002\n\u001b\u0006LGNY8y\u0013\u0012DQ\u0001\u0014\u0007A\u00025Cq!a\u001a\r\u0001\u0004\tI\u0007C\u0004\u0002H1\u0001\r!!\u0013\u0002%%t7\u000f^1oG&\fG/Z'bS2\u0014w\u000e\u001f\u000b\u000f\u0003;\ty)!%\u0002\u0014\u0006U\u0015qTAU\u0011\u001d\ti(\u0004a\u0001\u0003\u007fBQ\u0001T\u0007A\u00025Cq!a\u001a\u000e\u0001\u0004\tI\u0007C\u0004\u0002\u00186\u0001\r!!'\u0002\u001d5,7o]1hK6\u000bg.Y4feB\u00191%a'\n\u0007\u0005uEE\u0001\bNKN\u001c\u0018mZ3NC:\fw-\u001a:\t\u000f\u0005\u0005V\u00021\u0001\u0002$\u0006\t2/\u00198ji&TX\rZ\"pk:$XM]:\u0011\u0007\u0019\u000b)+C\u0002\u0002(\u001e\u0013q\"T1jY\n|\u0007pQ8v]R,'o\u001d\u0005\b\u0003\u000fj\u0001\u0019AA%\u0001")
public class MailboxFactory {
    private final MailboxManager mailboxManager;
    private final NamespaceFactory namespaceFactory;

    private Option<Role> getRole(MailboxPath mailboxPath, MailboxSession mailboxSession) {
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(Role.from((String)mailboxPath.getName()).filter(x$1 -> mailboxPath.belongsTo(mailboxSession))));
    }

    private SortOrder getSortOrder(Option<Role> role2) {
        return (SortOrder)role2.map((Function1 & Serializable)role -> SortOrder$.MODULE$.getSortOrder((Role)role)).getOrElse((Function0 & Serializable)() -> SortOrder$.MODULE$.defaultSortOrder());
    }

    private Rights getRights(MailboxACL resolveMailboxACL) {
        return Rights$.MODULE$.fromACL(MailboxACL$.MODULE$.fromJava(resolveMailboxACL));
    }

    private MailboxNamespace getNamespace(MailboxPath mailboxPath, MailboxSession mailboxSession) {
        return this.namespaceFactory.from(mailboxPath, mailboxSession);
    }

    private Option<MailboxPath> getParentPath(MailboxPath mailboxPath, MailboxSession mailboxSession) {
        return ((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(mailboxPath.getHierarchyLevels(mailboxSession.getPathDelimiter())).asScala().reverse()).drop(1)).headOption();
    }

    private MailboxACL.EntryKey aclEntryKey(MailboxSession mailboxSession) {
        return MailboxACL.EntryKey.createUserEntryKey((Username)mailboxSession.getUser());
    }

    private MailboxRights getMyRights(MailboxPath mailboxPath, MailboxACL resolveMailboxACL, MailboxSession mailboxSession) {
        MailboxRights mailboxRights;
        boolean bl = mailboxPath.belongsTo(mailboxSession);
        if (bl) {
            mailboxRights = MailboxRights$.MODULE$.FULL();
        } else if (!bl) {
            Seq<Right> rights = Rfc4314Rights$.MODULE$.fromJava(resolveMailboxACL.getEntries().getOrDefault(this.aclEntryKey(mailboxSession), MailboxACL.NO_RIGHTS)).toRights();
            mailboxRights = new MailboxRights(rights.contains((Object)Right$.MODULE$.Read()), rights.contains((Object)Right$.MODULE$.Insert()), rights.contains((Object)Right$.MODULE$.DeleteMessages()), rights.contains((Object)Right$.MODULE$.Seen()), rights.contains((Object)Right$.MODULE$.Write()), false, false, false, false);
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return mailboxRights;
    }

    public SMono<Mailbox> create(MailboxMetaData mailboxMetaData, MailboxSession mailboxSession, Subscriptions subscriptions, Seq<MailboxMetaData> allMailboxesMetadata, QuotaLoader quotaLoader) {
        SMono sMono;
        MailboxCounters.Sanitized sanitizedCounters = mailboxMetaData.getCounters().sanitize();
        Either<Exception, MailboxValidation> either = MailboxValidation$.MODULE$.validate(mailboxMetaData.getPath(), mailboxSession.getPathDelimiter(), sanitizedCounters.getUnseen(), sanitizedCounters.getUnseen(), sanitizedCounters.getCount(), sanitizedCounters.getCount());
        if (either instanceof Left) {
            Left left = (Left)either;
            Exception error = (Exception)left.value();
            sMono = SMono$.MODULE$.error((Throwable)error);
        } else if (either instanceof scala.util.Right) {
            scala.util.Right right = (scala.util.Right)either;
            MailboxValidation mailboxValidation = (MailboxValidation)right.value();
            sMono = SMono$.MODULE$.fromPublisher(quotaLoader.getQuotas(mailboxMetaData.getPath())).map((Function1 & Serializable)quotas -> MailboxFactory.$anonfun$create$1(this, mailboxMetaData, mailboxSession, allMailboxesMetadata, subscriptions, mailboxValidation, ((Quotas)quotas).quotas()));
        } else {
            throw new MatchError(either);
        }
        return sMono;
    }

    public SMono<Mailbox> create(MailboxId id, MailboxSession mailboxSession, QuotaLoader quotaLoader, Subscriptions subscriptions) {
        return SMono$.MODULE$.apply(this.mailboxManager.getMailboxReactive(id, mailboxSession)).flatMap((Function1 & Serializable)messageManager -> SMono$.MODULE$.apply(messageManager.getMailboxCountersReactive(mailboxSession)).map((Function1 & Serializable)counters -> {
            MailboxCounters.Sanitized sanitizedCounters = counters.sanitize();
            return new Tuple2(counters, (Object)sanitizedCounters);
        }).flatMap((Function1 & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MailboxCounters.Sanitized sanitizedCounters = (MailboxCounters.Sanitized)tuple2._2();
            SMono sMono = this.instanciateMailbox(id, mailboxSession, quotaLoader, (MessageManager)messageManager, (MailboxCounters)sanitizedCounters, subscriptions).map((Function1 & Serializable)mailbox -> mailbox);
            return sMono;
        }));
    }

    private SMono<Mailbox> instanciateMailbox(MailboxId id, MailboxSession mailboxSession, QuotaLoader quotaLoader, MessageManager messageManager, MailboxCounters sanitizedCounters, Subscriptions subscriptions) {
        SMono sMono;
        try {
            SMono sMono2;
            Either<Exception, MailboxValidation> either = MailboxValidation$.MODULE$.validate(messageManager.getMailboxPath(), mailboxSession.getPathDelimiter(), sanitizedCounters.getUnseen(), sanitizedCounters.getUnseen(), sanitizedCounters.getCount(), sanitizedCounters.getCount());
            if (either instanceof Left) {
                Left left = (Left)either;
                Exception error = (Exception)left.value();
                sMono2 = SMono$.MODULE$.error((Throwable)error);
            } else if (either instanceof scala.util.Right) {
                scala.util.Right right = (scala.util.Right)either;
                MailboxValidation mailboxValidation = (MailboxValidation)right.value();
                sMono2 = SMono$.MODULE$.fromPublisher(quotaLoader.getQuotas(messageManager.getMailboxPath())).map((Function1 & Serializable)quotas -> MailboxFactory.$anonfun$instanciateMailbox$1(this, messageManager, mailboxSession, subscriptions, id, mailboxValidation, ((Quotas)quotas).quotas()));
            } else {
                throw new MatchError(either);
            }
            sMono = sMono2;
        }
        catch (Exception error) {
            sMono = SMono$.MODULE$.error((Throwable)error);
        }
        return sMono;
    }

    public static final /* synthetic */ Mailbox $anonfun$create$1(MailboxFactory $this, MailboxMetaData mailboxMetaData$1, MailboxSession mailboxSession$2, Seq allMailboxesMetadata$1, Subscriptions subscriptions$1, MailboxValidation mailboxValidation$1, Map quotas) {
        MailboxId id = mailboxMetaData$1.getId();
        Option<Role> role = $this.getRole(mailboxMetaData$1.getPath(), mailboxSession$2);
        SortOrder sortOrder = $this.getSortOrder(role);
        Rights rights = $this.getRights(mailboxMetaData$1.getResolvedAcls());
        MailboxNamespace namespace = $this.getNamespace(mailboxMetaData$1.getPath(), mailboxSession$2);
        Option<MailboxPath> parentPath = $this.getParentPath(mailboxMetaData$1.getPath(), mailboxSession$2);
        Option parentId = ((IterableOps)((IterableOps)allMailboxesMetadata$1.filter((Function1 & Serializable)otherMetadata -> BoxesRunTime.boxToBoolean((boolean)parentPath.contains((Object)otherMetadata.getPath())))).map((Function1 & Serializable)x$2 -> x$2.getId())).headOption();
        MailboxRights myRights = $this.getMyRights(mailboxMetaData$1.getPath(), mailboxMetaData$1.getResolvedAcls(), mailboxSession$2);
        boolean isSubscribed = subscriptions$1.isSubscribed(mailboxMetaData$1);
        MailboxId x$1 = id;
        String x$22 = mailboxValidation$1.mailboxName();
        Option x$3 = parentId;
        Option<Role> x$4 = role;
        SortOrder x$5 = sortOrder;
        UnreadEmails x$6 = mailboxValidation$1.unreadEmails();
        TotalEmails x$7 = mailboxValidation$1.totalEmails();
        UnreadThreads x$8 = mailboxValidation$1.unreadThreads();
        TotalThreads x$9 = mailboxValidation$1.totalThreads();
        MailboxRights x$10 = myRights;
        MailboxNamespace x$11 = namespace;
        Rights x$12 = rights;
        Map x$13 = quotas;
        boolean x$14 = isSubscribed;
        return new Mailbox(x$1, x$22, (Option<MailboxId>)x$3, x$4, x$5, x$7, x$6, x$9, x$8, x$10, x$14, x$11, x$12, (Map<QuotaId, Quota>)x$13);
    }

    public static final /* synthetic */ Mailbox $anonfun$instanciateMailbox$1(MailboxFactory $this, MessageManager messageManager$2, MailboxSession mailboxSession$4, Subscriptions subscriptions$3, MailboxId id$2, MailboxValidation mailboxValidation$2, Map quotas) {
        MailboxACL resolvedACL = messageManager$2.getResolvedAcl(mailboxSession$4);
        Option<Role> role = $this.getRole(messageManager$2.getMailboxPath(), mailboxSession$4);
        SortOrder sortOrder = $this.getSortOrder(role);
        Rights rights = $this.getRights(resolvedACL);
        MailboxNamespace namespace = $this.getNamespace(messageManager$2.getMailboxPath(), mailboxSession$4);
        Option parentId = $this.getParentPath(messageManager$2.getMailboxPath(), mailboxSession$4).flatMap((Function1 & Serializable)parentPath -> (Option)Try$.MODULE$.apply((Function0 & Serializable)() -> new Some((Object)$this.mailboxManager.getMailbox(parentPath, mailboxSession$4))).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 instanceof MailboxNotFoundException ? None$.MODULE$ : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof MailboxNotFoundException;
                return bl;
            }
        }).get()).map((Function1 & Serializable)x$4 -> x$4.getId());
        MailboxRights myRights = $this.getMyRights(messageManager$2.getMailboxPath(), resolvedACL, mailboxSession$4);
        boolean isSubscribed = subscriptions$3.isSubscribed(messageManager$2.getMailboxPath().getName());
        MailboxId x$1 = id$2;
        String x$2 = mailboxValidation$2.mailboxName();
        Option x$3 = parentId;
        Option<Role> x$42 = role;
        SortOrder x$5 = sortOrder;
        UnreadEmails x$6 = mailboxValidation$2.unreadEmails();
        TotalEmails x$7 = mailboxValidation$2.totalEmails();
        UnreadThreads x$8 = mailboxValidation$2.unreadThreads();
        TotalThreads x$9 = mailboxValidation$2.totalThreads();
        MailboxRights x$10 = myRights;
        MailboxNamespace x$11 = namespace;
        Rights x$12 = rights;
        Map x$13 = quotas;
        boolean x$14 = isSubscribed;
        return new Mailbox(x$1, x$2, (Option<MailboxId>)x$3, x$42, x$5, x$7, x$6, x$9, x$8, x$10, x$14, x$11, x$12, (Map<QuotaId, Quota>)x$13);
    }

    @Inject
    public MailboxFactory(MailboxManager mailboxManager, NamespaceFactory namespaceFactory) {
        this.mailboxManager = mailboxManager;
        this.namespaceFactory = namespaceFactory;
    }
}

