/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.search;

import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Optional;
import org.apache.james.core.MailAddress;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.vault.DeletedMessage;
import org.apache.james.vault.search.FieldName;

public class DeletedMessageField<T> {
    private FieldName fieldName;
    private ValueExtractor<T> valueExtractor;
    static final DeletedMessageField<ZonedDateTime> DELETION_DATE = new DeletedMessageField<ZonedDateTime>(FieldName.DELETION_DATE, ValueExtractor.DELETION_DATE_EXTRACTOR);
    static final DeletedMessageField<ZonedDateTime> DELIVERY_DATE = new DeletedMessageField<ZonedDateTime>(FieldName.DELIVERY_DATE, ValueExtractor.DELIVERY_DATE_EXTRACTOR);
    static final DeletedMessageField<Collection<MailAddress>> RECIPIENTS = new DeletedMessageField<Collection<MailAddress>>(FieldName.RECIPIENTS, ValueExtractor.RECIPIENTS_EXTRACTOR);
    static final DeletedMessageField<MailAddress> SENDER = new DeletedMessageField<MailAddress>(FieldName.SENDER, ValueExtractor.SENDER_EXTRACTOR);
    static final DeletedMessageField<Boolean> HAS_ATTACHMENT = new DeletedMessageField<Boolean>(FieldName.HAS_ATTACHMENT, ValueExtractor.HAS_ATTACHMENT_EXTRACTOR);
    static final DeletedMessageField<Collection<MailboxId>> ORIGIN_MAILBOXES = new DeletedMessageField<Collection<MailboxId>>(FieldName.ORIGIN_MAILBOXES, ValueExtractor.ORIGIN_MAILBOXES_EXTRACTOR);
    static final DeletedMessageField<String> SUBJECT = new DeletedMessageField<String>(FieldName.SUBJECT, ValueExtractor.SUBJECT_EXTRACTOR);

    private DeletedMessageField(FieldName fieldName, ValueExtractor<T> valueExtractor) {
        this.fieldName = fieldName;
        this.valueExtractor = valueExtractor;
    }

    public FieldName fieldName() {
        return this.fieldName;
    }

    ValueExtractor<T> valueExtractor() {
        return this.valueExtractor;
    }

    static interface ValueExtractor<T> {
        public static final ValueExtractor<ZonedDateTime> DELETION_DATE_EXTRACTOR = deletedMessage -> Optional.of(deletedMessage.getDeletionDate());
        public static final ValueExtractor<ZonedDateTime> DELIVERY_DATE_EXTRACTOR = deletedMessage -> Optional.of(deletedMessage.getDeliveryDate());
        public static final ValueExtractor<Collection<MailAddress>> RECIPIENTS_EXTRACTOR = deletedMessage -> Optional.of(deletedMessage.getRecipients());
        public static final ValueExtractor<MailAddress> SENDER_EXTRACTOR = deletedMessage -> deletedMessage.getSender().asOptional();
        public static final ValueExtractor<Boolean> HAS_ATTACHMENT_EXTRACTOR = deletedMessage -> Optional.of(deletedMessage.hasAttachment());
        public static final ValueExtractor<Collection<MailboxId>> ORIGIN_MAILBOXES_EXTRACTOR = deletedMessage -> Optional.of(deletedMessage.getOriginMailboxes());
        public static final ValueExtractor<String> SUBJECT_EXTRACTOR = DeletedMessage::getSubject;

        public Optional<T> extract(DeletedMessage var1);
    }
}

