/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.indexer.ReIndexer;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.mailbox.tools.indexer.ReprocessingContextInformationDTO;
import org.apache.mailbox.tools.indexer.RunningOptionsDTO;
import org.apache.mailbox.tools.indexer.UserReindexingTask;

public class UserReindexingTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    private final ReprocessingContextInformationDTO reprocessingContextInformationDTO;
    private final String user;

    public static AdditionalInformationDTOModule<UserReindexingTask.AdditionalInformation, UserReindexingTaskAdditionalInformationDTO> module(MailboxId.Factory factory) {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(UserReindexingTask.AdditionalInformation.class).convertToDTO(UserReindexingTaskAdditionalInformationDTO.class).toDomainObjectConverter(dto -> new UserReindexingTask.AdditionalInformation(Username.of((String)dto.getUser()), dto.getSuccessfullyReprocessedMailCount(), dto.getFailedReprocessedMailCount(), ReprocessingContextInformationDTO.deserializeFailures(factory, dto.getMessageFailures(), dto.getMailboxFailures().orElse((List<String>)ImmutableList.of())), dto.getTimestamp(), dto.getRunningOptions().map(RunningOptionsDTO::toDomainObject).orElse(ReIndexer.RunningOptions.DEFAULT))).toDTOConverter((details, type) -> new UserReindexingTaskAdditionalInformationDTO(type, details.getUsername(), details.getSuccessfullyReprocessedMailCount(), details.getFailedReprocessedMailCount(), Optional.empty(), Optional.of(ReprocessingContextInformationDTO.serializeFailures(details.failures())), Optional.of((List)details.failures().mailboxFailures().stream().map(MailboxId::serialize).collect(ImmutableList.toImmutableList())), details.timestamp(), Optional.of(RunningOptionsDTO.toDTO(details.getRunningOptions())))).typeName(UserReindexingTask.USER_RE_INDEXING.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    @JsonCreator
    private UserReindexingTaskAdditionalInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="user") String user, @JsonProperty(value="successfullyReprocessedMailCount") int successfullyReprocessedMailCount, @JsonProperty(value="failedReprocessedMailCount") int failedReprocessedMailCount, @JsonProperty(value="failures") Optional<List<ReprocessingContextInformationDTO.ReindexingFailureDTO>> failures, @JsonProperty(value="messageFailures") Optional<List<ReprocessingContextInformationDTO.ReindexingFailureDTO>> messageFailures, @JsonProperty(value="mailboxFailures") Optional<List<String>> mailboxFailures, @JsonProperty(value="timestamp") Instant timestamp, @JsonProperty(value="runningOptions") Optional<RunningOptionsDTO> runningOptions) {
        this.user = user;
        this.reprocessingContextInformationDTO = new ReprocessingContextInformationDTO(type, successfullyReprocessedMailCount, failedReprocessedMailCount, failures, messageFailures, mailboxFailures, timestamp, runningOptions);
    }

    public String getType() {
        return this.reprocessingContextInformationDTO.getType();
    }

    public Instant getTimestamp() {
        return this.reprocessingContextInformationDTO.getTimestamp();
    }

    public String getUser() {
        return this.user;
    }

    public int getSuccessfullyReprocessedMailCount() {
        return this.reprocessingContextInformationDTO.getSuccessfullyReprocessedMailCount();
    }

    public int getFailedReprocessedMailCount() {
        return this.reprocessingContextInformationDTO.getFailedReprocessedMailCount();
    }

    public List<ReprocessingContextInformationDTO.ReindexingFailureDTO> getMessageFailures() {
        return this.reprocessingContextInformationDTO.getMessageFailures();
    }

    public Optional<List<String>> getMailboxFailures() {
        return this.reprocessingContextInformationDTO.getMailboxFailures();
    }

    public Optional<RunningOptionsDTO> getRunningOptions() {
        return this.reprocessingContextInformationDTO.getRunningOptions();
    }
}

