/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.identity;

import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.identity.CustomIdentityDAO;
import org.apache.james.jmap.api.identity.DefaultIdentitySupplier;
import org.apache.james.jmap.api.identity.IdentityCreationRequest;
import org.apache.james.jmap.api.identity.IdentityForbiddenDeleteException;
import org.apache.james.jmap.api.identity.IdentityNotFoundException;
import org.apache.james.jmap.api.identity.IdentityUpdateRequest;
import org.apache.james.jmap.api.identity.IdentityWithOrigin;
import org.apache.james.jmap.api.identity.IdentityWithOrigin$;
import org.apache.james.jmap.api.model.ForbiddenSendFromException;
import org.apache.james.jmap.api.model.Identity;
import org.apache.james.jmap.api.model.IdentityId;
import org.reactivestreams.Publisher;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005mb\u0001\u0002\u0006\f\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tI\u0001\u0011\t\u0011)A\u0005K!)\u0001\u0006\u0001C\u0001S!)a\u0007\u0001C\u0001o!)\u0011\u000b\u0001C\u0001%\")A\u000b\u0001C\u0005+\")1\u0010\u0001C\u0005y\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0002\u0013\u0013\u0012,g\u000e^5usJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0002\r\u001b\u0005A\u0011\u000eZ3oi&$\u0018P\u0003\u0002\u000f\u001f\u0005\u0019\u0011\r]5\u000b\u0005A\t\u0012\u0001\u00026nCBT!AE\n\u0002\u000b)\fW.Z:\u000b\u0005Q)\u0012AB1qC\u000eDWMC\u0001\u0017\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VMZ\u0001\u0012GV\u001cHo\\7JI\u0016tG/\u001b;z\t\u0006|\u0007CA\u0011#\u001b\u0005Y\u0011BA\u0012\f\u0005E\u0019Uo\u001d;p[&#WM\u001c;jif$\u0015iT\u0001\u0010S\u0012,g\u000e^5us\u001a\u000b7\r^8ssB\u0011\u0011EJ\u0005\u0003O-\u0011q\u0003R3gCVdG/\u00133f]RLG/_*vaBd\u0017.\u001a:\u0002\rqJg.\u001b;?)\rQ3\u0006\f\t\u0003C\u0001AQaH\u0002A\u0002\u0001BQ\u0001J\u0002A\u0002\u0015B#a\u0001\u0018\u0011\u0005=\"T\"\u0001\u0019\u000b\u0005E\u0012\u0014AB5oU\u0016\u001cGOC\u00014\u0003\u0015Q\u0017M^1y\u0013\t)\u0004G\u0001\u0004J]*,7\r^\u0001\u0005g\u00064X\rF\u00029\t2\u00032!\u000f\u001f?\u001b\u0005Q$BA\u001e\u0016\u0003=\u0011X-Y2uSZ,7\u000f\u001e:fC6\u001c\u0018BA\u001f;\u0005%\u0001VO\u00197jg\",'\u000f\u0005\u0002@\u00056\t\u0001I\u0003\u0002B\u001b\u0005)Qn\u001c3fY&\u00111\t\u0011\u0002\t\u0013\u0012,g\u000e^5us\")Q\t\u0002a\u0001\r\u0006!Qo]3s!\t9%*D\u0001I\u0015\tI\u0015#\u0001\u0003d_J,\u0017BA&I\u0005!)6/\u001a:oC6,\u0007\"B'\u0005\u0001\u0004q\u0015aD2sK\u0006$\u0018n\u001c8SKF,Xm\u001d;\u0011\u0005\u0005z\u0015B\u0001)\f\u0005]IE-\u001a8uSRL8I]3bi&|gNU3rk\u0016\u001cH/\u0001\u0003mSN$HC\u0001\u001dT\u0011\u0015)U\u00011\u0001G\u0003Ua\u0017n\u001d;TKJ4XM]*fi&#WM\u001c;jif$\"A\u0016>\u0011\u0007]s\u0006-D\u0001Y\u0015\tI&,A\u0005qk\nd\u0017n\u001d5fe*\u0011Ad\u0017\u0006\u0003\u0013rS\u0011!X\u0001\be\u0016\f7\r^8s\u0013\ty\u0006LA\u0003T\u001b>tw\u000e\u0005\u0003\u001bC\u000e\f\u0018B\u00012\u001c\u0005\u0019!V\u000f\u001d7feA\u0019Am\u001b8\u000f\u0005\u0015L\u0007C\u00014\u001c\u001b\u00059'B\u00015\u0018\u0003\u0019a$o\\8u}%\u0011!nG\u0001\u0007!J,G-\u001a4\n\u00051l'aA*fi*\u0011!n\u0007\t\u0003\u000f>L!\u0001\u001d%\u0003\u00175\u000b\u0017\u000e\\!eIJ,7o\u001d\t\u0004e^tdBA:v\u001d\t1G/C\u0001\u001d\u0013\t18$A\u0004qC\u000e\\\u0017mZ3\n\u0005aL(\u0001\u0002'jgRT!A^\u000e\t\u000b\u00153\u0001\u0019\u0001$\u0002%1L7\u000f^\"vgR|W.\u00133f]RLG/\u001f\u000b\u0006{\u0006\u0005\u00111\u0001\t\u0004/zt\u0014BA@Y\u0005\u0015\u0019f\t\\;y\u0011\u0015)u\u00011\u0001G\u0011\u0019\t)a\u0002a\u0001G\u00061\u0012M^1jY\u0006\u0014G.Z'bS2\fE\r\u001a:fgN,7/\u0001\u0004va\u0012\fG/\u001a\u000b\t\u0003\u0017\t\u0019\"!\u0006\u0002 A!\u0011\bPA\u0007!\rQ\u0012qB\u0005\u0004\u0003#Y\"\u0001B+oSRDQ!\u0012\u0005A\u0002\u0019Cq!a\u0006\t\u0001\u0004\tI\"\u0001\u0006jI\u0016tG/\u001b;z\u0013\u0012\u00042aPA\u000e\u0013\r\ti\u0002\u0011\u0002\u000b\u0013\u0012,g\u000e^5us&#\u0007bBA\u0011\u0011\u0001\u0007\u00111E\u0001\u0016S\u0012,g\u000e^5usV\u0003H-\u0019;f%\u0016\fX/Z:u!\r\t\u0013QE\u0005\u0004\u0003OY!!F%eK:$\u0018\u000e^=Va\u0012\fG/\u001a*fcV,7\u000f^\u0001\u0007I\u0016dW\r^3\u0015\r\u0005-\u0011QFA\u0019\u0011\u0019\ty#\u0003a\u0001\r\u0006AQo]3s]\u0006lW\rC\u0004\u00024%\u0001\r!!\u000e\u0002\u0007%$7\u000fE\u0003s\u0003o\tI\"C\u0002\u0002:e\u00141aU3r\u0001")
public class IdentityRepository {
    private final CustomIdentityDAO customIdentityDao;
    private final DefaultIdentitySupplier identityFactory;

    public Publisher<Identity> save(Username user, IdentityCreationRequest creationRequest) {
        return this.identityFactory.userCanSendFrom(user, creationRequest.email()) ? this.customIdentityDao.save(user, creationRequest) : SMono$.MODULE$.error((Throwable)new ForbiddenSendFromException(creationRequest.email()));
    }

    public Publisher<Identity> list(Username user) {
        SFlux qual$1 = this.listServerSetIdentity(user).flatMapMany((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Set mailAddressSet = (Set)tuple2._1();
            List identityList = (List)tuple2._2();
            SFlux sFlux = this.listCustomIdentity(user, (Set<MailAddress>)mailAddressSet).map((Function1 & Serializable)identity -> IdentityWithOrigin$.MODULE$.fromCustom((Identity)identity)).mergeWith((Publisher)SFlux$.MODULE$.fromIterable((Iterable)identityList).map((Function1 & Serializable)identity -> IdentityWithOrigin$.MODULE$.fromServerSet((Identity)identity)));
            return sFlux;
        }).groupBy((Function1 & Serializable)x$8 -> x$8.identity().id());
        Function1 & Serializable x$1 = (Function1 & Serializable)x$9 -> x$9.reduce((Function2 & Serializable)(value1, value2) -> IdentityWithOrigin$.MODULE$.merge((IdentityWithOrigin.IdentityWithOrigin)value1, (IdentityWithOrigin.IdentityWithOrigin)value2));
        int x$2 = qual$1.flatMap$default$2();
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$1, x$2, x$3, x$4).map((Function1 & Serializable)x$10 -> x$10.identity());
    }

    private SMono<Tuple2<Set<MailAddress>, List<Identity>>> listServerSetIdentity(Username user) {
        return SMono$.MODULE$.fromCallable(() -> $this.identityFactory.listIdentities(user)).subscribeOn(Schedulers.elastic()).map((Function1 & Serializable)list -> new Tuple2((Object)list.map((Function1 & Serializable)x$11 -> x$11.email()).toSet(), list));
    }

    private SFlux<Identity> listCustomIdentity(Username user, Set<MailAddress> availableMailAddresses) {
        return SFlux$.MODULE$.fromPublisher(this.customIdentityDao.list(user)).filter((Function1 & Serializable)identity -> BoxesRunTime.boxToBoolean((boolean)availableMailAddresses.contains((Object)identity.email())));
    }

    public Publisher<BoxedUnit> update(Username user, IdentityId identityId, IdentityUpdateRequest identityUpdateRequest) {
        SMono findServerSetIdentity = SMono$.MODULE$.fromCallable(() -> $this.identityFactory.listIdentities(user).find((Function1 & Serializable)identity -> BoxesRunTime.boxToBoolean((boolean)IdentityRepository.$anonfun$update$3(identityId, identity))));
        SMono findCustomIdentity = SMono$.MODULE$.apply(this.customIdentityDao.findByIdentityId(user, identityId)).map((Function1 & Serializable)x$12 -> new Some(x$12)).switchIfEmpty(SMono$.MODULE$.just((Object)None$.MODULE$));
        return SFlux$.MODULE$.zip((Publisher)findServerSetIdentity, (Publisher)findCustomIdentity).next().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                    return SMono$.MODULE$.error((Throwable)new IdentityNotFoundException(identityId));
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (option instanceof Some && option3 instanceof Some) {
                    Some some = (Some)option3;
                    Identity customIdentity = (Identity)some.value();
                    return $this.customIdentityDao.upsert(user, identityUpdateRequest.update(customIdentity));
                }
            }
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option4 = (Option)tuple2._2();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Identity serverSetIdentity = (Identity)some.value();
                    if (None$.MODULE$.equals(option4)) {
                        return SMono$.MODULE$.apply($this.customIdentityDao.save(user, identityId, identityUpdateRequest.asCreationRequest(serverSetIdentity.email())));
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Option option = (Option)tuple2._1();
            Option option5 = (Option)tuple2._2();
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
            if (!(option5 instanceof Some)) throw new MatchError((Object)tuple2);
            Some some = (Some)option5;
            Identity customIdentity = (Identity)some.value();
            return $this.identityFactory.userCanSendFrom(user, customIdentity.email()) ? $this.customIdentityDao.upsert(user, identityUpdateRequest.update(customIdentity)) : SMono$.MODULE$.error((Throwable)new IdentityNotFoundException(identityId));
        }).then();
    }

    public Publisher<BoxedUnit> delete(Username username, Seq<IdentityId> ids2) {
        return SMono$.MODULE$.just(ids2).handle((Function2 & Serializable)(x0$1, x1$1) -> {
            IdentityRepository.$anonfun$delete$1(this, username, x0$1, x1$1);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)ids -> SMono$.MODULE$.fromPublisher($this.customIdentityDao.delete(username, (Seq<IdentityId>)ids))).subscribeOn(Schedulers.elastic());
    }

    public static final /* synthetic */ boolean $anonfun$update$3(IdentityId identityId$1, Identity identity) {
        return identity.id().equals(identityId$1);
    }

    public static final /* synthetic */ void $anonfun$delete$1(IdentityRepository $this, Username username$1, Seq x0$1, SynchronousSink x1$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 != null) {
            Seq ids = (Seq)tuple2._1();
            SynchronousSink sink = (SynchronousSink)tuple2._2();
            if ($this.identityFactory.isServerSetIdentity(username$1, (IdentityId)ids.head())) {
                sink.error((Throwable)new IdentityForbiddenDeleteException((IdentityId)ids.head()));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                sink.next((Object)ids);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    @Inject
    public IdentityRepository(CustomIdentityDAO customIdentityDao, DefaultIdentitySupplier identityFactory) {
        this.customIdentityDao = customIdentityDao;
        this.identityFactory = identityFactory;
    }
}

