/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.collect.HashMultimap;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.queue.api.MailPrioritySupport;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.transport.mailets.remote.delivery.Bouncer;
import org.apache.james.transport.mailets.remote.delivery.DeliveryRunnable;
import org.apache.james.transport.mailets.remote.delivery.RemoteDeliveryConfiguration;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDelivery
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteDelivery.class);
    private DeliveryRunnable deliveryRunnable;
    public static final String NAME_JUNCTION = "-to-";
    private final DNSService dnsServer;
    private final DomainList domainList;
    private final MailQueueFactory<?> queueFactory;
    private final MetricFactory metricFactory;
    private final ThreadState startThreads;
    private MailQueue queue;
    private RemoteDeliveryConfiguration configuration;

    @Inject
    public RemoteDelivery(DNSService dnsServer, DomainList domainList, MailQueueFactory<?> queueFactory, MetricFactory metricFactory) {
        this(dnsServer, domainList, queueFactory, metricFactory, ThreadState.START_THREADS);
    }

    public RemoteDelivery(DNSService dnsServer, DomainList domainList, MailQueueFactory<?> queueFactory, MetricFactory metricFactory, ThreadState startThreads) {
        this.dnsServer = dnsServer;
        this.domainList = domainList;
        this.queueFactory = queueFactory;
        this.metricFactory = metricFactory;
        this.startThreads = startThreads;
    }

    public void init() throws MessagingException {
        this.configuration = new RemoteDeliveryConfiguration(this.getMailetConfig(), this.domainList);
        this.queue = this.queueFactory.createQueue(this.configuration.getOutGoingQueueName());
        this.deliveryRunnable = new DeliveryRunnable(this.queue, this.configuration, this.dnsServer, this.metricFactory, this.getMailetContext(), new Bouncer(this.configuration, this.getMailetContext()));
        if (this.startThreads == ThreadState.START_THREADS) {
            this.deliveryRunnable.start();
        }
    }

    public String getMailetInfo() {
        return "RemoteDelivery Mailet";
    }

    public void service(Mail mail) throws MessagingException {
        if (this.configuration.isDebug()) {
            LOGGER.debug("Remotely delivering mail {}", (Object)mail.getName());
        }
        if (this.configuration.isUsePriority()) {
            mail.setAttribute(MailPrioritySupport.HIGH_PRIORITY_ATTRIBUTE);
        }
        if (!mail.getRecipients().isEmpty()) {
            if (this.configuration.getGatewayServer().isEmpty()) {
                this.serviceNoGateway(mail);
            } else {
                this.serviceWithGateway(mail);
            }
        } else {
            LOGGER.debug("Mail {} from {} has no recipients and can not be remotely delivered", (Object)mail.getName(), (Object)mail.getMaybeSender());
        }
        mail.setState("ghost");
    }

    private void serviceWithGateway(Mail mail) {
        if (this.configuration.isDebug()) {
            LOGGER.debug("Sending mail to {} via {}", (Object)mail.getRecipients(), this.configuration.getGatewayServer());
        }
        try {
            this.queue.enQueue(mail);
        }
        catch (MailQueue.MailQueueException e) {
            LOGGER.error("Unable to queue mail {} for recipients {}", new Object[]{mail.getName(), mail.getRecipients(), e});
        }
    }

    private void serviceNoGateway(Mail mail) {
        String mailName = mail.getName();
        Map<Domain, Collection<MailAddress>> targets = this.groupByServer(mail.getRecipients());
        for (Map.Entry<Domain, Collection<MailAddress>> entry : targets.entrySet()) {
            this.serviceSingleServer(mail, mailName, entry);
        }
    }

    private void serviceSingleServer(Mail mail, String originalName, Map.Entry<Domain, Collection<MailAddress>> entry) {
        if (this.configuration.isDebug()) {
            LOGGER.debug("Sending mail to {} on host {}", entry.getValue(), (Object)entry.getKey());
        }
        mail.setRecipients(entry.getValue());
        mail.setName(originalName + NAME_JUNCTION + entry.getKey().name());
        try {
            this.queue.enQueue(mail);
        }
        catch (MailQueue.MailQueueException e) {
            LOGGER.error("Unable to queue mail {} for recipients {}", new Object[]{mail.getName(), mail.getRecipients(), e});
        }
    }

    private Map<Domain, Collection<MailAddress>> groupByServer(Collection<MailAddress> recipients) {
        HashMultimap groupByServerMultimap = HashMultimap.create();
        for (MailAddress recipient : recipients) {
            groupByServerMultimap.put((Object)recipient.getDomain(), (Object)recipient);
        }
        return groupByServerMultimap.asMap();
    }

    public synchronized void destroy() {
        if (this.startThreads == ThreadState.START_THREADS) {
            this.deliveryRunnable.dispose();
        }
        try {
            this.queue.close();
        }
        catch (IOException e) {
            LOGGER.debug("error closing queue", (Throwable)e);
        }
    }

    public static enum ThreadState {
        START_THREADS,
        DO_NOT_START_THREADS;

    }
}

