/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.auto$;
import eu.timepit.refined.string;
import java.io.Serializable;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.mail.Message;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.james.jmap.api.model.Identity;
import org.apache.james.jmap.api.model.IdentityId;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.json.MDNSerializer;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.mail.EmailHeaderName$;
import org.apache.james.jmap.mail.EmailSetRequest;
import org.apache.james.jmap.mail.ErrorField;
import org.apache.james.jmap.mail.ExtensionFieldName;
import org.apache.james.jmap.mail.ExtensionFieldValue;
import org.apache.james.jmap.mail.FinalRecipientField;
import org.apache.james.jmap.mail.FinalRecipientField$;
import org.apache.james.jmap.mail.IdentityIdNotFoundException;
import org.apache.james.jmap.mail.IncludeOriginalMessageField;
import org.apache.james.jmap.mail.MDN$;
import org.apache.james.jmap.mail.MDNGatewayField;
import org.apache.james.jmap.mail.MDNId$;
import org.apache.james.jmap.mail.MDNSend$;
import org.apache.james.jmap.mail.MDNSendAlreadySentException;
import org.apache.james.jmap.mail.MDNSendCreateRequest;
import org.apache.james.jmap.mail.MDNSendCreateRequest$;
import org.apache.james.jmap.mail.MDNSendCreateResponse;
import org.apache.james.jmap.mail.MDNSendCreateSuccess;
import org.apache.james.jmap.mail.MDNSendCreationId;
import org.apache.james.jmap.mail.MDNSendForbiddenFromException;
import org.apache.james.jmap.mail.MDNSendNotFoundException;
import org.apache.james.jmap.mail.MDNSendRequest;
import org.apache.james.jmap.mail.MDNSendRequestInvalidException;
import org.apache.james.jmap.mail.MDNSendRequestInvalidException$;
import org.apache.james.jmap.mail.MDNSendResults;
import org.apache.james.jmap.mail.MDNSendResults$;
import org.apache.james.jmap.mail.OriginalMessageIdField;
import org.apache.james.jmap.mail.OriginalRecipientField;
import org.apache.james.jmap.mail.ReportUAField;
import org.apache.james.jmap.mail.ReportUAField$;
import org.apache.james.jmap.mail.SubjectField;
import org.apache.james.jmap.mail.TextBodyField;
import org.apache.james.jmap.mail.TextHeaderValue$;
import org.apache.james.jmap.method.EmailSetMethod;
import org.apache.james.jmap.method.EmailSubmissionSetMethod$;
import org.apache.james.jmap.method.IdentityResolver;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.MethodRequiringAccountId;
import org.apache.james.jmap.routes.ProcessingContext;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mdn.MDN;
import org.apache.james.mdn.MDNReport;
import org.apache.james.mdn.fields.Disposition;
import org.apache.james.mdn.fields.Error;
import org.apache.james.mdn.fields.ExtensionField;
import org.apache.james.mdn.fields.FinalRecipient;
import org.apache.james.mdn.fields.OriginalRecipient;
import org.apache.james.mdn.fields.Text;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.field.AddressListField;
import org.apache.james.mime4j.field.AddressListFieldLenientImpl;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.server.core.MailImpl;
import org.apache.mailet.Mail;
import org.reactivestreams.Publisher;
import play.api.libs.json.JsError;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.JsonValidationError;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\ree\u0001\u0002\u0014(\u0001IB\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"Aa\r\u0001B\u0001B\u0003%q\r\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003o\u0011!\t\bA!b\u0001\n\u0003\u0011\b\u0002\u0003<\u0001\u0005\u0003\u0005\u000b\u0011B:\t\u0011]\u0004!Q1A\u0005\u0002aD\u0011\"!\u0001\u0001\u0005\u0003\u0005\u000b\u0011B=\t\u0015\u0005\r\u0001A!b\u0001\n\u0003\t)\u0001\u0003\u0006\u0002\u0014\u0001\u0011\t\u0011)A\u0005\u0003\u000fAq!!\u0006\u0001\t\u0003\t9\u0002C\u0005\u0002D\u0001\u0011\r\u0011\"\u0011\u0002F!A\u00111\u000f\u0001!\u0002\u0013\t9\u0005C\u0005\u0002v\u0001\u0011\r\u0011\"\u0011\u0002x!A\u0011q\u0013\u0001!\u0002\u0013\tI\b\u0003\u0006Y\u0001\u0001\u0007\t\u0019!C\u0001\u00033C1\"a'\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u001e\"Q\u0011\u0011\u0016\u0001A\u0002\u0003\u0005\u000b\u0015B2\t\u000f\u0005-\u0006\u0001\"\u0001\u0002.\"9\u0011q\u0016\u0001\u0005\u0002\u00055\u0006bBA`\u0001\u0011\u0005\u0013\u0011\u0019\u0005\b\u0003g\u0004A\u0011IA{\u0011\u001d\u0011Y\u0002\u0001C\u0005\u0005;AqAa\u0015\u0001\t\u0013\u0011)\u0006C\u0004\u0003\u0000\u0001!IA!!\t\u000f\tM\u0005\u0001\"\u0003\u0003\u0016\"9!q\u0016\u0001\u0005\n\tE\u0006b\u0002Be\u0001\u0011%!1\u001a\u0005\b\u00053\u0004A\u0011\u0002Bn\u0011\u001d\u00199\u0002\u0001C\u0005\u00073Aqaa\u0011\u0001\t\u0013\u0019)\u0005C\u0004\u0004L\u0001!Ia!\u0014\t\u000f\r\u0005\u0004\u0001\"\u0003\u0004d!91q\u000f\u0001\u0005\n\re\u0004bBB?\u0001\u0011%1q\u0010\u0005\b\u0007\u000b\u0003A\u0011BBD\u0011\u001d\u0019\t\n\u0001C\u0005\u0007'\u0013Q\"\u0014#O'\u0016tG-T3uQ>$'B\u0001\u0015*\u0003\u0019iW\r\u001e5pI*\u0011!fK\u0001\u0005U6\f\u0007O\u0003\u0002-[\u0005)!.Y7fg*\u0011afL\u0001\u0007CB\f7\r[3\u000b\u0003A\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u001a:\u0007B\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t1\u0011I\\=SK\u001a\u00042AO\u001e>\u001b\u00059\u0013B\u0001\u001f(\u0005aiU\r\u001e5pIJ+\u0017/^5sS:<\u0017iY2pk:$\u0018\n\u001a\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001&\nA!\\1jY&\u0011!i\u0010\u0002\u000f\u001b\u0012s5+\u001a8e%\u0016\fX/Z:u!\t!\u0015*D\u0001F\u0015\t1u)A\u0002ba&T!\u0001S\u0016\u0002\u00131Lg-Z2zG2,\u0017B\u0001&F\u0005%\u0019F/\u0019:uC\ndW-\u0001\u0006tKJL\u0017\r\\5{KJ\u0004\"!\u0014)\u000e\u00039S!aT\u0015\u0002\t)\u001cxN\\\u0005\u0003#:\u0013Q\"\u0014#O'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018\u0001E7bS2\fV/Z;f\r\u0006\u001cGo\u001c:za\t!V\fE\u0002V3nk\u0011A\u0016\u0006\u0003\r^S!\u0001W\u0016\u0002\u000bE,X-^3\n\u0005i3&\u0001E'bS2\fV/Z;f\r\u0006\u001cGo\u001c:z!\taV\f\u0004\u0001\u0005\u0013y\u0013\u0011\u0011!A\u0001\u0006\u0003y&aA0%cE\u0011\u0001m\u0019\t\u0003i\u0005L!AY\u001b\u0003\u000f9{G\u000f[5oOB\u0011Q\u000bZ\u0005\u0003KZ\u0013\u0011\"T1jYF+X-^3\u0002!5,7o]1hK&#W*\u00198bO\u0016\u0014\bC\u00015l\u001b\u0005I'B\u00016,\u0003\u001di\u0017-\u001b7c_bL!\u0001\\5\u0003!5+7o]1hK&#W*\u00198bO\u0016\u0014\u0018AD3nC&d7+\u001a;NKRDw\u000e\u001a\t\u0003u=L!\u0001]\u0014\u0003\u001d\u0015k\u0017-\u001b7TKRlU\r\u001e5pI\u0006\u0001\u0012\u000eZ3oi&$\u0018PU3t_24XM]\u000b\u0002gB\u0011!\b^\u0005\u0003k\u001e\u0012\u0001#\u00133f]RLG/\u001f*fg>dg/\u001a:\u0002#%$WM\u001c;jif\u0014Vm]8mm\u0016\u0014\b%A\u0007nKR\u0014\u0018n\u0019$bGR|'/_\u000b\u0002sB\u0011!P`\u0007\u0002w*\u0011a\t \u0006\u0003{.\nq!\\3ue&\u001c7/\u0003\u0002\u0000w\niQ*\u001a;sS\u000e4\u0015m\u0019;pef\fa\"\\3ue&\u001cg)Y2u_JL\b%A\btKN\u001c\u0018n\u001c8TkB\u0004H.[3s+\t\t9\u0001\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\ti!K\u0001\u0007e>,H/Z:\n\t\u0005E\u00111\u0002\u0002\u0010'\u0016\u001c8/[8o'V\u0004\b\u000f\\5fe\u0006\u00012/Z:tS>t7+\u001e9qY&,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015!\u0005e\u00111DA\u000f\u0003O\tI#a\u000b\u0002.\u0005=\u0002C\u0001\u001e\u0001\u0011\u0015Y5\u00021\u0001M\u0011\u0019\u00116\u00021\u0001\u0002 A\"\u0011\u0011EA\u0013!\u0011)\u0016,a\t\u0011\u0007q\u000b)\u0003\u0002\u0006_\u0003;\t\t\u0011!A\u0003\u0002}CQAZ\u0006A\u0002\u001dDQ!\\\u0006A\u00029DQ!]\u0006A\u0002MDQa^\u0006A\u0002eDq!a\u0001\f\u0001\u0004\t9\u0001K\u0002\f\u0003g\u0001B!!\u000e\u0002@5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY$\u0001\u0004j]*,7\r\u001e\u0006\u0003\u0003{\tQA[1wCbLA!!\u0011\u00028\t1\u0011J\u001c6fGR\f!\"\\3uQ>$g*Y7f+\t\t9\u0005\u0005\u0003\u0002J\u00055d\u0002BA&\u0003OrA!!\u0014\u0002d9!\u0011qJA1\u001d\u0011\t\t&a\u0018\u000f\t\u0005M\u0013Q\f\b\u0005\u0003+\nY&\u0004\u0002\u0002X)\u0019\u0011\u0011L\u0019\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0014B\u0001\u00180\u0013\taS&\u0003\u0002+W%\u0019\u0011QM\u0015\u0002\t\r|'/Z\u0005\u0005\u0003S\nY'\u0001\u0006J]Z|7-\u0019;j_:T1!!\u001a*\u0013\u0011\ty'!\u001d\u0003\u00155+G\u000f[8e\u001d\u0006lWM\u0003\u0003\u0002j\u0005-\u0014aC7fi\"|GMT1nK\u0002\nAC]3rk&\u0014X\rZ\"ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001cXCAA=!\u0019\tY(a!\u0002\n:!\u0011QPA@!\r\t)&N\u0005\u0004\u0003\u0003+\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0006\u0006\u001d%aA*fi*\u0019\u0011\u0011Q\u001b\u0011\t\u0005-\u0015\u0011\u0013\b\u0005\u0003\u0017\ni)\u0003\u0003\u0002\u0010\u0006-\u0014\u0001F\"ba\u0006\u0014\u0017\u000e\\5us&#WM\u001c;jM&,'/\u0003\u0003\u0002\u0014\u0006U%\u0001F\"ba\u0006\u0014\u0017\u000e\\5us&#WM\u001c;jM&,'O\u0003\u0003\u0002\u0010\u0006-\u0014!\u0006:fcVL'/\u001a3DCB\f'-\u001b7ji&,7\u000fI\u000b\u0002G\u0006I\u0011/^3vK~#S-\u001d\u000b\u0005\u0003?\u000b)\u000bE\u00025\u0003CK1!a)6\u0005\u0011)f.\u001b;\t\u0011\u0005\u001d\u0016#!AA\u0002\r\f1\u0001\u001f\u00132\u0003\u0019\tX/Z;fA\u0005!\u0011N\\5u+\t\ty*A\u0004eSN\u0004xn]3)\u0007Q\t\u0019\f\u0005\u0003\u00026\u0006mVBAA\\\u0015\u0011\tI,a\u000f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002>\u0006]&A\u0003)sK\u0012+7\u000f\u001e:ps\u0006IAm\u001c)s_\u000e,7o\u001d\u000b\u000b\u0003\u0007\fi.!9\u0002f\u0006=\bCBAc\u0003'\f9.\u0004\u0002\u0002H*!\u0011\u0011ZAf\u0003%\u0001XO\u00197jg\",'OC\u00027\u0003\u001bTA!!\u001a\u0002P*\u0011\u0011\u0011[\u0001\be\u0016\f7\r^8s\u0013\u0011\t).a2\u0003\u000bM3E.\u001e=\u0011\u0007i\nI.C\u0002\u0002\\\u001e\u0012Q#\u00138w_\u000e\fG/[8o/&$\bnQ8oi\u0016DH\u000fC\u0004\u0002`V\u0001\r!!\u001f\u0002\u0019\r\f\u0007/\u00192jY&$\u0018.Z:\t\u000f\u0005\rX\u00031\u0001\u0002X\u0006Q\u0011N\u001c<pG\u0006$\u0018n\u001c8\t\u000f\u0005\u001dX\u00031\u0001\u0002j\u0006qQ.Y5mE>D8+Z:tS>t\u0007c\u00015\u0002l&\u0019\u0011Q^5\u0003\u001d5\u000b\u0017\u000e\u001c2pqN+7o]5p]\"1\u0011\u0011_\u000bA\u0002u\nqA]3rk\u0016\u001cH/\u0001\u0006hKR\u0014V-];fgR$b!a>\u0003\u0010\tE\u0001cBA}\u0005\u0007\u0011I!\u0010\b\u0005\u0003w\fyP\u0004\u0003\u0002V\u0005u\u0018\"\u0001\u001c\n\u0007\t\u0005Q'A\u0004qC\u000e\\\u0017mZ3\n\t\t\u0015!q\u0001\u0002\u0007\u000b&$\b.\u001a:\u000b\u0007\t\u0005Q\u0007\u0005\u0003\u0002z\n-\u0011\u0002\u0002B\u0007\u0005\u000f\u0011\u0011\"\u0012=dKB$\u0018n\u001c8\t\u000f\u0005\u001dh\u00031\u0001\u0002j\"9\u00111\u001d\fA\u0002\tM\u0001\u0003\u0002B\u000b\u0005/i!!a\u001b\n\t\te\u00111\u000e\u0002\u000b\u0013:4xnY1uS>t\u0017AB2sK\u0006$X\r\u0006\u0006\u0003 \t]\"\u0011\nB&\u0005\u001f\u0002b!!2\u0003\"\t\u0015\u0012\u0002\u0002B\u0012\u0003\u000f\u0014QaU'p]>\u0004r\u0001\u000eB\u0014\u0005W\u0011\t$C\u0002\u0003*U\u0012a\u0001V;qY\u0016\u0014\u0004c\u0001 \u0003.%\u0019!qF \u0003\u001d5#ejU3oIJ+7/\u001e7ugB!\u0011\u0011\u0002B\u001a\u0013\u0011\u0011)$a\u0003\u0003#A\u0013xnY3tg&twmQ8oi\u0016DH\u000fC\u0004\u0003:]\u0001\rAa\u000f\u0002\u0011%$WM\u001c;jif\u0004BA!\u0010\u0003F5\u0011!q\b\u0006\u0005\u0005\u0003\u0012\u0019%A\u0003n_\u0012,GN\u0003\u0002GS%!!q\tB \u0005!IE-\u001a8uSRL\bBBAy/\u0001\u0007Q\bC\u0004\u0003N]\u0001\r!!;\u0002\u000fM,7o]5p]\"9!\u0011K\fA\u0002\tE\u0012!\u00059s_\u000e,7o]5oO\u000e{g\u000e^3yi\u0006i1M]3bi\u0016lEIT*f]\u0012$BB!\n\u0003X\te#1\fB3\u0005{BqA!\u0014\u0019\u0001\u0004\tI\u000fC\u0004\u0003:a\u0001\rAa\u000f\t\u000f\tu\u0003\u00041\u0001\u0003`\u0005\tR\u000e\u001a8TK:$7I]3bi&|g.\u00133\u0011\u0007y\u0012\t'C\u0002\u0003d}\u0012\u0011#\u0014#O'\u0016tGm\u0011:fCRLwN\\%e\u0011\u001d\u00119\u0007\u0007a\u0001\u0005S\n\u0001B[:PE*,7\r\u001e\t\u0005\u0005W\u0012I(\u0004\u0002\u0003n)\u0019qJa\u001c\u000b\t\tE$1O\u0001\u0005Y&\u00147OC\u0002G\u0005kR!Aa\u001e\u0002\tAd\u0017-_\u0005\u0005\u0005w\u0012iG\u0001\u0005Kg>\u0013'.Z2u\u0011\u001d\u0011\t\u0006\u0007a\u0001\u0005c\tq\u0002]1sg\u0016lEI\u0014*fcV,7\u000f\u001e\u000b\u0005\u0005\u0007\u0013\t\n\u0005\u0005\u0002z\n\r!Q\u0011BF!\rq$qQ\u0005\u0004\u0005\u0013{$AH'E\u001dN+g\u000e\u001a*fcV,7\u000f^%om\u0006d\u0017\u000eZ#yG\u0016\u0004H/[8o!\rq$QR\u0005\u0004\u0005\u001f{$\u0001F'E\u001dN+g\u000eZ\"sK\u0006$XMU3rk\u0016\u001cH\u000fC\u0004\u0003he\u0001\rA!\u001b\u0002\u000fM,g\u000eZ'E\u001dRQ!q\u0013BS\u0005O\u0013IKa+\u0011\u0011\u0005e(1\u0001BM\u0005?\u0003B!!?\u0003\u001c&!!Q\u0014B\u0004\u0005%!\u0006N]8xC\ndW\rE\u0002?\u0005CK1Aa)@\u0005QiEIT*f]\u0012\u001c%/Z1uKN+8mY3tg\"9!Q\n\u000eA\u0002\u0005%\bb\u0002B\u001d5\u0001\u0007!1\b\u0005\b\u0005;R\u0002\u0019\u0001B0\u0011\u001d\u0011iK\u0007a\u0001\u0005\u0017\u000bAB]3rk\u0016\u001cH/\u00128uef\fAD]3ue&,g/\u001a*fY\u0006$X\rZ'fgN\fw-\u001a*fgVdG\u000f\u0006\u0004\u00034\n\u0015'q\u0019\t\t\u0003s\u0014\u0019A!.\u0003<B\u0019aHa.\n\u0007\tevH\u0001\rN\t:\u001bVM\u001c3O_R4u.\u001e8e\u000bb\u001cW\r\u001d;j_:\u0004BA!0\u0003B6\u0011!q\u0018\u0006\u0004\u0005\u0003J\u0017\u0002\u0002Bb\u0005\u007f\u0013Q\"T3tg\u0006<WMU3tk2$\bb\u0002B'7\u0001\u0007\u0011\u0011\u001e\u0005\b\u0005[[\u0002\u0019\u0001BF\u0003e1\u0018\r\\5eCR,W\n\u0012(O_R\fEN]3bIf\u001cVM\u001c;\u0015\t\t5'Q\u001b\t\t\u0003s\u0014\u0019Aa4\u0003<B\u0019aH!5\n\u0007\tMwHA\u000eN\t:\u001bVM\u001c3BYJ,\u0017\rZ=TK:$X\t_2faRLwN\u001c\u0005\b\u0005/d\u0002\u0019\u0001B^\u0003Q\u0011X\r\\1uK\u0012lUm]:bO\u0016\u0014Vm];mi\u0006!\"-^5mI6\u000b\u0017\u000e\\!oIJ+7\u000f]8og\u0016$\"B!8\u0003v\n]8\u0011AB\u0002!!\tIPa\u0001\u0003\u001a\n}\u0007c\u0002\u001b\u0003(\t\u0005(q\u001e\t\u0005\u0005G\u0014Y/\u0004\u0002\u0003f*!\u0011Q\rBt\u0015\r\u0011IoK\u0001\u0007g\u0016\u0014h/\u001a:\n\t\t5(Q\u001d\u0002\t\u001b\u0006LG.S7qYB\u0019aH!=\n\u0007\tMxHA\u000bN\t:\u001bVM\u001c3De\u0016\fG/\u001a*fgB|gn]3\t\u000f\teR\u00041\u0001\u0003<!9!\u0011`\u000fA\u0002\tm\u0018AB:f]\u0012,'\u000f\u0005\u0003\u0002|\tu\u0018\u0002\u0002B\u0000\u0003\u000f\u0013aa\u0015;sS:<\u0007b\u0002BW;\u0001\u0007!1\u0012\u0005\b\u0007\u000bi\u0002\u0019AB\u0004\u0003=y'/[4j]\u0006dW*Z:tC\u001e,\u0007\u0003BB\u0005\u0007'i!aa\u0003\u000b\t\r51qB\u0001\u0004I>l'bAB\tW\u00051Q.[7fi)LAa!\u0006\u0004\f\t9Q*Z:tC\u001e,\u0017a\u00062vS2$W*Y5m\u0003:$W*[7f\u001b\u0016\u001c8/Y4f))\u0019Yba\u000b\u0004.\rE2Q\u0007\t\bi\t\u001d\"\u0011]B\u000f!\u0011\u0019yba\n\u000e\u0005\r\u0005\"\u0002BB\u0012\u0007K\t\u0001\"\u001b8uKJtW\r\u001e\u0006\u0004\u0001\u0006m\u0012\u0002BB\u0015\u0007C\u00111\"T5nK6+7o]1hK\"9!\u0011 \u0010A\u0002\tm\bbBB\u0018=\u0001\u0007!1`\u0001\ne\u0016\u001c\u0017\u000e]5f]RDqaa\r\u001f\u0001\u0004\u0011Y0A\u0004tk\nTWm\u0019;\t\u000f\r]b\u00041\u0001\u0004:\u0005\u0019Q\u000e\u001a8\u0011\t\rm2qH\u0007\u0003\u0007{Q1aa\u000e,\u0013\u0011\u0019\te!\u0010\u0003\u00075#e*\u0001\thKRl\u0015-\u001b7SK\u000eL\u0007/[3oiR!1qIB%!!\tIPa\u0001\u00036\nm\bbBB\u0003?\u0001\u00071qA\u0001\u0015O\u0016$X\n\u0012(GS:\fGNU3dSBLWM\u001c;\u0015\r\r=3QLB0!!\tIPa\u0001\u0003\u001a\u000eE\u0003\u0003BB*\u00073j!a!\u0016\u000b\t\r]3QH\u0001\u0007M&,G\u000eZ:\n\t\rm3Q\u000b\u0002\u000f\r&t\u0017\r\u001c*fG&\u0004\u0018.\u001a8u\u0011\u001d\u0011i\u000b\ta\u0001\u0005\u0017CqA!\u000f!\u0001\u0004\u0011Y$\u0001\u0005ck&dG-\u0014#O))\u0019Id!\u001a\u0004h\r%4Q\u000e\u0005\b\u0005[\u000b\u0003\u0019\u0001BF\u0011\u001d\u0019)!\ta\u0001\u0007\u000fAqaa\u001b\"\u0001\u0004\u0019\t&\u0001\bgS:\fGNU3dSBLWM\u001c;\t\u000f\r=\u0014\u00051\u0001\u0004r\u0005\trN]5hS:\fGNU3dSBLWM\u001c;\u0011\t\rM31O\u0005\u0005\u0007k\u001a)FA\tPe&<\u0017N\\1m%\u0016\u001c\u0017\u000e]5f]R\f\u0011DY;jY\u0012lEI\u0014%v[\u0006t'+Z1eC\ndW\rV3yiR!!1`B>\u0011\u001d\u0011iK\ta\u0001\u0005\u0017\u000b1CY;jY\u0012lUm]:bO\u0016\u001cVO\u00196fGR$bAa?\u0004\u0002\u000e\r\u0005b\u0002BWG\u0001\u0007!1\u0012\u0005\b\u0007\u000b\u0019\u0003\u0019AB\u0004\u0003i\u0011W/\u001b7e\u001b\u0012s5+\u001a8e\u0007J,\u0017\r^3SKN\u0004xN\\:f)!\u0011yo!#\u0004\f\u000e5\u0005b\u0002BWI\u0001\u0007!1\u0012\u0005\b\u0007o!\u0003\u0019AB\u001d\u0011\u001d\u0019y\t\na\u0001\u0007;\t1\"\\5nK6+7o]1hK\u0006q\u0001/\u0019:tK\u0006\u001bX*Z:tC\u001e,G\u0003BB\u0004\u0007+Cqaa&&\u0001\u0004\u0011Y,\u0001\bnKN\u001c\u0018mZ3SK2\fG/\u001a3")
public class MDNSendMethod
implements MethodRequiringAccountId<MDNSendRequest>,
Startable {
    private final MDNSerializer serializer;
    private final MailQueueFactory<? extends MailQueue> mailQueueFactory;
    private final MessageIdManager messageIdManager;
    private final EmailSetMethod emailSetMethod;
    private final IdentityResolver identityResolver;
    private final MetricFactory metricFactory;
    private final SessionSupplier sessionSupplier;
    private final Invocation.MethodName methodName;
    private final Set<Refined<String, string.Uri>> requiredCapabilities;
    private MailQueue queue;
    private String JMAP_RFC8621_PREFIX;

    @Override
    public Publisher<InvocationWithContext> process(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return MethodRequiringAccountId.process$(this, capabilities, invocation, mailboxSession);
    }

    @Override
    public String JMAP_RFC8621_PREFIX() {
        return this.JMAP_RFC8621_PREFIX;
    }

    @Override
    public void org$apache$james$jmap$method$Method$_setter_$JMAP_RFC8621_PREFIX_$eq(String x$1) {
        this.JMAP_RFC8621_PREFIX = x$1;
    }

    public IdentityResolver identityResolver() {
        return this.identityResolver;
    }

    @Override
    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    @Override
    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    @Override
    public Invocation.MethodName methodName() {
        return this.methodName;
    }

    @Override
    public Set<Refined<String, string.Uri>> requiredCapabilities() {
        return this.requiredCapabilities;
    }

    public MailQueue queue() {
        return this.queue;
    }

    public void queue_$eq(MailQueue x$1) {
        this.queue = x$1;
    }

    public void init() {
        this.queue_$eq(this.mailQueueFactory.createQueue(MailQueueFactory.SPOOL));
    }

    @PreDestroy
    public void dispose() {
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.queue().close()).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 e, Function1<A1, B1> function1) {
                A1 A1 = e;
                EmailSubmissionSetMethod$.MODULE$.LOGGER().debug("error closing queue", e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Throwable e) {
                Throwable throwable = e;
                boolean bl = true;
                return bl;
            }
        });
    }

    public SFlux<InvocationWithContext> doProcess(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession, MDNSendRequest request) {
        return ((SMono)request.identityId().validate().fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)new IllegalArgumentException("The IdentityId cannot be found", (Throwable)e)), (Function1 & Serializable)id -> this.identityResolver().resolveIdentityId((IdentityId)id, mailboxSession))).flatMap((Function1 & Serializable)maybeIdentity -> (SMono)maybeIdentity.map((Function1 & Serializable)identity -> this.create((Identity)identity, request, mailboxSession, invocation.processingContext())).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.error((Throwable)new IdentityIdNotFoundException("The IdentityId cannot be found")))).flatMapMany((Function1 & Serializable)createdResults -> {
            InvocationWithContext explicitInvocation = new InvocationWithContext(new Invocation(invocation.invocation().methodName(), (JsObject)$this.serializer.serializeMDNSendResponse(((MDNSendResults)createdResults._1()).asResponse(request.accountId())).as((Reads)Reads$.MODULE$.JsObjectReads()), invocation.invocation().methodCallId()), (ProcessingContext)createdResults._2());
            SMono emailSetCall = (SMono)request.implicitEmailSetRequest((Function1<MDNSendCreationId, Either<IllegalArgumentException, Option<MessageId>>>)(Function1 & Serializable)sendId -> ((MDNSendResults)createdResults._1()).resolveMessageId((MDNSendCreationId)sendId)).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)maybeEmailSetRequest -> (SMono)maybeEmailSetRequest.map((Function1 & Serializable)emailSetRequest -> $this.emailSetMethod.doProcess(capabilities, invocation, mailboxSession, (EmailSetRequest)emailSetRequest)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty()));
            return SFlux$.MODULE$.concat((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Publisher[]{SMono$.MODULE$.just((Object)explicitInvocation), emailSetCall}));
        });
    }

    @Override
    public Either<Exception, MDNSendRequest> getRequest(MailboxSession mailboxSession, Invocation invocation) {
        Left left;
        JsResult<MDNSendRequest> jsResult = this.serializer.deserializeMDNSendRequest((JsValue)invocation.arguments());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            MDNSendRequest mdnSendRequest = (MDNSendRequest)jsSuccess.value();
            left = mdnSendRequest.validate();
        } else if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            left = package$.MODULE$.Left().apply((Object)new IllegalArgumentException(Json$.MODULE$.stringify(ResponseSerializer$.MODULE$.serialize(jsError))));
        } else {
            throw new MatchError(jsResult);
        }
        return left;
    }

    private SMono<Tuple2<MDNSendResults, ProcessingContext>> create(Identity identity, MDNSendRequest request, MailboxSession session, ProcessingContext processingContext) {
        return SFlux$.MODULE$.fromIterable((Iterable)request.send().view()).fold((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MDNSendResults$.MODULE$.empty()), (Object)processingContext), (Function2 & Serializable)(acc, elem) -> {
            Tuple2 tuple2 = elem;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MDNSendCreationId mdnSendId = (MDNSendCreationId)tuple2._1();
            JsObject jsObject = (JsObject)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)mdnSendId, (Object)jsObject);
            Tuple2 tuple23 = tuple22;
            MDNSendCreationId mdnSendId2 = (MDNSendCreationId)tuple23._1();
            JsObject jsObject2 = (JsObject)tuple23._2();
            Tuple2<MDNSendResults, ProcessingContext> tuple24 = this.createMDNSend(session, identity, mdnSendId2, jsObject2, (ProcessingContext)acc._2());
            if (tuple24 == null) {
                throw new MatchError(tuple24);
            }
            MDNSendResults creationResult = (MDNSendResults)tuple24._1();
            ProcessingContext updatedProcessingContext = (ProcessingContext)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)creationResult, (Object)updatedProcessingContext);
            Tuple2 tuple26 = tuple25;
            MDNSendResults creationResult2 = (MDNSendResults)tuple26._1();
            ProcessingContext updatedProcessingContext2 = (ProcessingContext)tuple26._2();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MDNSendResults$.MODULE$.merge((MDNSendResults)acc._1(), creationResult2)), (Object)updatedProcessingContext2);
        }).subscribeOn(Schedulers.elastic());
    }

    private Tuple2<MDNSendResults, ProcessingContext> createMDNSend(MailboxSession session, Identity identity, MDNSendCreationId mdnSendCreationId, JsObject jsObject, ProcessingContext processingContext) {
        return (Tuple2)this.parseMDNRequest(jsObject).flatMap((Function1 & Serializable)createRequest -> this.sendMDN(session, identity, mdnSendCreationId, (MDNSendCreateRequest)createRequest)).fold((Function1 & Serializable)error -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MDNSendResults$.MODULE$.notSent(mdnSendCreationId, (Throwable)error)), (Object)processingContext), (Function1 & Serializable)creation -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MDNSendResults$.MODULE$.sent((MDNSendCreateSuccess)creation)), (Object)processingContext));
    }

    private Either<MDNSendRequestInvalidException, MDNSendCreateRequest> parseMDNRequest(JsObject jsObject) {
        return MDNSendCreateRequest$.MODULE$.validateProperties(jsObject).flatMap((Function1 & Serializable)validJson -> {
            Left left;
            JsResult<MDNSendCreateRequest> jsResult = $this.serializer.deserializeMDNSendCreateRequest((JsValue)validJson);
            if (jsResult instanceof JsSuccess) {
                JsSuccess jsSuccess = (JsSuccess)jsResult;
                MDNSendCreateRequest createRequest = (MDNSendCreateRequest)jsSuccess.value();
                left = createRequest.validate();
            } else if (jsResult instanceof JsError) {
                JsError jsError = (JsError)jsResult;
                Seq errors = jsError.errors();
                left = package$.MODULE$.Left().apply((Object)MDNSendRequestInvalidException$.MODULE$.parse((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)errors));
            } else {
                throw new MatchError(jsResult);
            }
            return left;
        });
    }

    private Either<Throwable, MDNSendCreateSuccess> sendMDN(MailboxSession session, Identity identity, MDNSendCreationId mdnSendCreationId, MDNSendCreateRequest requestEntry) {
        return this.retrieveRelatedMessageResult(session, requestEntry).flatMap((Function1 & Serializable)mdnRelatedMessageResult -> this.validateMDNNotAlreadySent((MessageResult)mdnRelatedMessageResult).map((Function1 & Serializable)mdnRelatedMessageResultAlready -> {
            Message messageRelated = this.parseAsMessage((MessageResult)mdnRelatedMessageResultAlready);
            return new Tuple2(mdnRelatedMessageResultAlready, (Object)messageRelated);
        }).flatMap((Function1 & Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MessageResult mdnRelatedMessageResultAlready = (MessageResult)tuple2._1();
            Message messageRelated = (Message)tuple2._2();
            Either either = this.buildMailAndResponse(identity, session.getUser().asString(), requestEntry, messageRelated).flatMap((Function1 & Serializable)mailAndResponseAndId -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.queue().enQueue((Mail)mailAndResponseAndId._1())).toEither().map((Function1 & Serializable)x$4 -> {
                BoxedUnit boxedUnit = x$4;
                MDNSendCreateSuccess mDNSendCreateSuccess = new MDNSendCreateSuccess(mdnSendCreationId, (MDNSendCreateResponse)mailAndResponseAndId._2(), mdnRelatedMessageResultAlready.getMessageId());
                return mDNSendCreateSuccess;
            }));
            return either;
        }));
    }

    private Either<MDNSendNotFoundException, MessageResult> retrieveRelatedMessageResult(MailboxSession session, MDNSendCreateRequest requestEntry) {
        return CollectionConverters$.MODULE$.ListHasAsScala(this.messageIdManager.getMessage(requestEntry.forEmailId(), FetchGroup.FULL_CONTENT, session)).asScala().toList().headOption().toRight((Function0 & Serializable)() -> new MDNSendNotFoundException("The reference \"forEmailId\" cannot be found."));
    }

    private Either<MDNSendAlreadySentException, MessageResult> validateMDNNotAlreadySent(MessageResult relatedMessageResult) {
        return relatedMessageResult.getFlags().contains(MDNSend$.MODULE$.MDN_ALREADY_SENT_FLAG()) ? package$.MODULE$.Left().apply((Object)new MDNSendAlreadySentException()) : package$.MODULE$.Right().apply((Object)relatedMessageResult);
    }

    private Either<Throwable, Tuple2<MailImpl, MDNSendCreateResponse>> buildMailAndResponse(Identity identity, String sender, MDNSendCreateRequest requestEntry, Message originalMessage) {
        return this.getMailRecipient(originalMessage).flatMap((Function1 & Serializable)mailRecipient -> this.getMDNFinalRecipient(requestEntry, identity).map((Function1 & Serializable)mdnFinalRecipient -> {
            OriginalRecipient mdnOriginalRecipient = OriginalRecipient.builder().originalRecipient(Text.fromRawText((String)sender)).build();
            MDN mdn = this.buildMDN(requestEntry, originalMessage, (FinalRecipient)mdnFinalRecipient, mdnOriginalRecipient);
            String subject = this.buildMessageSubject(requestEntry, originalMessage);
            Tuple2<MailImpl, MimeMessage> tuple2 = this.buildMailAndMimeMessage(sender, (String)mailRecipient, subject, mdn);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            MailImpl mailImpl = (MailImpl)tuple2._1();
            MimeMessage mimeMessage = (MimeMessage)tuple2._2();
            Tuple3 tuple3 = new Tuple3(tuple2, (Object)mailImpl, (Object)mimeMessage);
            Tuple3 tuple32 = tuple3;
            Tuple2 x$6 = (Tuple2)tuple32._1();
            MailImpl mailImpl2 = (MailImpl)tuple32._2();
            MimeMessage mimeMessage2 = (MimeMessage)tuple32._3();
            return new Tuple5(mdnFinalRecipient, (Object)mdnOriginalRecipient, (Object)mdn, (Object)subject, (Object)x$6);
        }).map((Function1 & Serializable)x$8 -> {
            Tuple2 tuple2;
            MDN mdn;
            block3: {
                Tuple5 tuple5;
                block2: {
                    tuple5 = x$8;
                    if (tuple5 == null) break block2;
                    mdn = (MDN)tuple5._3();
                    tuple2 = (Tuple2)tuple5._5();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple5);
            }
            MailImpl mailImpl = (MailImpl)tuple2._1();
            MimeMessage mimeMessage = (MimeMessage)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)mailImpl, (Object)this.buildMDNSendCreateResponse(requestEntry, mdn, mimeMessage));
            return tuple22;
        }));
    }

    private Tuple2<MailImpl, MimeMessage> buildMailAndMimeMessage(String sender, String recipient, String subject, MDN mdn) {
        MimeMessage mimeMessage = mdn.asMimeMessage();
        mimeMessage.setFrom(sender);
        mimeMessage.setRecipients(Message.RecipientType.TO, recipient);
        mimeMessage.setSubject(subject);
        mimeMessage.saveChanges();
        MailImpl mailImpl = MailImpl.builder().name((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)MDNId$.MODULE$.generate().value()), RefType$.MODULE$.refinedRefType())).sender(sender).addRecipient(recipient).mimeMessage(mimeMessage).build();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mailImpl), (Object)mimeMessage);
    }

    private Either<MDNSendNotFoundException, String> getMailRecipient(Message originalMessage) {
        return CollectionConverters$.MODULE$.ListHasAsScala(originalMessage.getHeader().getFields(MDN$.MODULE$.DISPOSITION_NOTIFICATION_TO())).asScala().headOption().map((Function1 & Serializable)field -> (AddressListField)AddressListFieldLenientImpl.PARSER.parse(field, new DecodeMonitor())).map((Function1 & Serializable)addressListField -> addressListField.getAddressList()).map((Function1 & Serializable)addressList -> addressList.flatten()).flatMap((Function1 & Serializable)mailboxList -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mailboxList.stream().findAny()))).map((Function1 & Serializable)mailbox -> mailbox.getAddress()).toRight((Function0 & Serializable)() -> new MDNSendNotFoundException("Invalid \"Disposition-Notification-To\" header field."));
    }

    private Either<Throwable, FinalRecipient> getMDNFinalRecipient(MDNSendCreateRequest requestEntry, Identity identity) {
        return (Either)requestEntry.finalRecipient().map((Function1 & Serializable)finalRecipient -> MDNSendMethod.$anonfun$getMDNFinalRecipient$1(((FinalRecipientField)finalRecipient).value())).map((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            Right right = null;
            Either either = x0$1;
            if (either instanceof Right) {
                bl = true;
                right = (Right)either;
                MailAddress mailAddress = (MailAddress)right.value();
                if (mailAddress.equals((Object)identity.email())) {
                    return package$.MODULE$.Right().apply(FinalRecipientField$.MODULE$.asJava$extension(((FinalRecipientField)requestEntry.finalRecipient().get()).value()).get());
                }
            }
            if (bl) {
                return package$.MODULE$.Left().apply((Object)new MDNSendForbiddenFromException("The user is not allowed to use the given \"finalRecipient\" property"));
            }
            if (!(either instanceof Left)) throw new MatchError((Object)either);
            Left left = (Left)either;
            Throwable error = (Throwable)left.value();
            return package$.MODULE$.Left().apply((Object)error);
        }).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Right().apply((Object)FinalRecipient.builder().finalRecipient(Text.fromRawText((String)identity.email().asString())).build()));
    }

    private MDN buildMDN(MDNSendCreateRequest requestEntry, Message originalMessage, FinalRecipient finalRecipient, OriginalRecipient originalRecipient) {
        MDNReport.Builder reportBuilder = MDNReport.builder().dispositionField((Disposition)requestEntry.disposition().asJava().get()).finalRecipientField(finalRecipient).originalRecipientField(originalRecipient);
        CollectionConverters$.MODULE$.ListHasAsScala(originalMessage.getHeader().getFields("Message-ID")).asScala().map((Function1 & Serializable)field -> reportBuilder.originalMessageIdField(field.getBody()));
        requestEntry.reportingUA().map((Function1 & Serializable)uaField -> MDNSendMethod.$anonfun$buildMDN$2(reportBuilder, ((ReportUAField)uaField).value()));
        requestEntry.extensionFields().map((Function1 & Serializable)extensions -> (scala.collection.immutable.Iterable)extensions.map((Function1 & Serializable)extension2 -> reportBuilder.withExtensionField(ExtensionField.builder().fieldName(((ExtensionFieldName)extension2._1()).value()).rawValue(((ExtensionFieldValue)extension2._2()).value()).build())));
        CollectionConverters$.MODULE$.ListHasAsScala(originalMessage.getHeader().getFields(EmailHeaderName$.MODULE$.MESSAGE_ID())).asScala().headOption().map((Function1 & Serializable)messageIdHeader -> reportBuilder.originalMessageIdField(TextHeaderValue$.MODULE$.from((Field)messageIdHeader).value()));
        return MDN.builder().report(reportBuilder.build()).humanReadableText(this.buildMDNHumanReadableText(requestEntry)).message(OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(requestEntry.includeOriginalMessage().filter((Function1 & Serializable)isInclude -> BoxesRunTime.boxToBoolean((boolean)((IncludeOriginalMessageField)isInclude).value())).map((Function1 & Serializable)x$9 -> originalMessage)))).build();
    }

    private String buildMDNHumanReadableText(MDNSendCreateRequest requestEntry) {
        return (String)requestEntry.textBody().map((Function1 & Serializable)textBody -> ((TextBodyField)textBody).value()).getOrElse((Function0 & Serializable)() -> new StringBuilder(48).append("The email has been ").append(requestEntry.disposition().type()).append(" on your recipient's computer").toString());
    }

    private String buildMessageSubject(MDNSendCreateRequest requestEntry, Message originalMessage) {
        return (String)requestEntry.subject().map((Function1 & Serializable)subject -> ((SubjectField)subject).value()).getOrElse((Function0 & Serializable)() -> new StringBuilder(11).append("[Received] ").append(originalMessage.getSubject()).toString());
    }

    private MDNSendCreateResponse buildMDNSendCreateResponse(MDNSendCreateRequest requestEntry, MDN mdn, MimeMessage mimeMessage) {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        None$ none$5;
        Option<SubjectField> option = requestEntry.subject();
        if (option instanceof Some) {
            none$5 = None$.MODULE$;
        } else if (None$.MODULE$.equals(option)) {
            none$5 = new Some((Object)new SubjectField(mimeMessage.getSubject()));
        } else {
            throw new MatchError(option);
        }
        None$ x$1 = none$5;
        Option<TextBodyField> option2 = requestEntry.textBody();
        if (option2 instanceof Some) {
            none$4 = None$.MODULE$;
        } else if (None$.MODULE$.equals(option2)) {
            none$4 = new Some((Object)new TextBodyField(mdn.getHumanReadableText()));
        } else {
            throw new MatchError(option2);
        }
        None$ x$2 = none$4;
        Option<ReportUAField> option3 = requestEntry.reportingUA();
        if (option3 instanceof Some) {
            none$3 = None$.MODULE$;
        } else if (None$.MODULE$.equals(option3)) {
            none$3 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mdn.getReport().getReportingUserAgentField().map(ua -> new ReportUAField(ua.fieldValue()))));
        } else {
            throw new MatchError(option3);
        }
        None$ x$3 = none$3;
        Option x$4 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mdn.getReport().getGatewayField().map(gateway -> new MDNGatewayField(gateway.fieldValue()))));
        Option x$5 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mdn.getReport().getOriginalRecipientField().map(originalRecipient -> new OriginalRecipientField(originalRecipient.fieldValue()))));
        Option<IncludeOriginalMessageField> option4 = requestEntry.includeOriginalMessage();
        if (option4 instanceof Some) {
            none$2 = None$.MODULE$;
        } else if (None$.MODULE$.equals(option4)) {
            none$2 = new Some((Object)new IncludeOriginalMessageField(mdn.getOriginalMessage().isPresent()));
        } else {
            throw new MatchError(option4);
        }
        None$ x$6 = none$2;
        Option x$7 = Option$.MODULE$.apply((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(mdn.getReport().getErrorFields()).asScala().map((Function1 & Serializable)error -> new ErrorField(MDNSendMethod.$anonfun$buildMDNSendCreateResponse$4(error)))).toSeq()).filter((Function1 & Serializable)error -> BoxesRunTime.boxToBoolean((boolean)error.nonEmpty()));
        Option<FinalRecipientField> option5 = requestEntry.finalRecipient();
        if (option5 instanceof Some) {
            none$ = None$.MODULE$;
        } else if (None$.MODULE$.equals(option5)) {
            none$ = new Some((Object)new FinalRecipientField(mdn.getReport().getFinalRecipientField().fieldValue()));
        } else {
            throw new MatchError(option5);
        }
        None$ x$8 = none$;
        Option x$9 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mdn.getReport().getOriginalMessageIdField().map(originalMessageId -> new OriginalMessageIdField(originalMessageId.getOriginalMessageId()))));
        return new MDNSendCreateResponse((Option<SubjectField>)x$1, (Option<TextBodyField>)x$2, (Option<ReportUAField>)x$3, (Option<MDNGatewayField>)x$4, (Option<OriginalRecipientField>)x$5, (Option<FinalRecipientField>)x$8, (Option<IncludeOriginalMessageField>)x$6, (Option<OriginalMessageIdField>)x$9, (Option<scala.collection.immutable.Seq<ErrorField>>)x$7);
    }

    private Message parseAsMessage(MessageResult messageRelated) {
        DefaultMessageBuilder messageBuilder = new DefaultMessageBuilder();
        messageBuilder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
        messageBuilder.setDecodeMonitor(DecodeMonitor.SILENT);
        return messageBuilder.parseMessage(messageRelated.getFullContent().getInputStream());
    }

    public static final /* synthetic */ Either $anonfun$getMDNFinalRecipient$1(String finalRecipient) {
        return FinalRecipientField$.MODULE$.getMailAddress$extension(finalRecipient).toEither();
    }

    public static final /* synthetic */ Try $anonfun$buildMDN$2(MDNReport.Builder reportBuilder$1, String uaField) {
        return ReportUAField$.MODULE$.asJava$extension(uaField).map((Function1 & Serializable)reportingUserAgent -> reportBuilder$1.reportingUserAgentField(reportingUserAgent));
    }

    public static final /* synthetic */ String $anonfun$buildMDNSendCreateResponse$4(Error error) {
        return error.getText().formatted();
    }

    @Inject
    public MDNSendMethod(MDNSerializer serializer, MailQueueFactory<? extends MailQueue> mailQueueFactory, MessageIdManager messageIdManager, EmailSetMethod emailSetMethod, IdentityResolver identityResolver, MetricFactory metricFactory, SessionSupplier sessionSupplier) {
        this.serializer = serializer;
        this.mailQueueFactory = mailQueueFactory;
        this.messageIdManager = messageIdManager;
        this.emailSetMethod = emailSetMethod;
        this.identityResolver = identityResolver;
        this.metricFactory = metricFactory;
        this.sessionSupplier = sessionSupplier;
        Method.$init$(this);
        MethodRequiringAccountId.$init$(this);
        this.methodName = new Invocation.MethodName((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"MDN/send")).value());
        this.requiredCapabilities = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_MDN()), new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_MAIL()), new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_CORE())}));
        Statics.releaseFence();
    }
}

